/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.search.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.IndexedTraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.NumberHelper;
import org.javatuples.Pair;
import org.javatuples.Triplet;

public class ShortestPathVertexProgram
implements VertexProgram<Triplet<Path, Edge, Number>> {
    public static final String SHORTEST_PATHS = "gremlin.shortestPathVertexProgram.shortestPaths";
    private static final String SOURCE_VERTEX_FILTER = "gremlin.shortestPathVertexProgram.sourceVertexFilter";
    private static final String TARGET_VERTEX_FILTER = "gremlin.shortestPathVertexProgram.targetVertexFilter";
    private static final String EDGE_TRAVERSAL = "gremlin.shortestPathVertexProgram.edgeTraversal";
    private static final String DISTANCE_TRAVERSAL = "gremlin.shortestPathVertexProgram.distanceTraversal";
    private static final String MAX_DISTANCE = "gremlin.shortestPathVertexProgram.maxDistance";
    private static final String INCLUDE_EDGES = "gremlin.shortestPathVertexProgram.includeEdges";
    private static final String STATE = "gremlin.shortestPathVertexProgram.state";
    private static final String PATHS = "gremlin.shortestPathVertexProgram.paths";
    private static final String VOTE_TO_HALT = "gremlin.shortestPathVertexProgram.voteToHalt";
    private static final int SEARCH = 0;
    private static final int COLLECT_PATHS = 1;
    private static final int UPDATE_HALTED_TRAVERSERS = 2;
    public static final PureTraversal<Vertex, ?> DEFAULT_VERTEX_FILTER_TRAVERSAL = new PureTraversal(__.identity().asAdmin());
    public static final PureTraversal<Vertex, Edge> DEFAULT_EDGE_TRAVERSAL = new PureTraversal(__.bothE(new String[0]).asAdmin());
    public static final PureTraversal<Edge, Number> DEFAULT_DISTANCE_TRAVERSAL = new PureTraversal(__.start().constant(1).asAdmin());
    private TraverserSet<Vertex> haltedTraversers;
    private IndexedTraverserSet<Vertex, Vertex> haltedTraversersIndex;
    private PureTraversal<?, ?> traversal;
    private PureTraversal<Vertex, ?> sourceVertexFilterTraversal = DEFAULT_VERTEX_FILTER_TRAVERSAL.clone();
    private PureTraversal<Vertex, ?> targetVertexFilterTraversal = DEFAULT_VERTEX_FILTER_TRAVERSAL.clone();
    private PureTraversal<Vertex, Edge> edgeTraversal = DEFAULT_EDGE_TRAVERSAL.clone();
    private PureTraversal<Edge, Number> distanceTraversal = DEFAULT_DISTANCE_TRAVERSAL.clone();
    private Step<Vertex, Path> programStep;
    private Number maxDistance;
    private boolean distanceEqualsNumberOfHops;
    private boolean includeEdges;
    private boolean standalone;
    private static final Set<VertexComputeKey> VERTEX_COMPUTE_KEYS = new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of("gremlin.shortestPathVertexProgram.paths", true), VertexComputeKey.of("gremlin.traversalVertexProgram.haltedTraversers", false)));
    private final Set<MemoryComputeKey> memoryComputeKeys = new HashSet<MemoryComputeKey>(Arrays.asList(MemoryComputeKey.of("gremlin.shortestPathVertexProgram.voteToHalt", Operator.and, false, true), MemoryComputeKey.of("gremlin.shortestPathVertexProgram.state", Operator.assign, true, true)));

    private ShortestPathVertexProgram() {
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        if (configuration.containsKey(SOURCE_VERTEX_FILTER)) {
            this.sourceVertexFilterTraversal = PureTraversal.loadState(configuration, SOURCE_VERTEX_FILTER, graph);
        }
        if (configuration.containsKey(TARGET_VERTEX_FILTER)) {
            this.targetVertexFilterTraversal = PureTraversal.loadState(configuration, TARGET_VERTEX_FILTER, graph);
        }
        if (configuration.containsKey(EDGE_TRAVERSAL)) {
            this.edgeTraversal = PureTraversal.loadState(configuration, EDGE_TRAVERSAL, graph);
        }
        if (configuration.containsKey(DISTANCE_TRAVERSAL)) {
            this.distanceTraversal = PureTraversal.loadState(configuration, DISTANCE_TRAVERSAL, graph);
        }
        if (configuration.containsKey(MAX_DISTANCE)) {
            this.maxDistance = (Number)configuration.getProperty(MAX_DISTANCE);
        }
        this.distanceEqualsNumberOfHops = this.distanceTraversal.equals(DEFAULT_DISTANCE_TRAVERSAL);
        this.includeEdges = configuration.getBoolean(INCLUDE_EDGES, false);
        boolean bl = this.standalone = !configuration.containsKey("gremlin.vertexProgramStep.rootTraversal");
        if (!this.standalone) {
            this.traversal = PureTraversal.loadState(configuration, "gremlin.vertexProgramStep.rootTraversal", graph);
            String programStepId = configuration.getString("gremlin.vertexProgramStep.stepId");
            for (Step step : this.traversal.get().getSteps()) {
                if (!step.getId().equals(programStepId)) continue;
                this.programStep = step;
                break;
            }
        }
        this.haltedTraversers = TraversalVertexProgram.loadHaltedTraversers(configuration);
        this.haltedTraversersIndex = new IndexedTraverserSet<Vertex, Vertex>(v -> v);
        for (Traverser.Admin<Vertex> admin : this.haltedTraversers) {
            this.haltedTraversersIndex.add(admin.split());
        }
        this.memoryComputeKeys.add(MemoryComputeKey.of(SHORTEST_PATHS, Operator.addAll, true, !this.standalone));
    }

    @Override
    public void storeState(Configuration configuration) {
        VertexProgram.super.storeState(configuration);
        this.sourceVertexFilterTraversal.storeState(configuration, SOURCE_VERTEX_FILTER);
        this.targetVertexFilterTraversal.storeState(configuration, TARGET_VERTEX_FILTER);
        this.edgeTraversal.storeState(configuration, EDGE_TRAVERSAL);
        this.distanceTraversal.storeState(configuration, DISTANCE_TRAVERSAL);
        configuration.setProperty(INCLUDE_EDGES, this.includeEdges);
        if (this.maxDistance != null) {
            configuration.setProperty(MAX_DISTANCE, this.maxDistance);
        }
        if (this.traversal != null) {
            this.traversal.storeState(configuration, "gremlin.vertexProgramStep.rootTraversal");
            configuration.setProperty("gremlin.vertexProgramStep.stepId", this.programStep.getId());
        }
        TraversalVertexProgram.storeHaltedTraversers(configuration, this.haltedTraversers);
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return VERTEX_COMPUTE_KEYS;
    }

    @Override
    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return this.memoryComputeKeys;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return Collections.emptySet();
    }

    @Override
    public VertexProgram<Triplet<Path, Edge, Number>> clone() {
        try {
            ShortestPathVertexProgram clone = (ShortestPathVertexProgram)super.clone();
            if (null != this.edgeTraversal) {
                clone.edgeTraversal = this.edgeTraversal.clone();
            }
            if (null != this.sourceVertexFilterTraversal) {
                clone.sourceVertexFilterTraversal = this.sourceVertexFilterTraversal.clone();
            }
            if (null != this.targetVertexFilterTraversal) {
                clone.targetVertexFilterTraversal = this.targetVertexFilterTraversal.clone();
            }
            if (null != this.distanceTraversal) {
                clone.distanceTraversal = this.distanceTraversal.clone();
            }
            if (null != this.traversal) {
                clone.traversal = this.traversal.clone();
                for (Step step : clone.traversal.get().getSteps()) {
                    if (!step.getId().equals(this.programStep.getId())) continue;
                    clone.programStep = step;
                    break;
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.ORIGINAL;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.NOTHING;
    }

    @Override
    public void setup(Memory memory) {
        memory.set(VOTE_TO_HALT, true);
        memory.set(STATE, 0);
    }

    @Override
    public void execute(Vertex vertex, Messenger<Triplet<Path, Edge, Number>> messenger, Memory memory) {
        switch ((Integer)memory.get(STATE)) {
            case 1: {
                this.collectShortestPaths(vertex, memory);
                return;
            }
            case 2: {
                this.updateHaltedTraversers(vertex, memory);
                return;
            }
        }
        boolean voteToHalt = true;
        if (memory.isInitialIteration()) {
            this.copyHaltedTraversersFromMemory(vertex);
            if (!this.isStartVertex(vertex)) {
                return;
            }
            HashMap paths = new HashMap();
            HashSet<Path> pathSet = new HashSet<Path>();
            Path path = ShortestPathVertexProgram.makePath(vertex);
            pathSet.add(path);
            paths.put(vertex, Pair.with(0, pathSet));
            vertex.property(VertexProperty.Cardinality.single, PATHS, paths, new Object[0]);
            this.processEdges(vertex, path, 0, messenger);
            voteToHalt = false;
        } else {
            Map paths = vertex.property(PATHS).orElseGet(HashMap::new);
            Iterator<Triplet<Path, Edge, Number>> iterator = messenger.receiveMessages();
            while (iterator.hasNext()) {
                Triplet<Path, Edge, Number> triplet = iterator.next();
                Path sourcePath = triplet.getValue0();
                Number distance = triplet.getValue2();
                Vertex sourceVertex = (Vertex)sourcePath.get(0);
                Path newPath = null;
                if (paths.containsKey(sourceVertex)) {
                    Number currentShortestDistance = (Number)((Pair)paths.get(sourceVertex)).getValue0();
                    int cmp = NumberHelper.compare(distance, currentShortestDistance);
                    if (cmp <= 0) {
                        newPath = ShortestPathVertexProgram.extendPath(sourcePath, triplet.getValue1(), vertex);
                        if (cmp < 0) {
                            HashSet<Path> pathSet = new HashSet<Path>();
                            pathSet.add(newPath);
                            paths.put(sourceVertex, Pair.with(distance, pathSet));
                        } else {
                            ((Set)((Pair)paths.get(sourceVertex)).getValue1()).add(newPath);
                        }
                    }
                } else if (!this.exceedsMaxDistance(distance)) {
                    HashSet<Path> pathSet = new HashSet<Path>();
                    newPath = ShortestPathVertexProgram.extendPath(sourcePath, triplet.getValue1(), vertex);
                    pathSet.add(newPath);
                    paths.put(sourceVertex, Pair.with(distance, pathSet));
                }
                if (newPath == null) continue;
                vertex.property(VertexProperty.Cardinality.single, PATHS, paths, new Object[0]);
                this.processEdges(vertex, newPath, distance, messenger);
                voteToHalt = false;
            }
        }
        memory.add(VOTE_TO_HALT, voteToHalt);
    }

    @Override
    public boolean terminate(Memory memory) {
        boolean voteToHalt;
        if (memory.isInitialIteration() && this.haltedTraversersIndex != null) {
            this.haltedTraversersIndex.clear();
        }
        if (voteToHalt = ((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
            int state = (Integer)memory.get(STATE);
            if (state == 1) {
                if (this.standalone) {
                    return true;
                }
                memory.set(STATE, 2);
                return false;
            }
            if (state == 2) {
                return true;
            }
            memory.set(STATE, 1);
            return false;
        }
        memory.set(VOTE_TO_HALT, true);
        return false;
    }

    public String toString() {
        ArrayList<String> options = new ArrayList<String>();
        Function<String, String> shortName = name -> name.substring(name.lastIndexOf(".") + 1);
        if (!this.sourceVertexFilterTraversal.equals(DEFAULT_VERTEX_FILTER_TRAVERSAL)) {
            options.add(shortName.apply(SOURCE_VERTEX_FILTER) + "=" + this.sourceVertexFilterTraversal.get());
        }
        if (!this.targetVertexFilterTraversal.equals(DEFAULT_VERTEX_FILTER_TRAVERSAL)) {
            options.add(shortName.apply(TARGET_VERTEX_FILTER) + "=" + this.targetVertexFilterTraversal.get());
        }
        if (!this.edgeTraversal.equals(DEFAULT_EDGE_TRAVERSAL)) {
            options.add(shortName.apply(EDGE_TRAVERSAL) + "=" + this.edgeTraversal.get());
        }
        if (!this.distanceTraversal.equals(DEFAULT_DISTANCE_TRAVERSAL)) {
            options.add(shortName.apply(DISTANCE_TRAVERSAL) + "=" + this.distanceTraversal.get());
        }
        options.add(shortName.apply(INCLUDE_EDGES) + "=" + this.includeEdges);
        return StringFactory.vertexProgramString(this, String.join((CharSequence)", ", options));
    }

    private void copyHaltedTraversersFromMemory(Vertex vertex) {
        Collection<Traverser.Admin<Vertex>> traversers = this.haltedTraversersIndex.get(vertex);
        if (traversers != null) {
            TraverserSet newHaltedTraversers = new TraverserSet();
            newHaltedTraversers.addAll(traversers);
            vertex.property(VertexProperty.Cardinality.single, "gremlin.traversalVertexProgram.haltedTraversers", newHaltedTraversers, new Object[0]);
        }
    }

    private static Path makePath(Vertex newVertex) {
        return ShortestPathVertexProgram.extendPath(null, newVertex);
    }

    private static Path extendPath(Path currentPath, Element ... elements) {
        Path result = ImmutablePath.make();
        if (currentPath != null) {
            for (Object e : currentPath.objects()) {
                result = result.extend(e, Collections.emptySet());
            }
        }
        for (Element element : elements) {
            if (element == null) continue;
            result = result.extend(ReferenceFactory.detach(element), Collections.emptySet());
        }
        return result;
    }

    private boolean isStartVertex(Vertex vertex) {
        if (this.standalone) {
            Traversal.Admin<Vertex, ?> filterTraversal = this.sourceVertexFilterTraversal.getPure();
            filterTraversal.addStart(filterTraversal.getTraverserGenerator().generate(vertex, filterTraversal.getStartStep(), 1L));
            return filterTraversal.hasNext();
        }
        return vertex.property("gremlin.traversalVertexProgram.haltedTraversers").isPresent();
    }

    private boolean isEndVertex(Vertex vertex) {
        Traversal.Admin<Vertex, ?> filterTraversal = this.targetVertexFilterTraversal.getPure();
        Step<Vertex, ?> startStep = filterTraversal.getStartStep();
        filterTraversal.addStart(filterTraversal.getTraverserGenerator().generate(vertex, startStep, 1L));
        return filterTraversal.hasNext();
    }

    private void processEdges(Vertex vertex, Path currentPath, Number currentDistance, Messenger<Triplet<Path, Edge, Number>> messenger) {
        Traversal.Admin<Vertex, Edge> edgeTraversal = this.edgeTraversal.getPure();
        edgeTraversal.addStart(edgeTraversal.getTraverserGenerator().generate(vertex, edgeTraversal.getStartStep(), 1L));
        while (edgeTraversal.hasNext()) {
            Edge edge = (Edge)edgeTraversal.next();
            Number distance = this.getDistance(edge);
            Vertex otherV = edge.inVertex();
            if (otherV.equals(vertex)) {
                otherV = edge.outVertex();
            }
            if (currentPath.objects().contains(otherV)) continue;
            messenger.sendMessage(MessageScope.Global.of(otherV), Triplet.with(currentPath, this.includeEdges ? edge : null, NumberHelper.add(currentDistance, distance)));
        }
    }

    private void updateHaltedTraversers(Vertex vertex, Memory memory) {
        if (this.isStartVertex(vertex)) {
            List paths = (List)memory.get(SHORTEST_PATHS);
            if (vertex.property("gremlin.traversalVertexProgram.haltedTraversers").isPresent()) {
                TraverserSet haltedTraversers = (TraverserSet)vertex.value("gremlin.traversalVertexProgram.haltedTraversers");
                TraverserSet<Path> newHaltedTraversers = new TraverserSet<Path>();
                for (Traverser.Admin traverser : haltedTraversers) {
                    Vertex v = (Vertex)traverser.get();
                    for (Path path : paths) {
                        if (!path.get(0).equals(v)) continue;
                        newHaltedTraversers.add(traverser.split(path, this.programStep));
                    }
                }
                vertex.property(VertexProperty.Cardinality.single, "gremlin.traversalVertexProgram.haltedTraversers", newHaltedTraversers, new Object[0]);
            }
        }
    }

    private Number getDistance(Edge edge) {
        if (this.distanceEqualsNumberOfHops) {
            return 1;
        }
        Traversal.Admin<Edge, Number> traversal = this.distanceTraversal.getPure();
        traversal.addStart(traversal.getTraverserGenerator().generate(edge, traversal.getStartStep(), 1L));
        return traversal.tryNext().orElse(0);
    }

    private boolean exceedsMaxDistance(Number distance) {
        return this.distanceEqualsNumberOfHops && this.maxDistance != null && NumberHelper.compare(distance, this.maxDistance) > 0;
    }

    private void collectShortestPaths(Vertex vertex, Memory memory) {
        Property pathProperty = vertex.property(PATHS);
        if (pathProperty.isPresent()) {
            Map paths = (Map)pathProperty.value();
            ArrayList<Path> result = new ArrayList<Path>();
            for (Pair pair : paths.values()) {
                for (Path path : (Set)pair.getValue1()) {
                    if (!this.isEndVertex(vertex) || !this.distanceEqualsNumberOfHops && this.maxDistance != null && NumberHelper.compare((Number)pair.getValue0(), this.maxDistance) > 0) continue;
                    result.add(path);
                }
            }
            pathProperty.remove();
            memory.add(SHORTEST_PATHS, result);
        }
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresGlobalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(ShortestPathVertexProgram.class);
        }

        public Builder source(Traversal<Vertex, ?> sourceVertexFilter) {
            if (null == sourceVertexFilter) {
                throw Graph.Exceptions.argumentCanNotBeNull("sourceVertexFilter");
            }
            PureTraversal.storeState(this.configuration, ShortestPathVertexProgram.SOURCE_VERTEX_FILTER, sourceVertexFilter.asAdmin());
            return this;
        }

        public Builder target(Traversal<Vertex, ?> targetVertexFilter) {
            if (null == targetVertexFilter) {
                throw Graph.Exceptions.argumentCanNotBeNull("targetVertexFilter");
            }
            PureTraversal.storeState(this.configuration, ShortestPathVertexProgram.TARGET_VERTEX_FILTER, targetVertexFilter.asAdmin());
            return this;
        }

        public Builder edgeDirection(Direction direction) {
            if (null == direction) {
                throw Graph.Exceptions.argumentCanNotBeNull("direction");
            }
            return this.edgeTraversal(__.toE(direction, new String[0]));
        }

        public Builder edgeTraversal(Traversal<Vertex, Edge> edgeTraversal) {
            if (null == edgeTraversal) {
                throw Graph.Exceptions.argumentCanNotBeNull("edgeTraversal");
            }
            PureTraversal.storeState(this.configuration, ShortestPathVertexProgram.EDGE_TRAVERSAL, edgeTraversal.asAdmin());
            return this;
        }

        public Builder distanceProperty(String distance) {
            return distance != null ? this.distanceTraversal(__.values(distance)) : this.distanceTraversal(DEFAULT_DISTANCE_TRAVERSAL.getPure());
        }

        public Builder distanceTraversal(Traversal<Edge, Number> distanceTraversal) {
            if (null == distanceTraversal) {
                throw Graph.Exceptions.argumentCanNotBeNull("distanceTraversal");
            }
            PureTraversal.storeState(this.configuration, ShortestPathVertexProgram.DISTANCE_TRAVERSAL, distanceTraversal.asAdmin());
            return this;
        }

        public Builder maxDistance(Number distance) {
            if (null != distance) {
                this.configuration.setProperty(ShortestPathVertexProgram.MAX_DISTANCE, distance);
            } else {
                this.configuration.clearProperty(ShortestPathVertexProgram.MAX_DISTANCE);
            }
            return this;
        }

        public Builder includeEdges(boolean include) {
            this.configuration.setProperty(ShortestPathVertexProgram.INCLUDE_EDGES, include);
            return this;
        }
    }
}

