/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote;

import java.util.concurrent.CompletableFuture;
import org.apache.tinkerpop.gremlin.jsr223.JavaTranslator;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.EmbeddedRemoteTraversal;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;

public class EmbeddedRemoteConnection
implements RemoteConnection {
    private final GraphTraversalSource g;

    public EmbeddedRemoteConnection(GraphTraversalSource g) {
        this.g = g;
    }

    @Override
    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(Bytecode bytecode) throws RemoteConnectionException {
        CompletableFuture promise = new CompletableFuture();
        try {
            promise.complete(new EmbeddedRemoteTraversal(JavaTranslator.of(this.g).translate(bytecode)));
        }
        catch (Exception t) {
            promise.completeExceptionally(t);
        }
        return promise;
    }

    @Override
    public void close() throws Exception {
        this.g.close();
    }
}

