/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Comparator;
import java.util.Random;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public enum Order implements Comparator<Object>
{
    incr{

        @Override
        public int compare(Object first, Object second) {
            return asc.compare(first, second);
        }

        @Override
        public Order reversed() {
            return decr;
        }
    }
    ,
    decr{

        @Override
        public int compare(Object first, Object second) {
            return desc.compare(first, second);
        }

        @Override
        public Order reversed() {
            return incr;
        }
    }
    ,
    shuffle{

        @Override
        public int compare(Object first, Object second) {
            return RANDOM.nextBoolean() ? -1 : 1;
        }

        @Override
        public Order reversed() {
            return shuffle;
        }
    }
    ,
    asc{

        @Override
        public int compare(Object first, Object second) {
            Object f = first instanceof Enum ? ((Enum)first).name() : first;
            Object s = second instanceof Enum ? ((Enum)second).name() : second;
            return f instanceof Number && s instanceof Number ? NumberHelper.compare((Number)f, (Number)s).intValue() : Comparator.naturalOrder().compare((Comparable)f, (Comparable)s);
        }

        @Override
        public Order reversed() {
            return desc;
        }
    }
    ,
    desc{

        @Override
        public int compare(Object first, Object second) {
            Object f = first instanceof Enum ? ((Enum)first).name() : first;
            Object s = second instanceof Enum ? ((Enum)second).name() : second;
            return f instanceof Number && s instanceof Number ? NumberHelper.compare((Number)s, (Number)f).intValue() : Comparator.reverseOrder().compare((Comparable)f, (Comparable)s);
        }

        @Override
        public Order reversed() {
            return asc;
        }
    };

    private static final Random RANDOM;

    @Override
    public abstract int compare(Object var1, Object var2);

    public abstract Order reversed();

    static {
        RANDOM = new Random();
    }
}

