/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.branch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.PredicateTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.javatuples.Pair;

public class BranchStep<S, E, M>
extends ComputerAwareStep<S, E>
implements TraversalOptionParent<M, S, E> {
    protected Traversal.Admin<S, M> branchTraversal;
    protected Map<TraversalOptionParent.Pick, List<Traversal.Admin<S, E>>> traversalPickOptions = new HashMap<TraversalOptionParent.Pick, List<Traversal.Admin<S, E>>>();
    protected List<Pair<Traversal.Admin, Traversal.Admin<S, E>>> traversalOptions = new ArrayList<Pair<Traversal.Admin, Traversal.Admin<S, E>>>();
    private boolean first = true;
    private boolean hasBarrier;

    public BranchStep(Traversal.Admin traversal) {
        super(traversal);
    }

    public void setBranchTraversal(Traversal.Admin<S, M> branchTraversal) {
        this.branchTraversal = this.integrateChild(branchTraversal);
    }

    @Override
    public void addGlobalChildOption(M pickToken, Traversal.Admin<S, E> traversalOption) {
        if (pickToken instanceof TraversalOptionParent.Pick) {
            if (this.traversalPickOptions.containsKey(pickToken)) {
                this.traversalPickOptions.get(pickToken).add(traversalOption);
            } else {
                this.traversalPickOptions.put((TraversalOptionParent.Pick)((Object)pickToken), new ArrayList<Traversal.Admin<S, E>>(Collections.singletonList(traversalOption)));
            }
        } else {
            Traversal.Admin pickOptionTraversal = pickToken instanceof Traversal ? ((Traversal)pickToken).asAdmin() : new PredicateTraversal(pickToken);
            this.traversalOptions.add(Pair.with(pickOptionTraversal, traversalOption));
        }
        if (TraversalHelper.hasStepOfAssignableClass(ReducingBarrierStep.class, traversalOption)) {
            traversalOption.addStep(0, new IdentityStep(traversalOption));
        }
        traversalOption.addStep(new ComputerAwareStep.EndStep(traversalOption));
        if (!this.hasBarrier && !TraversalHelper.getStepsOfAssignableClassRecursively(Barrier.class, traversalOption).isEmpty()) {
            this.hasBarrier = true;
        }
        this.integrateChild(traversalOption);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(new TraverserRequirement[0]);
    }

    @Override
    public List<Traversal.Admin<S, E>> getGlobalChildren() {
        return Collections.unmodifiableList(Stream.concat(this.traversalPickOptions.values().stream().flatMap(Collection::stream), this.traversalOptions.stream().map(Pair::getValue1)).collect(Collectors.toList()));
    }

    public List<Traversal.Admin<S, M>> getLocalChildren() {
        return Collections.singletonList(this.branchTraversal);
    }

    @Override
    protected Iterator<Traverser.Admin<E>> standardAlgorithm() {
        block0: while (true) {
            if (!this.first) {
                for (Traversal.Admin<S, E> option : this.getGlobalChildren()) {
                    if (!option.getStartStep().hasNext() || !option.hasNext()) continue;
                    return option.getEndStep();
                }
            }
            this.first = false;
            if (this.hasBarrier) {
                if (!this.starts.hasNext()) {
                    throw FastNoSuchElementException.instance();
                }
                while (true) {
                    if (!this.starts.hasNext()) continue block0;
                    this.applyCurrentTraverser((Traverser.Admin<S>)this.starts.next());
                }
            }
            this.applyCurrentTraverser((Traverser.Admin<S>)this.starts.next());
        }
    }

    private void applyCurrentTraverser(Traverser.Admin<S> start) {
        List<Traversal.Admin<S, E>> anyBranch;
        M choice = TraversalUtil.apply(start, this.branchTraversal);
        List<Traversal.Admin<S, E>> branches = this.pickBranches(choice);
        if (null != branches) {
            branches.forEach(traversal -> traversal.addStart(start.split()));
        }
        if (choice != TraversalOptionParent.Pick.any && null != (anyBranch = this.traversalPickOptions.get((Object)TraversalOptionParent.Pick.any))) {
            anyBranch.forEach(traversal -> traversal.addStart(start.split()));
        }
    }

    @Override
    protected Iterator<Traverser.Admin<E>> computerAlgorithm() {
        List<Traversal.Admin<S, E>> anyBranch;
        ArrayList ends = new ArrayList();
        Object start = this.starts.next();
        M choice = TraversalUtil.apply(start, this.branchTraversal);
        List<Traversal.Admin<S, E>> branches = this.pickBranches(choice);
        if (null != branches) {
            branches.forEach(arg_0 -> BranchStep.lambda$computerAlgorithm$2((Traverser.Admin)start, ends, arg_0));
        }
        if (choice != TraversalOptionParent.Pick.any && null != (anyBranch = this.traversalPickOptions.get((Object)TraversalOptionParent.Pick.any))) {
            anyBranch.forEach(arg_0 -> BranchStep.lambda$computerAlgorithm$3((Traverser.Admin)start, ends, arg_0));
        }
        return ends.iterator();
    }

    private List<Traversal.Admin<S, E>> pickBranches(Object choice) {
        ArrayList<Traversal.Admin<S, Traversal.Admin<S, E>>> branches = new ArrayList<Traversal.Admin<S, Traversal.Admin<S, E>>>();
        if (choice instanceof TraversalOptionParent.Pick && this.traversalPickOptions.containsKey(choice)) {
            branches.addAll((Collection)this.traversalPickOptions.get(choice));
        }
        for (Pair<Traversal.Admin, Traversal.Admin<S, E>> p : this.traversalOptions) {
            if (!TraversalUtil.test(choice, p.getValue0())) continue;
            branches.add(p.getValue1());
        }
        return branches.isEmpty() ? this.traversalPickOptions.get((Object)TraversalOptionParent.Pick.none) : branches;
    }

    @Override
    public BranchStep<S, E, M> clone() {
        BranchStep clone = (BranchStep)super.clone();
        clone.traversalPickOptions = new HashMap<TraversalOptionParent.Pick, List<Traversal.Admin<S, E>>>(this.traversalPickOptions.size());
        clone.traversalOptions = new ArrayList<Pair<Traversal.Admin, Traversal.Admin<S, E>>>(this.traversalOptions.size());
        for (Map.Entry<TraversalOptionParent.Pick, List<Traversal.Admin<S, E>>> entry : this.traversalPickOptions.entrySet()) {
            List<Traversal.Admin<S, E>> traversals = entry.getValue();
            if (traversals.size() <= 0) continue;
            List clonedTraversals = clone.traversalPickOptions.compute(entry.getKey(), (k, v) -> v == null ? new ArrayList(traversals.size()) : v);
            for (Traversal.Admin<S, E> traversal : traversals) {
                clonedTraversals.add(traversal.clone());
            }
        }
        for (Pair pair : this.traversalOptions) {
            clone.traversalOptions.add(Pair.with(((Traversal.Admin)pair.getValue0()).clone(), ((Traversal.Admin)pair.getValue1()).clone()));
        }
        clone.branchTraversal = this.branchTraversal.clone();
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.branchTraversal);
        this.getGlobalChildren().forEach(this::integrateChild);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.traversalPickOptions != null) {
            result ^= this.traversalPickOptions.hashCode();
        }
        if (this.traversalOptions != null) {
            result ^= this.traversalOptions.hashCode();
        }
        if (this.branchTraversal != null) {
            result ^= this.branchTraversal.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        List combinedOptions = Stream.concat(this.traversalPickOptions.entrySet().stream().map(e -> Pair.with(e.getKey(), e.getValue())), this.traversalOptions.stream()).collect(Collectors.toList());
        return StringFactory.stepString(this, this.branchTraversal, combinedOptions);
    }

    @Override
    public void reset() {
        super.reset();
        this.getGlobalChildren().forEach(Traversal.Admin::reset);
        this.first = true;
    }

    private static /* synthetic */ void lambda$computerAlgorithm$3(Traverser.Admin start, List ends, Traversal.Admin traversal) {
        Traverser.Admin split = start.split();
        split.setStepId(traversal.getStartStep().getId());
        ends.add(split);
    }

    private static /* synthetic */ void lambda$computerAlgorithm$2(Traverser.Admin start, List ends, Traversal.Admin traversal) {
        Traverser.Admin split = start.split();
        split.setStepId(traversal.getStartStep().getId());
        ends.add(split);
    }
}

