/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class HasStep<S extends Element>
extends FilterStep<S>
implements HasContainerHolder {
    private List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public HasStep(Traversal.Admin traversal, HasContainer ... hasContainers) {
        super(traversal);
        Collections.addAll(this.hasContainers, hasContainers);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (traverser.get() instanceof Element) {
            return HasContainer.testAll((Element)traverser.get(), this.hasContainers);
        }
        if (traverser.get() instanceof Property) {
            return HasContainer.testAll((Property)traverser.get(), this.hasContainers);
        }
        throw new IllegalStateException(String.format("Traverser to has() must be of type Property or Element, not %s", ((Element)traverser.get()).getClass().getName()));
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.hasContainers);
    }

    @Override
    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    @Override
    public void removeHasContainer(HasContainer hasContainer) {
        this.hasContainers.remove(hasContainer);
    }

    @Override
    public void addHasContainer(HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return EnumSet.of(TraverserRequirement.OBJECT);
    }

    @Override
    public HasStep<S> clone() {
        HasStep clone = (HasStep)super.clone();
        clone.hasContainers = new ArrayList<HasContainer>();
        for (HasContainer hasContainer : this.hasContainers) {
            clone.addHasContainer(hasContainer.clone());
        }
        return clone;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        for (HasContainer hasContainer : this.hasContainers) {
            result ^= hasContainer.hashCode();
        }
        return result;
    }
}

