/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.star;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONUtil;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.structure.util.star.DirectionalStarGraph;
import org.apache.tinkerpop.gremlin.structure.util.star.StarGraph;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerationException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonProcessingException;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class StarGraphGraphSONSerializerV1d0
extends StdSerializer<DirectionalStarGraph> {
    private final boolean normalize;

    public StarGraphGraphSONSerializerV1d0(boolean normalize) {
        super(DirectionalStarGraph.class);
        this.normalize = normalize;
    }

    @Override
    public void serialize(DirectionalStarGraph starGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        this.ser(starGraph, jsonGenerator, serializerProvider, null);
    }

    @Override
    public void serializeWithType(DirectionalStarGraph starGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        this.ser(starGraph, jsonGenerator, serializerProvider, typeSerializer);
    }

    private void ser(DirectionalStarGraph directionalStarGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        StarGraph starGraph = directionalStarGraph.getStarGraphToSerialize();
        jsonGenerator.writeStartObject();
        if (typeSerializer != null) {
            jsonGenerator.writeStringField("@class", HashMap.class.getName());
        }
        GraphSONUtil.writeWithType("id", starGraph.starVertex.id, jsonGenerator, serializerProvider, typeSerializer);
        jsonGenerator.writeStringField("label", starGraph.starVertex.label);
        if (directionalStarGraph.getDirection() != null) {
            this.writeEdges(directionalStarGraph, jsonGenerator, serializerProvider, typeSerializer, Direction.IN);
        }
        if (directionalStarGraph.getDirection() != null) {
            this.writeEdges(directionalStarGraph, jsonGenerator, serializerProvider, typeSerializer, Direction.OUT);
        }
        if (starGraph.starVertex.vertexProperties != null && !starGraph.starVertex.vertexProperties.isEmpty()) {
            jsonGenerator.writeObjectFieldStart("properties");
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            Set<String> keys = this.normalize ? new TreeSet<String>(starGraph.starVertex.vertexProperties.keySet()) : starGraph.starVertex.vertexProperties.keySet();
            for (String k : keys) {
                List<VertexProperty> vp = starGraph.starVertex.vertexProperties.get(k);
                jsonGenerator.writeArrayFieldStart(k);
                if (typeSerializer != null) {
                    jsonGenerator.writeString(ArrayList.class.getName());
                    jsonGenerator.writeStartArray();
                }
                List<VertexProperty> vertexProperties = this.normalize ? StarGraphGraphSONSerializerV1d0.sort(vp, Comparators.PROPERTY_COMPARATOR) : vp;
                for (VertexProperty property : vertexProperties) {
                    Iterator metaProperties;
                    jsonGenerator.writeStartObject();
                    if (typeSerializer != null) {
                        jsonGenerator.writeStringField("@class", HashMap.class.getName());
                    }
                    GraphSONUtil.writeWithType("id", property.id(), jsonGenerator, serializerProvider, typeSerializer);
                    GraphSONUtil.writeWithType("value", property.value(), jsonGenerator, serializerProvider, typeSerializer);
                    Iterator iterator = metaProperties = this.normalize ? IteratorUtils.list(property.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : property.properties(new String[0]);
                    if (metaProperties.hasNext()) {
                        jsonGenerator.writeObjectFieldStart("properties");
                        if (typeSerializer != null) {
                            jsonGenerator.writeStringField("@class", HashMap.class.getName());
                        }
                        while (metaProperties.hasNext()) {
                            Property meta = metaProperties.next();
                            GraphSONUtil.writeWithType(meta.key(), meta.value(), jsonGenerator, serializerProvider, typeSerializer);
                        }
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                if (typeSerializer == null) continue;
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    private void writeEdges(DirectionalStarGraph directionalStarGraph, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, Direction direction) throws IOException, JsonProcessingException {
        boolean writeEdges;
        StarGraph starGraph = directionalStarGraph.getStarGraphToSerialize();
        Direction edgeDirectionToSerialize = directionalStarGraph.getDirection();
        Map<String, List<Edge>> starEdges = direction.equals((Object)Direction.OUT) ? starGraph.starVertex.outEdges : starGraph.starVertex.inEdges;
        boolean bl = writeEdges = null != starEdges && edgeDirectionToSerialize != null && (edgeDirectionToSerialize == direction || edgeDirectionToSerialize == Direction.BOTH);
        if (writeEdges) {
            jsonGenerator.writeObjectFieldStart(direction == Direction.IN ? "inE" : "outE");
            if (typeSerializer != null) {
                jsonGenerator.writeStringField("@class", HashMap.class.getName());
            }
            Set<String> keys = this.normalize ? new TreeSet<String>(starEdges.keySet()) : starEdges.keySet();
            for (String k : keys) {
                List<Edge> edges = starEdges.get(k);
                jsonGenerator.writeArrayFieldStart(k);
                if (typeSerializer != null) {
                    jsonGenerator.writeString(ArrayList.class.getName());
                    jsonGenerator.writeStartArray();
                }
                List<Edge> edgesToWrite = this.normalize ? StarGraphGraphSONSerializerV1d0.sort(edges, Comparators.EDGE_COMPARATOR) : edges;
                for (Edge edge : edgesToWrite) {
                    Iterator edgeProperties;
                    jsonGenerator.writeStartObject();
                    if (typeSerializer != null) {
                        jsonGenerator.writeStringField("@class", HashMap.class.getName());
                    }
                    GraphSONUtil.writeWithType("id", edge.id(), jsonGenerator, serializerProvider, typeSerializer);
                    GraphSONUtil.writeWithType(direction.equals((Object)Direction.OUT) ? "inV" : "outV", direction.equals((Object)Direction.OUT) ? edge.inVertex().id() : edge.outVertex().id(), jsonGenerator, serializerProvider, typeSerializer);
                    Iterator iterator = edgeProperties = this.normalize ? IteratorUtils.list(edge.properties(new String[0]), Comparators.PROPERTY_COMPARATOR).iterator() : edge.properties(new String[0]);
                    if (edgeProperties.hasNext()) {
                        jsonGenerator.writeObjectFieldStart("properties");
                        if (typeSerializer != null) {
                            jsonGenerator.writeStringField("@class", HashMap.class.getName());
                        }
                        while (edgeProperties.hasNext()) {
                            Property meta = edgeProperties.next();
                            GraphSONUtil.writeWithType(meta.key(), meta.value(), jsonGenerator, serializerProvider, typeSerializer);
                        }
                        jsonGenerator.writeEndObject();
                    }
                    jsonGenerator.writeEndObject();
                }
                jsonGenerator.writeEndArray();
                if (typeSerializer == null) continue;
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
    }

    static <S> List<S> sort(List<S> listToSort, Comparator comparator) {
        Collections.sort(listToSort, comparator);
        return listToSort;
    }
}

