/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.apache.tinkerpop.gremlin.util.iterator.StoreIteratorCounter;

public class TinkerGraphIterator<E>
implements CloseableIterator<E> {
    private Iterator<E> orig;
    private E next;
    private boolean finished;

    public TinkerGraphIterator(Iterator<E> orig) {
        this.orig = orig;
        StoreIteratorCounter.INSTANCE.increment();
        this.finished = false;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        return this.tryComputeNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        E ret = this.next;
        this.tryComputeNext();
        return ret;
    }

    private boolean tryComputeNext() {
        try {
            this.next = this.orig.next();
            return true;
        }
        catch (NoSuchElementException ex) {
            this.close();
            this.next = null;
            return false;
        }
    }

    @Override
    public void close() {
        if (!this.finished) {
            StoreIteratorCounter.INSTANCE.decrement();
        }
        this.finished = true;
    }
}

