/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.diskstorage.util.ReadArrayBuffer;
import org.janusgraph.graphdb.database.idhandling.VariableLong;

public class GeoshapeSerializer
implements AttributeSerializer<Geoshape> {
    @Override
    public void verifyAttribute(Geoshape value) {
    }

    @Override
    public Geoshape convert(Object value) {
        if (value instanceof Map) {
            return this.convertGeoJson(value);
        }
        if (value instanceof Collection) {
            value = this.convertCollection((Collection)value);
        }
        if (value.getClass().isArray() && (value.getClass().getComponentType().isPrimitive() || Number.class.isAssignableFrom(value.getClass().getComponentType()))) {
            int len = Array.getLength(value);
            double[] arr = new double[len];
            for (int i = 0; i < len; ++i) {
                arr[i] = ((Number)Array.get(value, i)).doubleValue();
            }
            switch (len) {
                case 2: {
                    return Geoshape.point(arr[0], arr[1]);
                }
                case 3: {
                    return Geoshape.circle(arr[0], arr[1], arr[2]);
                }
                case 4: {
                    return Geoshape.box(arr[0], arr[1], arr[2], arr[3]);
                }
            }
            throw new IllegalArgumentException("Expected 2-4 coordinates to create Geoshape, but given: " + value);
        }
        if (value instanceof String) {
            String delimiter;
            String[] components = null;
            String[] arr = new String[]{",", ";"};
            int i = arr.length;
            for (int j = 0; j < i && ((components = ((String)value).split(delimiter = arr[j])).length < 2 || components.length > 4); ++j) {
                components = null;
            }
            Preconditions.checkNotNull((Object)components, (String)"Could not parse coordinates from string: %s", (Object[])new Object[]{value});
            double[] coordinates = new double[components.length];
            try {
                for (i = 0; i < components.length; ++i) {
                    coordinates[i] = Double.parseDouble(components[i]);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse coordinates from string: " + value, e);
            }
            return this.convert(coordinates);
        }
        return null;
    }

    private double[] convertCollection(Collection<Object> c) {
        List numbers = c.stream().map(o -> {
            if (!(o instanceof Number)) {
                throw new IllegalArgumentException("Collections may only contain numbers to create a Geoshape");
            }
            return ((Number)o).doubleValue();
        }).collect(Collectors.toList());
        return Doubles.toArray(numbers);
    }

    private Geoshape convertGeoJson(Object value) {
        try {
            Map map = (Map)value;
            String type = (String)map.get("type");
            if ("Feature".equals(type)) {
                Map geometry = (Map)map.get("geometry");
                return this.convertGeometry(geometry);
            }
            return this.convertGeometry(map);
        }
        catch (IOException | ClassCastException | ParseException e) {
            throw new IllegalArgumentException("GeoJSON was unparsable");
        }
    }

    private Geoshape convertGeometry(Map<String, Object> geometry) throws IOException, ParseException {
        String type = (String)geometry.get("type");
        List coordinates = (List)geometry.get("coordinates");
        switch (type) {
            case "Point": {
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.point(parsedCoordinates[1], parsedCoordinates[0]);
            }
            case "Circle": {
                Number radius = (Number)geometry.get("radius");
                if (radius == null) {
                    throw new IllegalArgumentException("GeoJSON circles require a radius");
                }
                double[] parsedCoordinates = this.convertCollection(coordinates);
                return Geoshape.circle(parsedCoordinates[1], parsedCoordinates[0], radius.doubleValue());
            }
            case "Polygon": {
                if (coordinates.size() != 4) break;
                double[] p0 = this.convertCollection((Collection)coordinates.get(0));
                double[] p1 = this.convertCollection((Collection)coordinates.get(1));
                double[] p2 = this.convertCollection((Collection)coordinates.get(2));
                double[] p3 = this.convertCollection((Collection)coordinates.get(3));
                if ((p0[0] != p1[0] || p1[1] != p2[1] || p2[0] != p3[0] || p3[1] != p0[1] || p3[0] == p0[0]) && (p0[1] != p1[1] || p1[0] != p2[0] || p2[1] != p3[1] || p3[0] != p0[0] || p3[1] == p0[1])) break;
                return Geoshape.box(this.min(p0[1], p1[1], p2[1], p3[1]), this.min(p0[0], p1[0], p2[0], p3[0]), this.max(p0[1], p1[1], p2[1], p3[1]), this.max(p0[0], p1[0], p2[0], p3[0]));
            }
        }
        String json = Geoshape.mapWriter.writeValueAsString(geometry);
        return new Geoshape(Geoshape.HELPER.getGeojsonReader().read(new StringReader(json)));
    }

    private double min(double ... numbers) {
        return Arrays.stream(numbers).min().getAsDouble();
    }

    private double max(double ... numbers) {
        return Arrays.stream(numbers).max().getAsDouble();
    }

    @Override
    public Geoshape read(ScanBuffer buffer) {
        long l = VariableLong.readPositive(buffer);
        assert (l > 0L && l < Integer.MAX_VALUE);
        int length = (int)l;
        int position = ((ReadArrayBuffer)buffer).getPosition();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer.getBytes(length));
        try {
            return Geoshape.GeoshapeBinarySerializer.read(inputStream);
        }
        catch (IOException e) {
            try {
                ((ReadArrayBuffer)buffer).movePositionTo(position);
                float lat = buffer.getFloat();
                float lon = buffer.getFloat();
                return Geoshape.point(lat, lon);
            }
            catch (Exception exception) {
                throw new RuntimeException("I/O exception reading geoshape", e);
            }
        }
    }

    @Override
    public void write(WriteBuffer buffer, Geoshape attribute) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Geoshape.GeoshapeBinarySerializer.write(outputStream, attribute);
            byte[] bytes = outputStream.toByteArray();
            VariableLong.writePositive(buffer, bytes.length);
            buffer.putBytes(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O exception writing geoshape", e);
        }
    }
}

