/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.BackendQuery;
import org.janusgraph.graphdb.query.BaseQuery;
import org.janusgraph.graphdb.query.condition.Condition;

public class IndexQuery
extends BaseQuery
implements BackendQuery<IndexQuery> {
    public static final ImmutableList<OrderEntry> NO_ORDER = ImmutableList.of();
    private final String store;
    private final Condition condition;
    private final ImmutableList<OrderEntry> orders;
    private final int hashcode;

    public IndexQuery(String store, Condition condition, ImmutableList<OrderEntry> orders, int limit) {
        super(limit);
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkNotNull((Object)condition);
        Preconditions.checkArgument((orders != null ? 1 : 0) != 0);
        this.condition = condition;
        this.orders = orders;
        this.store = store;
        this.hashcode = Objects.hash(condition, store, orders, limit);
    }

    public IndexQuery(String store, Condition condition, ImmutableList<OrderEntry> orders) {
        this(store, condition, orders, Integer.MAX_VALUE);
    }

    public IndexQuery(String store, Condition condition) {
        this(store, condition, NO_ORDER, Integer.MAX_VALUE);
    }

    public IndexQuery(String store, Condition condition, int limit) {
        this(store, condition, NO_ORDER, limit);
    }

    public Condition<JanusGraphElement> getCondition() {
        return this.condition;
    }

    public List<OrderEntry> getOrder() {
        return this.orders;
    }

    public String getStore() {
        return this.store;
    }

    @Override
    public IndexQuery setLimit(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexQuery updateLimit(int newLimit) {
        return new IndexQuery(this.store, this.condition, this.orders, newLimit);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        IndexQuery oth = (IndexQuery)other;
        return this.store.equals(oth.store) && this.orders.equals(oth.orders) && this.condition.equals(oth.condition) && this.getLimit() == oth.getLimit();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[").append(this.condition.toString()).append("]");
        if (!this.orders.isEmpty()) {
            b.append(this.orders);
        }
        if (this.hasLimit()) {
            b.append("(").append(this.getLimit()).append(")");
        }
        b.append(":").append(this.store);
        return b.toString();
    }

    public static class OrderEntry {
        private final String key;
        private final Order order;
        private final Class<?> datatype;

        public OrderEntry(String key, Order order, Class<?> datatype) {
            Preconditions.checkNotNull((Object)key);
            Preconditions.checkNotNull((Object)((Object)order));
            Preconditions.checkNotNull(datatype);
            this.key = key;
            this.order = order;
            this.datatype = datatype;
        }

        public String getKey() {
            return this.key;
        }

        public Order getOrder() {
            return this.order;
        }

        public Class<?> getDatatype() {
            return this.datatype;
        }

        public int hashCode() {
            return this.key.hashCode() * 4021 + this.order.hashCode();
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            if (oth == null) {
                return false;
            }
            if (!this.getClass().isInstance(oth)) {
                return false;
            }
            OrderEntry o = (OrderEntry)oth;
            return this.key.equals(o.key) && this.order == o.order;
        }

        public String toString() {
            return (Object)((Object)this.order) + "(" + this.key + ")";
        }
    }
}

