/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.graphdb.query.BaseQuery;

public class RawQuery
extends BaseQuery {
    private final String store;
    private final String query;
    private final Parameter[] parameters;
    private ImmutableList<IndexQuery.OrderEntry> orders;
    private int offset;

    public RawQuery(String store, String query, Parameter[] parameters) {
        this(store, query, (ImmutableList<IndexQuery.OrderEntry>)ImmutableList.of(), parameters);
    }

    public RawQuery(String store, String query, ImmutableList<IndexQuery.OrderEntry> orders, Parameter[] parameters) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank(query));
        Preconditions.checkNotNull(orders);
        Preconditions.checkNotNull((Object)parameters);
        this.store = store;
        this.query = query;
        this.parameters = parameters;
        this.offset = 0;
        this.orders = orders;
    }

    public RawQuery setOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (Object[])new Object[]{offset});
        this.offset = offset;
        return this;
    }

    @Override
    public RawQuery setLimit(int limit) {
        super.setLimit(limit);
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getStore() {
        return this.store;
    }

    public String getQuery() {
        return this.query;
    }

    public ImmutableList<IndexQuery.OrderEntry> getOrders() {
        return this.orders;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public static class Result<O> {
        private final O result;
        private final double score;

        public Result(O result, double score) {
            this.result = result;
            this.score = score;
        }

        public O getResult() {
            return this.result;
        }

        public double getScore() {
            return this.score;
        }
    }
}

