/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.locking;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import org.janusgraph.diskstorage.util.KeyColumn;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLockMediator<T> {
    private static final Logger log = LoggerFactory.getLogger(LocalLockMediator.class);
    private final String name;
    private final TimestampProvider times;
    private final ConcurrentHashMap<KeyColumn, AuditRecord<T>> locks = new ConcurrentHashMap();

    public LocalLockMediator(String name, TimestampProvider times) {
        this.name = name;
        this.times = times;
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)times);
    }

    public boolean lock(KeyColumn kc, T requester, Instant expires) {
        assert (null != kc);
        assert (null != requester);
        StackTraceElement[] acquiredAt = log.isTraceEnabled() ? new Throwable("Lock acquisition by " + requester).getStackTrace() : null;
        AuditRecord audit = new AuditRecord(requester, expires, acquiredAt);
        AuditRecord inMap = this.locks.putIfAbsent(kc, audit);
        boolean success = false;
        if (null == inMap) {
            if (log.isTraceEnabled()) {
                log.trace("New local lock created: {} namespace={} txn={}", new Object[]{kc, this.name, requester});
            }
            success = true;
        } else if (inMap.equals(audit)) {
            success = this.locks.replace(kc, inMap, audit);
            if (log.isTraceEnabled()) {
                if (success) {
                    log.trace("Updated local lock expiration: {} namespace={} txn={} oldexp={} newexp={}", new Object[]{kc, this.name, requester, inMap.expires, audit.expires});
                } else {
                    log.trace("Failed to update local lock expiration: {} namespace={} txn={} oldexp={} newexp={}", new Object[]{kc, this.name, requester, inMap.expires, audit.expires});
                }
            }
        } else if (0 > inMap.expires.compareTo(this.times.getTime())) {
            success = this.locks.replace(kc, inMap, audit);
            if (log.isTraceEnabled()) {
                log.trace("Discarding expired lock: {} namespace={} txn={} expired={}", new Object[]{kc, this.name, inMap.holder, inMap.expires});
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Local lock failed: {} namespace={} txn={} (already owned by {})", new Object[]{kc, this.name, requester, inMap});
            log.trace("Owner stacktrace:\n        {}", (Object)Joiner.on((String)"\n        ").join((Object[])inMap.acquiredAt));
        }
        return success;
    }

    public boolean unlock(KeyColumn kc, T requester) {
        if (!this.locks.containsKey(kc)) {
            log.error("Local unlock failed: no locks found for {}", (Object)kc);
            return false;
        }
        AuditRecord unlocker = new AuditRecord(requester, null, null);
        AuditRecord holder = (AuditRecord)this.locks.get(kc);
        if (!holder.equals(unlocker)) {
            log.error("Local unlock of {} by {} failed: it is held by {}", new Object[]{kc, unlocker, holder});
            return false;
        }
        boolean removed = this.locks.remove(kc, unlocker);
        if (removed) {
            if (log.isTraceEnabled()) {
                log.trace("Local unlock succeeded: {} namespace={} txn={}", new Object[]{kc, this.name, requester});
            }
        } else {
            log.warn("Local unlock warning: lock record for {} disappeared during removal; this suggests the lock either expired while we were removing it, or that it was erroneously unlocked multiple times.", (Object)kc);
        }
        return true;
    }

    public String toString() {
        return "LocalLockMediator [" + this.name + ",  ~" + this.locks.size() + " current locks]";
    }

    private static class AuditRecord<T> {
        private final T holder;
        private final Instant expires;
        private int hashCode;
        private final StackTraceElement[] acquiredAt;

        private AuditRecord(T holder, Instant expires, StackTraceElement[] acquiredAt) {
            this.holder = holder;
            this.expires = expires;
            this.acquiredAt = acquiredAt;
        }

        public int hashCode() {
            if (0 == this.hashCode) {
                this.hashCode = this.holder.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AuditRecord other = (AuditRecord)obj;
            if (this.holder == null) {
                return other.holder == null;
            }
            return this.holder.equals(other.holder);
        }

        public String toString() {
            return "AuditRecord [txn=" + this.holder + ", expires=" + this.expires + "]";
        }
    }
}

