/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.util.MetricInstrumentedStore;
import org.janusgraph.diskstorage.util.RecordIterator;

public class MetricInstrumentedIterator
implements KeyIterator {
    private final KeyIterator iterator;
    private final String p;
    private static final String M_HAS_NEXT = "hasNext";
    private static final String M_NEXT = "next";
    static final String M_CLOSE = "close";

    public static MetricInstrumentedIterator of(KeyIterator keyIterator, String ... prefix) {
        if (keyIterator == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)prefix);
        return new MetricInstrumentedIterator(keyIterator, StringUtils.join((Object[])prefix, "."));
    }

    private MetricInstrumentedIterator(KeyIterator i, String p) {
        this.iterator = i;
        this.p = p;
    }

    @Override
    public boolean hasNext() {
        return MetricInstrumentedStore.runWithMetrics(this.p, M_HAS_NEXT, this.iterator::hasNext);
    }

    @Override
    public StaticBuffer next() {
        return MetricInstrumentedStore.runWithMetrics(this.p, M_NEXT, this.iterator::next);
    }

    @Override
    public void close() throws IOException {
        MetricInstrumentedStore.runWithMetrics(this.p, M_CLOSE, () -> {
            this.iterator.close();
            return null;
        });
    }

    @Override
    public RecordIterator<Entry> getEntries() {
        return this.iterator.getEntries();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

