/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class ShortArraySerializer
extends ArraySerializer
implements AttributeSerializer<short[]> {
    @Override
    public short[] convert(Object value) {
        return (short[])this.convertInternal(value, Short.TYPE, Short.class);
    }

    @Override
    protected Object getArray(int length) {
        return new short[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setShort(array, pos, (Short)value);
    }

    @Override
    public short[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getShorts(length);
    }

    @Override
    public void write(WriteBuffer buffer, short[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (short anAttribute : attribute) {
                buffer.putShort(anAttribute);
            }
        }
    }
}

