/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.RelationType;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class QueryContainer {
    public static final int DEFAULT_HARD_QUERY_LIMIT = 100000;
    public static final String QUERY_NAME_PREFIX = "query$";
    private final StandardJanusGraphTx tx;
    private final int hardQueryLimit;
    private final Set<Query> queries;
    private final SetMultimap<SliceQuery, Query> inverseQueries;

    public QueryContainer(StandardJanusGraphTx tx) {
        this.tx = (StandardJanusGraphTx)Preconditions.checkNotNull((Object)tx);
        this.queries = new HashSet<Query>(6);
        this.inverseQueries = HashMultimap.create();
        this.hardQueryLimit = 100000;
    }

    public JanusGraphTransaction getTransaction() {
        return this.tx;
    }

    public QueryBuilder addQuery() {
        return new QueryBuilder();
    }

    Set<Query> getQueries(SliceQuery slice) {
        return this.inverseQueries.get((Object)slice);
    }

    Iterable<Query> getQueries() {
        return this.queries;
    }

    public List<SliceQuery> getSliceQueries() {
        ArrayList<SliceQuery> slices = new ArrayList<SliceQuery>(this.queries.size() * 2);
        for (Query q : this.getQueries()) {
            for (SliceQuery slice : q.getSlices()) {
                if (slices.contains(slice)) continue;
                slices.add(slice);
            }
        }
        return slices;
    }

    public class QueryBuilder
    extends BasicVertexCentricQueryBuilder<QueryBuilder> {
        private QueryBuilder() {
            super(QueryContainer.this.tx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Query relations(RelationCategory returnType) {
            BaseVertexCentricQuery vq = super.constructQuery(returnType);
            ArrayList<SliceQuery> slices = new ArrayList<SliceQuery>(vq.numSubQueries());
            for (int i = 0; i < vq.numSubQueries(); ++i) {
                BackendQueryHolder<SliceQuery> bq = vq.getSubQuery(i);
                SliceQuery sq = bq.getBackendQuery();
                slices.add(sq.updateLimit(bq.isFitted() ? vq.getLimit() : QueryContainer.this.hardQueryLimit));
            }
            Query q = new Query(slices, returnType);
            Set set = QueryContainer.this.queries;
            synchronized (set) {
                Preconditions.checkArgument((!QueryContainer.this.queries.contains(q) ? 1 : 0) != 0, (String)"Query has already been added: %s", (Object[])new Object[]{q});
                QueryContainer.this.queries.add(q);
                for (SliceQuery sq : slices) {
                    QueryContainer.this.inverseQueries.put((Object)sq, (Object)q);
                }
            }
            return q;
        }

        @Override
        protected QueryBuilder getThis() {
            return this;
        }

        public void edges() {
            this.relations(RelationCategory.EDGE);
        }

        public void relations() {
            this.relations(RelationCategory.RELATION);
        }

        public void properties() {
            this.relations(RelationCategory.PROPERTY);
        }

        @Override
        public QueryBuilder has(String type, Object value) {
            super.has(type, value);
            return this;
        }

        @Override
        public QueryBuilder hasNot(String key, Object value) {
            super.hasNot(key, value);
            return this;
        }

        @Override
        public QueryBuilder has(String key) {
            super.has(key);
            return this;
        }

        @Override
        public QueryBuilder hasNot(String key) {
            super.hasNot(key);
            return this;
        }

        @Override
        public QueryBuilder has(String key, JanusGraphPredicate predicate, Object value) {
            super.has(key, predicate, value);
            return this;
        }

        @Override
        public <T extends Comparable<?>> QueryBuilder interval(String key, T start, T end) {
            super.interval(key, start, end);
            return this;
        }

        @Override
        public QueryBuilder types(RelationType ... types) {
            super.types(types);
            return this;
        }

        @Override
        public QueryBuilder labels(String ... labels) {
            super.labels(labels);
            return this;
        }

        @Override
        public QueryBuilder keys(String ... keys) {
            super.keys(keys);
            return this;
        }

        @Override
        public QueryBuilder type(RelationType type) {
            super.type(type);
            return this;
        }

        @Override
        public QueryBuilder direction(Direction d) {
            super.direction(d);
            return this;
        }

        @Override
        public QueryBuilder limit(int limit) {
            super.limit(limit);
            return this;
        }

        @Override
        public QueryBuilder orderBy(String key, Order order) {
            super.orderBy(key, order);
            return this;
        }
    }

    static class Query {
        private final List<SliceQuery> slices;
        private final RelationCategory returnType;

        public Query(List<SliceQuery> slices, RelationCategory returnType) {
            this.slices = slices;
            this.returnType = returnType;
        }

        public List<SliceQuery> getSlices() {
            return this.slices;
        }

        public RelationCategory getReturnType() {
            return this.returnType;
        }
    }
}

