/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexOptimizerStrategy;

public class AdjacentVertexHasIdOptimizerStrategy
extends AdjacentVertexOptimizerStrategy<HasStep<?>> {
    private static final AdjacentVertexHasIdOptimizerStrategy INSTANCE = new AdjacentVertexHasIdOptimizerStrategy();

    private AdjacentVertexHasIdOptimizerStrategy() {
    }

    public static AdjacentVertexHasIdOptimizerStrategy instance() {
        return INSTANCE;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        TraversalHelper.getStepsOfClass(HasStep.class, traversal).forEach(step -> this.optimizeStep(step));
    }

    @Override
    protected P<?> parsePredicate(HasStep<?> hasStep) {
        List<HasContainer> hasContainers = hasStep.getHasContainers();
        if (hasContainers.size() != 1) {
            return null;
        }
        HasContainer hc = hasStep.getHasContainers().get(0);
        if (hc.getKey().equals(T.id.getAccessor())) {
            return hc.getPredicate();
        }
        return null;
    }

    @Override
    protected boolean isValidPredicate(P<?> predicate) {
        if (predicate == null) {
            return false;
        }
        if (predicate.getBiPredicate() != Compare.eq) {
            return false;
        }
        Object predicateValue = predicate.getValue();
        return predicateValue instanceof Vertex || predicateValue instanceof Long;
    }
}

