/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.types.system.ImplicitKey;

public abstract class AdjacentVertexOptimizerStrategy<T extends FilterStep<?>>
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    @Override
    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> postStrategies = new HashSet<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>>();
        postStrategies.add(JanusGraphLocalQueryOptimizerStrategy.class);
        return postStrategies;
    }

    protected void optimizeStep(T step) {
        P<?> predicate = this.parsePredicate(step);
        if (this.isValidPredicate(predicate)) {
            OptimizablePosition pos = this.getOptimizablePosition(step);
            this.replaceSequence(step, pos, predicate);
        }
    }

    protected abstract P<?> parsePredicate(T var1);

    protected abstract boolean isValidPredicate(P<?> var1);

    private OptimizablePosition getOptimizablePosition(T originalStep) {
        Step predecessor = ((AbstractStep)originalStep).getPreviousStep();
        if (predecessor instanceof VertexStep) {
            if (((VertexStep)predecessor).returnsVertex()) {
                return OptimizablePosition.V2V_ID;
            }
            return OptimizablePosition.NONE;
        }
        Step<?, ?> prePredecessor = predecessor.getPreviousStep();
        if ((predecessor instanceof EdgeVertexStep || predecessor instanceof EdgeOtherVertexStep) && prePredecessor instanceof VertexStep && ((VertexStep)prePredecessor).returnsEdge()) {
            return OptimizablePosition.V2E_E2V_ID;
        }
        return OptimizablePosition.NONE;
    }

    private void replaceSequence(T originalStep, OptimizablePosition pos, P<?> predicate) {
        switch (pos) {
            case V2E_E2V_ID: {
                this.replaceSequenceV2EthenE2VthenID(originalStep, predicate);
                break;
            }
            case V2V_ID: {
                this.replaceSequenceV2VthenID(originalStep, predicate);
                break;
            }
        }
    }

    private void replaceSequenceV2EthenE2VthenID(T originalStep, P<?> predicate) {
        Traversal.Admin traversal = ((AbstractStep)originalStep).getTraversal();
        Step e2vStep = ((AbstractStep)originalStep).getPreviousStep();
        HasStep<Edge> hasAdjacentIdStep = this.makeHasAdjacentIdStep(traversal, predicate);
        traversal.removeStep((Step<?, ?>)originalStep);
        TraversalHelper.insertBeforeStep(hasAdjacentIdStep, e2vStep, traversal);
    }

    private void replaceSequenceV2VthenID(T originalStep, P<?> predicate) {
        Traversal.Admin traversal = ((AbstractStep)originalStep).getTraversal();
        VertexStep v2vStep = (VertexStep)((AbstractStep)originalStep).getPreviousStep();
        String[] edgeLabels = v2vStep.getEdgeLabels();
        Direction v2vDirection = v2vStep.getDirection();
        VertexStep<Edge> v2eStep = new VertexStep<Edge>(traversal, Edge.class, v2vDirection, edgeLabels);
        AbstractStep e2vStep = v2vDirection == Direction.BOTH ? new EdgeOtherVertexStep(traversal) : new EdgeVertexStep(traversal, v2vDirection.opposite());
        Step predecessor = v2vStep.getPreviousStep();
        HasStep<Edge> hasAdjacentIdStep = this.makeHasAdjacentIdStep(traversal, predicate);
        traversal.removeStep((Step<?, ?>)originalStep);
        traversal.removeStep(v2vStep);
        TraversalHelper.insertAfterStep(v2eStep, predecessor, traversal);
        TraversalHelper.insertAfterStep(hasAdjacentIdStep, v2eStep, traversal);
        TraversalHelper.insertAfterStep(e2vStep, hasAdjacentIdStep, traversal);
    }

    private HasStep<Edge> makeHasAdjacentIdStep(Traversal.Admin<?, ?> traversal, P<?> predicate) {
        HasContainer hc = new HasContainer(ImplicitKey.ADJACENT_ID.name(), P.eq(predicate.getValue()));
        return new HasStep<Edge>(traversal, hc);
    }

    protected static enum OptimizablePosition {
        NONE,
        V2V_ID,
        V2E_E2V_ID;

    }
}

