/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.vertexcache;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.graphdb.util.ConcurrentLRUCache;
import org.janusgraph.util.datastructures.Retriever;

public class LRUVertexCache
implements VertexCache {
    private final NonBlockingHashMapLong<InternalVertex> volatileVertices = new NonBlockingHashMapLong();
    private final ConcurrentLRUCache<InternalVertex> cache;

    public LRUVertexCache(int capacity) {
        this.cache = new ConcurrentLRUCache<InternalVertex>(capacity * 2, capacity + capacity / 3, capacity, 100, true, false, (vertexId, vertex) -> {
            if (vertexId == null || vertex == null) {
                return;
            }
            if (vertex.isModified()) {
                this.volatileVertices.putIfAbsent(vertexId, (InternalVertex)vertex);
            }
        });
        this.cache.setAlive(true);
    }

    @Override
    public boolean contains(long id) {
        Long vertexId = id;
        return this.cache.containsKey(vertexId) || this.volatileVertices.containsKey(vertexId);
    }

    @Override
    public InternalVertex get(long id, Retriever<Long, InternalVertex> retriever) {
        Long vertexId = id;
        InternalVertex vertex = this.cache.get(vertexId);
        if (vertex == null) {
            InternalVertex newVertex = this.volatileVertices.get(vertexId);
            if (newVertex == null) {
                newVertex = retriever.get(vertexId);
            }
            if ((vertex = this.cache.putIfAbsent(vertexId, newVertex)) == null) {
                vertex = newVertex;
            }
        }
        return vertex;
    }

    @Override
    public void add(InternalVertex vertex, long id) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0);
        Long vertexId = id;
        this.cache.put(vertexId, vertex);
        if (vertex.isNew() || vertex.hasAddedRelations()) {
            this.volatileVertices.put(vertexId, vertex);
        }
    }

    @Override
    public List<InternalVertex> getAllNew() {
        ArrayList<InternalVertex> vertices = new ArrayList<InternalVertex>(10);
        for (InternalVertex v : this.volatileVertices.values()) {
            if (!v.isNew()) continue;
            vertices.add(v);
        }
        return vertices;
    }

    @Override
    public synchronized void close() {
        this.volatileVertices.clear();
        this.cache.destroy();
    }
}

