/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;
import org.janusgraph.graphdb.types.VertexLabelVertex;
import org.janusgraph.graphdb.types.system.SystemTypeManager;

public class StandardVertexLabelMaker
implements VertexLabelMaker {
    private final StandardJanusGraphTx tx;
    private String name;
    private boolean partitioned;
    private boolean isStatic;

    public StandardVertexLabelMaker(StandardJanusGraphTx tx) {
        this.tx = tx;
    }

    public StandardVertexLabelMaker name(String name) {
        SystemTypeManager.throwIfSystemName(JanusGraphSchemaCategory.VERTEXLABEL, name);
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StandardVertexLabelMaker partition() {
        this.partitioned = true;
        return this;
    }

    @Override
    public StandardVertexLabelMaker setStatic() {
        this.isStatic = true;
        return this;
    }

    @Override
    public VertexLabel make() {
        Preconditions.checkArgument((!this.partitioned || !this.isStatic ? 1 : 0) != 0, (Object)"A vertex label cannot be partitioned and static at the same time");
        TypeDefinitionMap def = new TypeDefinitionMap();
        def.setValue(TypeDefinitionCategory.PARTITIONED, this.partitioned);
        def.setValue(TypeDefinitionCategory.STATIC, this.isStatic);
        return (VertexLabelVertex)this.tx.makeSchemaVertex(JanusGraphSchemaCategory.VERTEXLABEL, this.name, def);
    }
}

