/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.provider.CytoData;
import com.arcadeanalytics.provider.Data;
import com.arcadeanalytics.provider.DataSourceGraphDataProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.GraphData;
import com.arcadeanalytics.provider.Position;
import com.arcadeanalytics.provider.TypeMapperKt;
import com.arcadeanalytics.provider.gremlin.GremlinDataProvider;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J#\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ?\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016\u00a2\u0006\u0002\u0010\u0014J;\u0010\u0015\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ \u0010\u001c\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J(\u0010\u001f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J#\u0010\"\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0016\u00a2\u0006\u0002\u0010#J+\u0010\"\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010$J \u0010%\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J0\u0010%\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J#\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J0\u0010+\u001a\u00020,2\u001e\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002000/0.2\u0006\u00101\u001a\u00020,H\u0002J0\u00102\u001a\u0002032\u001e\u0010-\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002000/0/2\u0006\u00101\u001a\u00020,H\u0002J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000705H\u0016J\u0010\u00106\u001a\u0002072\u0006\u0010\b\u001a\u00020\tH\u0016J \u00108\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010 \u001a\u00020!H\u0002J\u001c\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002000.2\u0006\u0010<\u001a\u00020=H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/arcadeanalytics/provider/gremlin/GremlinDataProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphDataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "arcadeIdToNativeId", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "id", "cleanIds", "ids", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Ljava/lang/String;", "edges", "Lcom/arcadeanalytics/provider/GraphData;", "fromIds", "edgesLabel", "toIds", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;[Ljava/lang/String;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "expand", "roots", "direction", "edgeLabel", "maxTraversal", "", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Lcom/arcadeanalytics/provider/GraphData;", "fetchData", "query", "limit", "getGraphData", "client", "Lorg/apache/tinkerpop/gremlin/driver/Client;", "load", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;)Lcom/arcadeanalytics/provider/GraphData;", "(Lcom/arcadeanalytics/provider/DataSourceInfo;[Ljava/lang/String;Lorg/apache/tinkerpop/gremlin/driver/Client;)Lcom/arcadeanalytics/provider/GraphData;", "loadFromClass", "className", "propName", "propertyValue", "loadQuery", "nativeIdToArcadeId", "populateClasses", "Lcom/arcadeanalytics/provider/CytoData;", "classes", "", "", "", "element", "populateProperties", "", "supportedDataSourceTypes", "", "testConnection", "", "toCytoData", "result", "Lorg/apache/tinkerpop/gremlin/driver/Result;", "transformToMap", "doc", "Lorg/apache/tinkerpop/gremlin/structure/Element;", "arcade-connectors-gremlin"})
public final class GremlinDataProvider
implements DataSourceGraphDataProvider {
    private final Logger log = LoggerFactory.getLogger(GremlinDataProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GraphData fetchData(@NotNull DataSourceInfo dataSource, @NotNull String query, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Cluster cluster = GremlinUtilKt.getCluster(dataSource);
        Client client = ((Client)cluster.connect()).init();
        try {
            Client client2 = client;
            Intrinsics.checkNotNullExpressionValue((Object)client2, (String)"client");
            GraphData graphData = this.getGraphData(dataSource, query, limit, client2);
            return graphData;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        finally {
            client.close();
            cluster.close();
        }
    }

    private final GraphData getGraphData(DataSourceInfo dataSource, String query, int limit, Client client) {
        String[] ids2;
        HashSet<CytoData> cytoNodes = new HashSet<CytoData>();
        HashSet cytoEdges = new HashSet();
        HashMap edgeClasses = new HashMap();
        HashMap nodeClasses = new HashMap();
        this.log.info("fetching data from '{}' with query '{}' ", (Object)dataSource.getId(), (Object)query);
        ResultSet resultSet = client.submit(query);
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"client.submit(query)");
        String[] $this$toTypedArray$iv = (String[])SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (int)limit), (Function1)((Function1)new Function1<Result, CytoData>(this, dataSource, client){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;
            final /* synthetic */ Client $client;

            @NotNull
            public final CytoData invoke(Result r) {
                Result result = r;
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"r");
                return GremlinDataProvider.access$toCytoData(this.this$0, this.$dataSource, result, this.$client);
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$dataSource = dataSourceInfo;
                this.$client = client;
                super(1);
            }
        })), (Function1)((Function1)new Function1<CytoData, List<? extends String>>(this, cytoNodes, nodeClasses, cytoEdges, edgeClasses){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ HashSet $cytoNodes;
            final /* synthetic */ HashMap $nodeClasses;
            final /* synthetic */ HashSet $cytoEdges;
            final /* synthetic */ HashMap $edgeClasses;

            @NotNull
            public final List<String> invoke(@NotNull CytoData data) {
                List list;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (Intrinsics.areEqual((Object)data.getGroup(), (Object)"nodes")) {
                    this.$cytoNodes.add(data);
                    GremlinDataProvider.access$populateClasses(this.this$0, this.$nodeClasses, data);
                    list = CollectionsKt.emptyList();
                } else {
                    this.$cytoEdges.add(data);
                    GremlinDataProvider.access$populateClasses(this.this$0, this.$edgeClasses, data);
                    list = CollectionsKt.listOf((Object[])new String[]{data.getData().getSource(), data.getData().getTarget()});
                }
                return list;
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$cytoNodes = hashSet;
                this.$nodeClasses = hashMap;
                this.$cytoEdges = hashSet2;
                this.$edgeClasses = hashMap2;
                super(1);
            }
        })), (Function1)getGraphData.ids.3.INSTANCE));
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        $this$toTypedArray$iv = ids2 = stringArray;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        boolean bl = false;
        if (!(thisCollection$iv.length == 0)) {
            GraphData load = this.load(dataSource, ids2, client);
            Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)load.getNodes());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CytoData n = (CytoData)element$iv;
                boolean bl2 = false;
                cytoNodes.add(n);
                this.populateClasses(nodeClasses, n);
            }
        }
        GraphData graphData = new GraphData((Map)nodeClasses, (Map)edgeClasses, (Set)cytoNodes, (Set)cytoEdges, false, 16, null);
        this.log.info("fetched {} nodes and {} edges ", (Object)cytoNodes.size(), (Object)cytoEdges.size());
        return graphData;
    }

    private final CytoData toCytoData(DataSourceInfo dataSource, Result result, Client client) {
        CytoData cytoData;
        Data data;
        String string;
        Data data2;
        String string2;
        String string3;
        String string4;
        String string5;
        Element element;
        Element element2 = result.getElement();
        String id = this.nativeIdToArcadeId(dataSource, element2.id().toString());
        Element element3 = element2;
        Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"element");
        Map<String, Object> record = this.transformToMap(element3);
        HashMap ins = new HashMap();
        record.put("@in", ins);
        HashMap outs = new HashMap();
        record.put("@out", outs);
        if (record.containsKey("id")) {
            Object object = record.get("id");
            Intrinsics.checkNotNull((Object)object);
            record.put("_id_", object);
            record.remove("id");
        }
        if ((element = element2) instanceof Vertex) {
            ResultSet resultSet = client.submit("g.V('" + element2.id() + "').outE()");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"client.submit(\"g.V('${element.id()}').outE()\")");
            Sequence $this$groupingBy$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resultSet), (Function1)toCytoData.cyto.1.INSTANCE), (Function1)toCytoData.cyto.2.INSTANCE);
            boolean $i$f$groupingBy = false;
            outs.putAll(GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<String> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    String it = (String)element;
                    boolean bl = false;
                    return var2_2;
                }
            })));
            ResultSet resultSet2 = client.submit("g.V('" + element2.id() + "').inE()");
            Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"client.submit(\"g.V('${element.id()}').inE()\")");
            $this$groupingBy$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)resultSet2), (Function1)toCytoData.cyto.4.INSTANCE), (Function1)toCytoData.cyto.5.INSTANCE);
            $i$f$groupingBy = false;
            ins.putAll(GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
                final /* synthetic */ Sequence $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<String> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public Object keyOf(Object element) {
                    void var2_2;
                    String it = (String)element;
                    boolean bl = false;
                    return var2_2;
                }
            })));
            Collection collection = ins.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"ins.values");
            int edgeCount2 = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)toCytoData.cyto.edgeCount.1.INSTANCE));
            Collection collection2 = outs.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"outs.values");
            record.put("@edgeCount", edgeCount2 += SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)collection2), (Function1)toCytoData.cyto.7.INSTANCE)));
            Data data3 = new Data(id, null, null, null, record, 14, null);
            String string6 = element2.label();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"element.label()");
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            data2 = null;
            string = "nodes";
            data = data3;
            CytoData cytoData2 = new CytoData(string6, string, data, (Position)data2, string2, string3, string4, string5, 248, null);
            cytoData = cytoData2;
        } else if (element instanceof Edge) {
            String sourceId = ((Edge)element2).outVertex().id().toString();
            String source = this.nativeIdToArcadeId(dataSource, sourceId);
            String targetId = ((Edge)element2).inVertex().id().toString();
            String target = this.nativeIdToArcadeId(dataSource, targetId);
            Data data4 = new Data(id, null, source, target, record, 2, null);
            String string7 = element2.label();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"element.label()");
            string2 = null;
            data2 = null;
            string = null;
            data = null;
            Position position = null;
            String string8 = "edges";
            Data data5 = data4;
            CytoData cytoData3 = new CytoData(string7, string8, data5, position, data, string, (String)data2, string2, 248, null);
            cytoData = cytoData3;
        } else {
            this.log.info("element not mappable:: " + element2);
            String string9 = element2.label();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"element.label()");
            String string10 = null;
            String string11 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = "unk";
            data2 = new Data(id, null, null, null, null, 30, null);
            CytoData cytoData4 = new CytoData(string9, string2, data2, string3, string4, string5, string11, string10, 248, null);
            cytoData = cytoData4;
        }
        CytoData cyto2 = cytoData;
        return cyto2;
    }

    private final CytoData populateClasses(Map<String, Map<String, Object>> classes, CytoData element) {
        if (classes.get(element.getClasses()) == null) {
            String string = element.getClasses();
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"Maps.newHashMap()");
            classes.put(string, hashMap);
        }
        this.populateProperties(classes, element);
        return element;
    }

    private final void populateProperties(Map<String, ? extends Map<String, ? extends Object>> classes, CytoData element) {
        Map<String, ? extends Object> properties = classes.get(element.getClasses());
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)element.getData().getRecord().keySet()), (Function1)populateProperties.1.INSTANCE), (Function1)populateProperties.2.INSTANCE), (Function1)populateProperties.3.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String f = (String)element$iv;
            boolean bl = false;
            Map<String, ? extends Object> map = properties;
            if (map == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.Map<kotlin.String, kotlin.Any>");
            }
            map.putIfAbsent(f, TypeMapperKt.mapType((String)"STRING"));
        }
    }

    private final Map<String, Object> transformToMap(Element doc) {
        HashMap record = Maps.newHashMap();
        Set<String> set = doc.keys();
        Intrinsics.checkNotNullExpressionValue(set, (String)"doc.keys()");
        Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)set);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String k = (String)element$iv;
            boolean bl = false;
            HashMap hashMap = record;
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"record");
            ((Map)hashMap).put(k, doc.properties(k).next().value());
        }
        HashMap hashMap = record;
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"record");
        return hashMap;
    }

    @NotNull
    public GraphData load(@NotNull DataSourceInfo dataSource, @NotNull String[] ids2) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)ids2, (String)"ids");
        String query = this.loadQuery(dataSource, ids2);
        return this.fetchData(dataSource, query, ids2.length);
    }

    private final GraphData load(DataSourceInfo dataSource, String[] ids2, Client client) {
        String query = this.loadQuery(dataSource, ids2);
        return this.getGraphData(dataSource, query, ids2.length, client);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String query = "g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(className) + ").limit(" + limit + ')';
        return this.fetchData(dataSource, query, limit);
    }

    @NotNull
    public GraphData loadFromClass(@NotNull DataSourceInfo dataSource, @NotNull String className, @NotNull String propName, @NotNull String propertyValue, int limit) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)propName, (String)"propName");
        Intrinsics.checkNotNullParameter((Object)propertyValue, (String)"propertyValue");
        String query = "g.V().hasLabel(" + GremlinUtilKt.splitMultilabel(className) + ").has('" + propName + "', eq('" + propertyValue + "')).limit(" + limit + ')';
        return this.fetchData(dataSource, query, limit);
    }

    private final String loadQuery(DataSourceInfo dataSource, String[] ids2) {
        String[] stringArray = ids2;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        boolean bl3 = !(stringArray2.length == 0);
        bl = false;
        boolean bl4 = false;
        bl4 = false;
        bl2 = false;
        if (!bl3) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.log.debug("load ids {} ", (Object[])Arrays.copyOf(ids2, ids2.length));
        String joinedIds = this.cleanIds(dataSource, ids2);
        return "g.V(" + joinedIds + ')';
    }

    private final String cleanIds(DataSourceInfo dataSource, String[] ids2) {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])ids2), (Function1)((Function1)new Function1<String, String>(this, dataSource){
            final /* synthetic */ GremlinDataProvider this$0;
            final /* synthetic */ DataSourceInfo $dataSource;

            @NotNull
            public final String invoke(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                return GremlinDataProvider.access$arcadeIdToNativeId(this.this$0, this.$dataSource, id);
            }
            {
                this.this$0 = gremlinDataProvider;
                this.$dataSource = dataSourceInfo;
                super(1);
            }
        })), (Function1)cleanIds.2.INSTANCE), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private final String nativeIdToArcadeId(DataSourceInfo dataSource, String id) {
        String string;
        String string2 = dataSource.getType();
        switch (string2.hashCode()) {
            case -1469759516: {
                if (string2.equals("GREMLIN_ORIENTDB")) {
                    string = "" + dataSource.getId() + '_' + StringsKt.replace$default((String)StringsKt.removePrefix((String)id, (CharSequence)"#"), (String)":", (String)"_", (boolean)false, (int)4, null);
                    break;
                }
            }
            default: {
                string = "" + dataSource.getId() + '_' + id;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String arcadeIdToNativeId(DataSourceInfo dataSource, String id) {
        String string;
        String string2 = dataSource.getType();
        switch (string2.hashCode()) {
            case -1469759516: {
                if (string2.equals("GREMLIN_ORIENTDB")) {
                    void $this$prefixIfAbsent$iv;
                    String string3 = StringsKt.removePrefix((String)id, (CharSequence)("" + dataSource.getId() + '_'));
                    String prefix$iv = "#";
                    boolean $i$f$prefixIfAbsent = false;
                    string = StringsKt.replace$default((String)(StringsKt.startsWith$default((String)$this$prefixIfAbsent$iv, (String)prefix$iv, (boolean)false, (int)2, null) ? $this$prefixIfAbsent$iv : prefix$iv + (String)$this$prefixIfAbsent$iv), (String)"_", (String)":", (boolean)false, (int)4, null);
                    break;
                }
            }
            default: {
                string = StringsKt.removePrefix((String)id, (CharSequence)("" + dataSource.getId() + '_'));
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public GraphData expand(@NotNull DataSourceInfo dataSource, @NotNull String[] roots, @NotNull String direction, @NotNull String edgeLabel, int maxTraversal) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)edgeLabel, (String)"edgeLabel");
            edgeLabel = edgeLabel;
            query = this.loadQuery(dataSource, roots);
            if (StringUtils.isNotEmpty(edgeLabel)) {
                v0 = StringUtils.wrap(edgeLabel, '\"');
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"wrap(edgeLabel, '\"')");
                edgeLabel = v0;
            }
            v1 = new StringBuilder().append(query);
            var8_8 = direction;
            var9_9 = false;
            v2 = var8_8.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.String).toLowerCase()");
            var8_8 = v2;
            switch (var8_8.hashCode()) {
                case 3365: {
                    if (!var8_8.equals("in")) ** break;
                    break;
                }
                case 110414: {
                    if (!var8_8.equals("out")) ** break;
                    v3 = ".outE(" + edgeLabel + ')';
                    break block5;
                }
            }
            v3 = ".inE(" + edgeLabel + ')';
            break block5;
            v3 = ".bothE(" + edgeLabel + ')';
        }
        query = v1.append(v3).toString();
        return this.fetchData(dataSource, query, maxTraversal);
    }

    @NotNull
    public GraphData edges(@NotNull DataSourceInfo dataSource, @NotNull String[] fromIds, @NotNull String[] edgesLabel, @NotNull String[] toIds) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)fromIds, (String)"fromIds");
        Intrinsics.checkNotNullParameter((Object)edgesLabel, (String)"edgesLabel");
        Intrinsics.checkNotNullParameter((Object)toIds, (String)"toIds");
        String cleanLabels = ArraysKt.joinToString$default((Object[])edgesLabel, (CharSequence)"','", (CharSequence)"'", (CharSequence)"'", (int)0, null, null, (int)56, null);
        String query = StringsKt.trimIndent((String)("\n            g.V(" + this.cleanIds(dataSource, fromIds) + ")\n                .bothE()\n                .where(inV().has(id, within(" + this.cleanIds(dataSource, toIds) + " )))\n                .hasLabel(" + cleanLabels + ")\n            "));
        return this.fetchData(dataSource, query, 10000);
    }

    public boolean testConnection(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        try {
            this.log.info("testing connection to :: '{}' ", (Object)dataSource.getServer());
            Cluster cluster = GremlinUtilKt.getCluster(dataSource);
            cluster.availableHosts().stream().forEach(testConnection.1.INSTANCE);
            Client client = ((Client)cluster.connect()).init();
            client.submit("g.V().count()");
            client.close();
            cluster.close();
            this.log.info("connection works fine:: '{}' ", (Object)dataSource.getServer());
            return true;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"GREMLIN_ORIENTDB", "GREMLIN_NEPTUNE", "GREMLIN_JANUSGRAPH"});
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"Sets.newHashSet(\"GREMLIN\u2026E\", \"GREMLIN_JANUSGRAPH\")");
        return hashSet;
    }

    public static final /* synthetic */ CytoData access$toCytoData(GremlinDataProvider $this, DataSourceInfo dataSource, Result result, Client client) {
        return $this.toCytoData(dataSource, result, client);
    }

    public static final /* synthetic */ CytoData access$populateClasses(GremlinDataProvider $this, Map classes, CytoData element) {
        return $this.populateClasses(classes, element);
    }

    public static final /* synthetic */ String access$arcadeIdToNativeId(GremlinDataProvider $this, DataSourceInfo dataSource, String id) {
        return $this.arcadeIdToNativeId(dataSource, id);
    }
}

