/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/arcadeanalytics/provider/gremlin/GremlinGraphProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphProvider;", "()V", "allFields", "Ljava/util/regex/Pattern;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cleanOrientId", "", "id", "provideEdges", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "processor", "Lcom/arcadeanalytics/data/SpritePlayer;", "client", "Lorg/apache/tinkerpop/gremlin/driver/Client;", "provideNodes", "provideTo", "player", "supportedDataSourceTypes", "", "arcade-connectors-gremlin"})
public final class GremlinGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(GremlinGraphProvider.class);
    private final Pattern allFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideTo(@NotNull DataSourceInfo dataSource, @NotNull SpritePlayer player) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Cluster cluster = GremlinUtilKt.getCluster(dataSource);
        Client client = ((Client)cluster.connect()).init();
        try {
            Client client2 = client;
            Intrinsics.checkNotNullExpressionValue((Object)client2, (String)"client");
            this.provideNodes(dataSource, player, client2);
            this.provideEdges(dataSource, player, client);
            client.close();
        }
        finally {
            cluster.close();
            client.close();
            player.end();
        }
    }

    private final void provideNodes(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        Result result = client.submit("g.V().count()").one();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"client.submit(\"g.V().count()\").one()");
        long nodes = result.getLong();
        long fetched = 0L;
        long skip = 0L;
        long l = 1000L;
        boolean bl = false;
        long limit = Math.min(nodes, l);
        this.log.info("start indexing of data-source {} - total nodes:: {} ", (Object)dataSource.getId(), (Object)nodes);
        while (fetched < nodes) {
            ResultSet resultSet = client.submit("g.V().range(" + skip + " , " + limit + ')');
            Iterator<Result> iterator = resultSet.iterator();
            while (iterator.hasNext()) {
                Result r;
                Result result2 = r = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"r");
                Vertex element = result2.getVertex();
                Sprite sprite = new Sprite();
                Set<String> set = element.keys();
                Intrinsics.checkNotNullExpressionValue(set, (String)"element.keys()");
                Sequence $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<String, Sequence<? extends VertexProperty<Object>>>(element){
                    final /* synthetic */ Vertex $element;

                    @NotNull
                    public final Sequence<VertexProperty<Object>> invoke(@Nullable String key) {
                        Iterator<VertexProperty<V>> iterator = this.$element.properties(key);
                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"element.properties<Any>(key)");
                        return SequencesKt.asSequence(iterator);
                    }
                    {
                        this.$element = vertex;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VertexProperty v = (VertexProperty)element$iv;
                    boolean bl2 = false;
                    String string = v.label();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"v.label()");
                    sprite.add(string, v.value());
                }
                Sprite sprite2 = sprite.add("_a_id", String.valueOf(dataSource.getId()) + "_" + this.cleanOrientId(element.id().toString())).add("_a_type", "node");
                String string = element.label();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.label()");
                sprite2.add("@class", string);
                processor.play(sprite);
                long l2 = fetched;
                fetched = l2 + 1L;
            }
            skip = limit;
            limit += (long)10000;
        }
    }

    private final void provideEdges(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        Result result = client.submit("g.E().count()").one();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"client.submit(\"g.E().count()\").one()");
        long edges = result.getLong();
        long fetched = 0L;
        long skip = 0L;
        long l = 1000L;
        boolean bl = false;
        long limit = Math.min(edges, l);
        this.log.info("start indexing of data-source {} - total edges:: {} ", (Object)dataSource.getId(), (Object)edges);
        while (fetched < edges) {
            ResultSet resultSet = client.submit("g.E().range(" + skip + " , " + limit + ')');
            Iterator<Result> iterator = resultSet.iterator();
            while (iterator.hasNext()) {
                Result r;
                Result result2 = r = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"r");
                Element element = result2.getElement();
                Set<String> set = element.keys();
                Intrinsics.checkNotNullExpressionValue(set, (String)"element.keys()");
                Collection collection = set;
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    Sprite sprite = new Sprite();
                    Set<String> set2 = element.keys();
                    Intrinsics.checkNotNullExpressionValue(set2, (String)"element.keys()");
                    Sequence $this$forEach$iv = CollectionsKt.asSequence((Iterable)set2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String k = (String)element$iv;
                        boolean bl3 = false;
                        String string = k;
                        Intrinsics.checkNotNull((Object)string);
                        sprite.add(string, element.value(k).toString());
                    }
                    Sprite sprite2 = sprite.add("_a_id", String.valueOf(dataSource.getId()) + "_" + this.cleanOrientId(element.id().toString())).add("_a_type", "edge");
                    String string = element.label();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.label()");
                    sprite2.add("@class", string);
                    processor.play(sprite);
                }
                long l2 = fetched;
                fetched = l2 + 1L;
            }
            skip = limit;
            limit += (long)10000;
        }
    }

    private final String cleanOrientId(String id) {
        String string = StringUtils.removeStart(id, "#");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtils.removeStart(id, \"#\")");
        return StringsKt.replace$default((String)string, (String)":", (String)"_", (boolean)false, (int)4, null);
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"GREMLIN_ORIENTDB", "GREMLIN_NEPTUNE", "GREMLIN_JANUSGRAPH"});
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"Sets.newHashSet(\"GREMLIN\u2026E\", \"GREMLIN_JANUSGRAPH\")");
        return hashSet;
    }

    public GremlinGraphProvider() {
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\".*\")");
        this.allFields = pattern;
    }
}

