/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin;

import com.arcadeanalytics.provider.DataSourceInfo;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.MessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.GraphSONMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.driver.ser.GryoMessageSerializerV3d0;
import org.apache.tinkerpop.gremlin.orientdb.io.OrientIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"createSerializer", "Lorg/apache/tinkerpop/gremlin/driver/MessageSerializer;", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "getCluster", "Lorg/apache/tinkerpop/gremlin/driver/Cluster;", "splitMultilabel", "", "label", "arcade-connectors-gremlin"})
public final class GremlinUtilKt {
    @NotNull
    public static final Cluster getCluster(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Cluster cluster = Cluster.build(dataSource.getServer()).port(dataSource.getPort()).serializer(GremlinUtilKt.createSerializer(dataSource)).enableSsl(dataSource.getEnableSsl()).sslSkipCertValidation(dataSource.getSkipCertValidation()).maxContentLength(262144).credentials(dataSource.getUsername(), dataSource.getPassword()).maxWaitForConnection(20000).create();
        Intrinsics.checkNotNullExpressionValue((Object)cluster, (String)"Cluster.build(dataSource\u2026(20000)\n        .create()");
        return cluster;
    }

    @NotNull
    public static final String splitMultilabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)label, (String[])new String[]{"::"}, (boolean)false, (int)0, (int)6, null), (CharSequence)"','", (CharSequence)"'", (CharSequence)"'", (int)0, null, null, (int)56, null);
    }

    @NotNull
    public static final MessageSerializer createSerializer(@NotNull DataSourceInfo dataSource) {
        MessageSerializer messageSerializer;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        switch (dataSource.getType()) {
            case "GREMLIN_ORIENTDB": {
                messageSerializer = new GryoMessageSerializerV3d0(GryoMapper.build().addRegistry(OrientIoRegistry.getInstance()));
                break;
            }
            case "GREMLIN_NEPTUNE": {
                messageSerializer = new GryoMessageSerializerV3d0();
                break;
            }
            case "GREMLIN_JANUSGRAPH": {
                messageSerializer = new GryoMessageSerializerV3d0(GryoMapper.build().addRegistry(JanusGraphIoRegistry.getInstance()));
                break;
            }
            case "GREMLIN_COSMOSDB": {
                GraphSONMessageSerializerV1d0 serializer = new GraphSONMessageSerializerV1d0();
                serializer.configure(MapsKt.mapOf((Pair)TuplesKt.to((Object)"serializeResultToString", (Object)true)), null);
                messageSerializer = serializer;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("requested type not implemented yet:: " + dataSource.getType());
            }
        }
        return messageSerializer;
    }
}

