/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.gremlin.cosmosdb;

import com.arcadeanalytics.data.Sprite;
import com.arcadeanalytics.data.SpritePlayer;
import com.arcadeanalytics.provider.DataSourceGraphProvider;
import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.gremlin.GremlinUtilKt;
import com.arcadeanalytics.provider.gremlin.cosmosdb.CosmosDBGremlinGraphProvider;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/arcadeanalytics/provider/gremlin/cosmosdb/CosmosDBGremlinGraphProvider;", "Lcom/arcadeanalytics/provider/DataSourceGraphProvider;", "()V", "allFields", "Ljava/util/regex/Pattern;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "provideEdges", "", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "processor", "Lcom/arcadeanalytics/data/SpritePlayer;", "client", "Lorg/apache/tinkerpop/gremlin/driver/Client;", "provideNodes", "provideTo", "player", "supportedDataSourceTypes", "", "", "arcade-connectors-gremlin"})
public final class CosmosDBGremlinGraphProvider
implements DataSourceGraphProvider {
    private final Logger log = LoggerFactory.getLogger(CosmosDBGremlinGraphProvider.class);
    private final Pattern allFields;

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        HashSet hashSet = Sets.newHashSet((Object[])new String[]{"GREMLIN_COSMOSDB"});
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"Sets.newHashSet(\"GREMLIN_COSMOSDB\")");
        return hashSet;
    }

    public void provideTo(@NotNull DataSourceInfo dataSource, @NotNull SpritePlayer player) {
        Client client;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Cluster cluster = Cluster.build(dataSource.getServer()).port(dataSource.getPort()).serializer(GremlinUtilKt.createSerializer(dataSource)).enableSsl(Intrinsics.areEqual((Object)dataSource.getType(), (Object)"GREMLIN_COSMOSDB")).credentials(dataSource.getUsername(), dataSource.getPassword()).create();
        Client client2 = client = ((Client)cluster.connect()).init();
        Intrinsics.checkNotNullExpressionValue((Object)client2, (String)"client");
        this.provideNodes(dataSource, player, client2);
        this.provideEdges(dataSource, player, client);
        client.close();
        cluster.close();
        player.end();
    }

    private final void provideNodes(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        Result result = client.submit("g.V().count()").one();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"client.submit(\"g.V().count()\").one()");
        long nodes = result.getLong();
        long fetched = 0L;
        long skip = 0L;
        long limit = Math.min(nodes, 1000L);
        this.log.info("start indexing of data-source {} - total nodes:: {} ", (Object)dataSource.getId(), (Object)nodes);
        while (fetched < nodes) {
            ResultSet resultSet = client.submit("g.V().range(" + skip + " , " + limit + ')');
            for (Result r : resultSet) {
                Object object = r.getObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                }
                Map res = TypeIntrinsics.asMutableMap((Object)object);
                if (res.containsKey("properties")) {
                    Object v = res.get("properties");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any>>>");
                    }
                    Map props = (Map)v;
                    props.forEach((BiConsumer)new BiConsumer<String, List<? extends Map<String, ? extends Object>>>(res){
                        final /* synthetic */ Map $res;

                        public final void accept(@NotNull String k, @NotNull List<? extends Map<String, ? extends Object>> v) {
                            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                            Intrinsics.checkNotNullParameter(v, (String)"v");
                            Object object = v.get(0).get("value");
                            Intrinsics.checkNotNull((Object)object);
                            this.$res.put(k, object);
                        }
                        {
                            this.$res = map;
                        }
                    });
                    res.remove("properties");
                    res.remove("class");
                }
                Sprite sprite = new Sprite();
                Iterable $this$forEach$iv = res.keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String k = (String)element$iv;
                    boolean bl = false;
                    sprite.add(k, String.valueOf(res.get(k)));
                }
                sprite.add("_a_id", String.valueOf(dataSource.getId()) + "_" + res.get("id")).add("_a_type", "node").add("@class", res.get("label")).apply(this.allFields, (Function1)provideNodes.3.INSTANCE);
                processor.play(sprite);
                long l = fetched;
                fetched = l + 1L;
                this.log.info("fetched:: {} ", (Object)fetched);
            }
            skip = limit;
            limit += (long)10000;
        }
    }

    private final void provideEdges(DataSourceInfo dataSource, SpritePlayer processor, Client client) {
        Result result = client.submit("g.E().count()").one();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"client.submit(\"g.E().count()\").one()");
        long edges = result.getLong();
        long fetched = 0L;
        long skip = 0L;
        long limit = Math.min(edges, 1000L);
        this.log.info("start indexing of data-source {} - total edges:: {} ", (Object)dataSource.getId(), (Object)edges);
        while (fetched < edges - 1L) {
            this.log.info("query:: g.E().range(" + skip + " , " + limit + ')');
            ResultSet resultSet = client.submit("g.E().range(" + skip + " , " + limit + ')');
            for (Result r : resultSet) {
                Object object = r.getObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                }
                Map res = TypeIntrinsics.asMutableMap((Object)object);
                if (res.containsKey("properties")) {
                    Object v = res.get("properties");
                    if (v == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                    }
                    Map props = (Map)v;
                    props.forEach((BiConsumer)new BiConsumer<String, Object>(res){
                        final /* synthetic */ Map $res;

                        public final void accept(@NotNull String k, @NotNull Object v) {
                            Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                            this.$res.put(k, v);
                        }
                        {
                            this.$res = map;
                        }
                    });
                    res.remove("properties");
                    res.remove("class");
                }
                Sprite sprite = new Sprite();
                Iterable $this$forEach$iv = res.keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String k = (String)element$iv;
                    boolean bl = false;
                    sprite.add(k, String.valueOf(res.get(k)));
                }
                sprite.add("_a_id", String.valueOf(dataSource.getId()) + "_" + res.get("id")).add("_a_type", "edge").add("@class", res.get("label")).apply(this.allFields, (Function1)provideEdges.3.INSTANCE);
                processor.play(sprite);
                long l = fetched;
                fetched = l + 1L;
                this.log.info("fetched:: {} ", (Object)fetched);
            }
            skip = limit;
            limit += (long)10000;
        }
    }

    public CosmosDBGremlinGraphProvider() {
        Pattern pattern = Pattern.compile(".*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\".*\")");
        this.allFields = pattern;
    }
}

