/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.comparator;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import sun.misc.Unsafe;

public class OUnsafeByteArrayComparatorV2
implements Comparator<byte[]> {
    public static final OUnsafeByteArrayComparatorV2 INSTANCE = new OUnsafeByteArrayComparatorV2();
    private static final Unsafe unsafe;
    private static final int BYTE_ARRAY_OFFSET;
    private static final boolean littleEndian;
    private static final int LONG_SIZE = 8;

    @Override
    public int compare(byte[] arrayOne, byte[] arrayTwo) {
        int i;
        int WORDS = arrayOne.length / 8;
        for (i = 0; i < WORDS * 8; i += 8) {
            long wTwo;
            long index = i + BYTE_ARRAY_OFFSET;
            long wOne = unsafe.getLong(arrayOne, index);
            if (wOne == (wTwo = unsafe.getLong(arrayTwo, index))) continue;
            if (littleEndian) {
                return OUnsafeByteArrayComparatorV2.lessThanUnsigned(Long.reverseBytes(wOne), Long.reverseBytes(wTwo)) ? -1 : 1;
            }
            return OUnsafeByteArrayComparatorV2.lessThanUnsigned(wOne, wTwo) ? -1 : 1;
        }
        for (i = WORDS * 8; i < arrayOne.length; ++i) {
            int diff = OUnsafeByteArrayComparatorV2.compareUnsignedByte(arrayOne[i], arrayTwo[i]);
            if (diff == 0) continue;
            return diff;
        }
        if (arrayOne.length > arrayTwo.length) {
            return 1;
        }
        if (arrayOne.length < arrayTwo.length) {
            return -1;
        }
        return 0;
    }

    private static boolean lessThanUnsigned(long longOne, long longTwo) {
        return longOne + Long.MIN_VALUE < longTwo + Long.MIN_VALUE;
    }

    private static int compareUnsignedByte(byte byteOne, byte byteTwo) {
        int valOne = byteOne & 0xFF;
        int valTwo = byteTwo & 0xFF;
        return valOne - valTwo;
    }

    static {
        littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
        unsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new Error(e);
                }
                catch (IllegalAccessException e) {
                    throw new Error(e);
                }
            }
        });
        BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
        int byteArrayScale = unsafe.arrayIndexScale(byte[].class);
        if (byteArrayScale != 1) {
            throw new Error();
        }
    }
}

