/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.collection;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class CASObjectArray<T> {
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicReferenceArray<AtomicReferenceArray<T>> containers = new AtomicReferenceArray(32);

    public int add(T value) {
        int newIndex;
        int indexInsideContainer;
        AtomicReferenceArray<Object> container;
        Objects.requireNonNull(value);
        do {
            newIndex = this.size.get();
            int containerIndex = 31 - Integer.numberOfLeadingZeros(newIndex + 1);
            int containerSize = 1 << containerIndex;
            indexInsideContainer = newIndex + 1 - containerSize;
            container = this.containers.get(containerIndex);
            if (container != null || this.containers.compareAndSet(containerIndex, null, container = new AtomicReferenceArray(containerSize))) continue;
            container = this.containers.get(containerIndex);
        } while (!container.compareAndSet(indexInsideContainer, null, value));
        this.size.incrementAndGet();
        return newIndex;
    }

    public void set(int index, T value, T placeholder) {
        AtomicReferenceArray<T> container;
        Objects.requireNonNull(value);
        Objects.requireNonNull(placeholder);
        int size = this.size.get();
        if (size <= index) {
            while (this.add(placeholder) < index) {
            }
        }
        int containerIndex = 31 - Integer.numberOfLeadingZeros(index + 1);
        int containerSize = 1 << containerIndex;
        int indexInsideContainer = index + 1 - containerSize;
        while ((container = this.containers.get(containerIndex)) == null) {
            Thread.yield();
        }
        container.set(indexInsideContainer, value);
    }

    public boolean compareAndSet(int index, T oldValue, T value) {
        AtomicReferenceArray<T> container;
        Objects.requireNonNull(value);
        Objects.requireNonNull(oldValue);
        int size = this.size.get();
        if (size <= index) {
            throw new ArrayIndexOutOfBoundsException("Requested " + index + ", size is " + size);
        }
        int containerIndex = 31 - Integer.numberOfLeadingZeros(index + 1);
        int containerSize = 1 << containerIndex;
        int indexInsideContainer = index + 1 - containerSize;
        while ((container = this.containers.get(containerIndex)) == null) {
            Thread.yield();
        }
        return container.compareAndSet(indexInsideContainer, oldValue, value);
    }

    public T get(int index) {
        T value;
        AtomicReferenceArray<T> container;
        int size = this.size.get();
        if (size <= index) {
            throw new ArrayIndexOutOfBoundsException("Requested " + index + ", size is " + size);
        }
        int containerIndex = 31 - Integer.numberOfLeadingZeros(index + 1);
        int containerSize = 1 << containerIndex;
        int indexInsideContainer = index + 1 - containerSize;
        while ((container = this.containers.get(containerIndex)) == null) {
            Thread.yield();
        }
        while ((value = container.get(indexInsideContainer)) == null) {
            Thread.yield();
        }
        return value;
    }

    public int size() {
        return this.size.get();
    }
}

