/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocatorMXBean;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.ODirectMemoryAllocationFailedException;
import com.orientechnologies.common.jnr.ONative;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import jnr.ffi.NativeLong;
import jnr.ffi.Pointer;
import jnr.ffi.byref.PointerByReference;

public class ODirectMemoryAllocator
implements ODirectMemoryAllocatorMXBean {
    private static final boolean TRACK = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
    private static final AtomicReference<ODirectMemoryAllocator> INSTANCE_HOLDER = new AtomicReference();
    private final ReferenceQueue<OPointer> trackedPointersQueue;
    private final Set<TrackedPointerReference> trackedReferences;
    private final Map<TrackedPointerKey, TrackedPointerReference> trackedBuffers;
    private final LongAdder memoryConsumption = new LongAdder();
    private final boolean isLinux = Platform.getPlatform().getOS() == Platform.OS.LINUX;

    public static ODirectMemoryAllocator instance() {
        ODirectMemoryAllocator inst = INSTANCE_HOLDER.get();
        if (inst != null) {
            return inst;
        }
        ODirectMemoryAllocator newAllocator = new ODirectMemoryAllocator();
        if (INSTANCE_HOLDER.compareAndSet(null, newAllocator)) {
            return newAllocator;
        }
        return INSTANCE_HOLDER.get();
    }

    public ODirectMemoryAllocator() {
        this.trackedPointersQueue = new ReferenceQueue();
        this.trackedReferences = new HashSet<TrackedPointerReference>();
        this.trackedBuffers = new HashMap<TrackedPointerKey, TrackedPointerReference>();
    }

    public OPointer allocate(int size, int align, boolean clear) {
        OPointer ptr;
        if (size <= 0) {
            throw new IllegalArgumentException("Size of allocated memory can not be less or equal to 0");
        }
        if (align <= 0) {
            long pointer = MemoryIO.getInstance().allocateMemory(size, clear);
            if (pointer <= 0L) {
                throw new ODirectMemoryAllocationFailedException("Can not allocate direct memory chunk of size " + size);
            }
            ptr = new OPointer(pointer, size);
        } else {
            if (!this.isLinux) {
                throw new ODirectMemoryAllocationFailedException("Alignment of pointers is allowed only on Linux platforms.");
            }
            PointerByReference pointerByReference = new PointerByReference();
            ONative.instance().posix_memalign(pointerByReference, new NativeLong(align), new NativeLong(size));
            ptr = new OPointer(((Pointer)pointerByReference.getValue()).address(), size);
        }
        this.memoryConsumption.add(size);
        return this.track(ptr);
    }

    public void deallocate(OPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException("Null value is passed");
        }
        long ptr = pointer.getNativePointer();
        if (ptr > 0L) {
            MemoryIO.getInstance().freeMemory(ptr);
            this.memoryConsumption.add(-pointer.getSize());
            this.untrack(pointer);
        }
    }

    @Override
    public long getMemoryConsumption() {
        return this.memoryConsumption.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMemoryLeaks() {
        if (TRACK) {
            long memCons = this.memoryConsumption.longValue();
            if (memCons > 0L) {
                OLogManager.instance().warnNoDb(this, "DIRECT-TRACK: memory consumption is not zero (%d bytes), it may indicate presence of memory leaks", memCons);
                assert (false);
            }
            ODirectMemoryAllocator oDirectMemoryAllocator = this;
            synchronized (oDirectMemoryAllocator) {
                for (TrackedPointerReference reference : this.trackedReferences) {
                    OLogManager.instance().errorNoDb(this, "DIRECT-TRACK: unreleased direct memory pointer `%X` detected.", reference.stackTrace, reference.id);
                }
                this.checkTrackedPointerLeaks();
                assert (this.trackedReferences.size() == 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OPointer track(OPointer pointer) {
        if (TRACK) {
            ODirectMemoryAllocator oDirectMemoryAllocator = this;
            synchronized (oDirectMemoryAllocator) {
                TrackedPointerReference reference = new TrackedPointerReference(pointer, this.trackedPointersQueue);
                this.trackedReferences.add(reference);
                this.trackedBuffers.put(new TrackedPointerKey(pointer), reference);
                this.checkTrackedPointerLeaks();
            }
        }
        return pointer;
    }

    public void checkTrackedPointerLeaks() {
        TrackedPointerReference reference;
        boolean leaked = false;
        while ((reference = (TrackedPointerReference)this.trackedPointersQueue.poll()) != null) {
            if (!this.trackedReferences.remove(reference)) continue;
            OLogManager.instance().errorNoDb(this, "DIRECT-TRACK: unreleased direct memory pointer `%X` detected.", reference.stackTrace, reference.id);
            leaked = true;
        }
        assert (!leaked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrack(OPointer pointer) {
        if (TRACK) {
            ODirectMemoryAllocator oDirectMemoryAllocator = this;
            synchronized (oDirectMemoryAllocator) {
                TrackedPointerKey trackedBufferKey = new TrackedPointerKey(pointer);
                TrackedPointerReference reference = this.trackedBuffers.remove(trackedBufferKey);
                if (reference == null) {
                    OLogManager.instance().errorNoDb(this, "DIRECT-TRACK: untracked direct memory pointer `%X` detected.", new Exception(), ODirectMemoryAllocator.id(pointer));
                    assert (false);
                } else {
                    this.trackedReferences.remove(reference);
                    reference.clear();
                }
                this.checkTrackedPointerLeaks();
            }
        }
    }

    private static int id(Object object) {
        return System.identityHashCode(object);
    }

    private static class TrackedPointerKey
    extends WeakReference<OPointer> {
        private final int hashCode;

        TrackedPointerKey(OPointer referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            OPointer pointer = (OPointer)this.get();
            return pointer != null && pointer == ((TrackedPointerKey)obj).get();
        }
    }

    private static class TrackedPointerReference
    extends WeakReference<OPointer> {
        public final int id;
        private final Exception stackTrace;

        TrackedPointerReference(OPointer referent, ReferenceQueue<? super OPointer> q) {
            super(referent, q);
            this.id = ODirectMemoryAllocator.id(referent);
            this.stackTrace = new Exception();
        }
    }
}

