/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.kenai.jffi.MemoryIO;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class OPointer {
    private final long pointer;
    private final int size;
    private WeakReference<ByteBuffer> byteBuffer;
    private int hash = 0;

    OPointer(long pointer, int size) {
        this.pointer = pointer;
        this.size = size;
    }

    public void clear() {
        MemoryIO.getInstance().setMemory(this.pointer, this.size, (byte)0);
    }

    public ByteBuffer getNativeByteBuffer() {
        ByteBuffer buffer;
        if (this.byteBuffer == null) {
            buffer = this.createNativeBuffer();
            this.byteBuffer = new WeakReference<ByteBuffer>(buffer);
        } else {
            buffer = (ByteBuffer)this.byteBuffer.get();
            if (buffer == null) {
                buffer = this.createNativeBuffer();
                this.byteBuffer = new WeakReference<ByteBuffer>(buffer);
            }
        }
        return buffer;
    }

    long getNativePointer() {
        return this.pointer;
    }

    int getSize() {
        return this.size;
    }

    private ByteBuffer createNativeBuffer() {
        return MemoryIO.getInstance().newDirectByteBuffer(this.pointer, this.size).order(ByteOrder.nativeOrder());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OPointer pointer1 = (OPointer)o;
        if (this.pointer != pointer1.pointer) {
            return false;
        }
        return this.size == pointer1.size;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int result = (int)(this.pointer ^ this.pointer >>> 32);
        this.hash = result = 31 * result + this.size;
        return this.hash;
    }
}

