/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.spliterators;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Streams {
    public static <T> Stream<T> mergeSortedSpliterators(Stream<T> streamOne, Stream<T> streamTwo, Comparator<? super T> comparator) {
        SortedStreamSpliterator spliterator = new SortedStreamSpliterator(streamOne.spliterator(), streamTwo.spliterator(), comparator);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(Streams.composedClose(streamOne, streamTwo));
    }

    private static Runnable composedClose(BaseStream<?, ?> a, BaseStream<?, ?> b) {
        return () -> {
            try {
                a.close();
            }
            catch (Throwable e1) {
                try {
                    b.close();
                }
                catch (Throwable e2) {
                    try {
                        e1.addSuppressed(e2);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                throw e1;
            }
            b.close();
        };
    }

    private static final class SortedStreamSpliterator<T>
    implements Spliterator<T>,
    Consumer<T> {
        private boolean firstStream;
        private final Spliterator<T> firstSpliterator;
        private final Spliterator<T> secondSpliterator;
        private T firstValue;
        private T secondValue;
        private final Comparator<? super T> comparator;

        private SortedStreamSpliterator(Spliterator<T> firstSpliterator, Spliterator<T> secondSpliterator, Comparator<? super T> comparator) {
            this.firstSpliterator = firstSpliterator;
            this.secondSpliterator = secondSpliterator;
            this.comparator = comparator;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.firstValue == null) {
                this.firstStream = true;
                if (!this.firstSpliterator.tryAdvance(this)) {
                    this.firstValue = null;
                }
            }
            if (this.secondValue == null) {
                this.firstStream = false;
                if (!this.secondSpliterator.tryAdvance(this)) {
                    this.secondValue = null;
                }
            }
            if (this.firstValue == null && this.secondValue == null) {
                return false;
            }
            if (this.secondValue == null) {
                action.accept(this.firstValue);
                this.firstValue = null;
                return true;
            }
            if (this.firstValue == null) {
                action.accept(this.secondValue);
                this.secondValue = null;
                return true;
            }
            int res = this.comparator.compare(this.firstValue, this.secondValue);
            if (res == 0) {
                if (this.firstValue.equals(this.secondValue)) {
                    action.accept(this.firstValue);
                    this.firstValue = null;
                    this.secondValue = null;
                    return true;
                }
                action.accept(this.firstValue);
                this.firstValue = null;
                return true;
            }
            if (res < 0) {
                action.accept(this.firstValue);
                this.firstValue = null;
                return true;
            }
            action.accept(this.secondValue);
            this.secondValue = null;
            return true;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.comparator;
        }

        @Override
        public void accept(T t) {
            if (this.firstStream) {
                this.firstValue = t;
            } else {
                this.secondValue = t;
            }
        }
    }
}

