/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;

public class OOpenResponse
implements OBinaryResponse {
    private int sessionId;
    private byte[] sessionToken;
    private int[] clusterIds;
    private String[] clusterNames;
    private byte[] distributedConfiguration;
    private String serverVersion;

    public OOpenResponse() {
    }

    public OOpenResponse(int sessionId, byte[] sessionToken, int[] clusterIds, String[] clusterNames, byte[] distriConf, String version) {
        this.sessionId = sessionId;
        this.sessionToken = sessionToken;
        this.clusterIds = clusterIds;
        this.clusterNames = clusterNames;
        this.distributedConfiguration = distriConf;
        this.serverVersion = version;
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        channel.writeInt(this.sessionId);
        if (protocolVersion > 26) {
            channel.writeBytes(this.sessionToken);
        }
        OMessageHelper.writeClustersArray(channel, new ORawPair<String[], int[]>(this.clusterNames, this.clusterIds), protocolVersion);
        channel.writeBytes(this.distributedConfiguration);
        channel.writeString(this.serverVersion);
    }

    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        this.sessionId = network.readInt();
        this.sessionToken = network.readBytes();
        ORawPair<String[], int[]> clusters = OMessageHelper.readClustersArray(network);
        this.distributedConfiguration = network.readBytes();
        this.serverVersion = network.readString();
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public byte[] getSessionToken() {
        return this.sessionToken;
    }

    public int[] getClusterIds() {
        return this.clusterIds;
    }

    public String[] getClusterNames() {
        return this.clusterNames;
    }

    public byte[] getDistributedConfiguration() {
        return this.distributedConfiguration;
    }
}

