/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.log.OLogManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class OConstants {
    public static final String ORIENT_URL = "https://www.orientdb.com";
    public static final String COPYRIGHT = "Copyrights (c) 2017 OrientDB LTD";
    public static final String CODENAME = "Veloce";
    private static final Properties properties = new Properties();

    public static int getVersionMajor() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length == 0) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve version information for this build", null, new Object[0]);
            return -1;
        }
        try {
            return Integer.parseInt(versions[0]);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve major version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static int getVersionMinor() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length < 2) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve minor version information for this build", null, new Object[0]);
            return -1;
        }
        try {
            return Integer.parseInt(versions[1]);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve minor version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static int getVersionHotfix() {
        String[] versions = properties.getProperty("version").split("\\.");
        if (versions.length < 3) {
            return 0;
        }
        try {
            String hotfix = versions[2];
            int snapshotIndex = hotfix.indexOf("-SNAPSHOT");
            if (snapshotIndex != -1) {
                hotfix = hotfix.substring(0, snapshotIndex);
            }
            return Integer.parseInt(hotfix);
        }
        catch (NumberFormatException nfe) {
            OLogManager.instance().errorNoDb(OConstants.class, "Can not retrieve hotfix version information for this build", nfe, new Object[0]);
            return -1;
        }
    }

    public static String getRawVersion() {
        return properties.getProperty("version");
    }

    public static String getVersion() {
        return properties.getProperty("version") + " - " + CODENAME + " (build " + properties.getProperty("revision") + ", branch " + properties.getProperty("branch") + ")";
    }

    public static boolean isSnapshot() {
        return properties.getProperty("version").endsWith("SNAPSHOT");
    }

    public static String getBuildNumber() {
        return properties.getProperty("revision");
    }

    static {
        InputStream inputStream = OConstants.class.getResourceAsStream("/com/orientechnologies/orientdb.properties");
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            OLogManager.instance().errorNoDb(OConstants.class, "Failed to load OrientDB properties", e, new Object[0]);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

