/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.replication.OAsyncReplicationOk;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class OCommandRequestAbstract
implements OCommandRequestInternal,
ODistributedCommand {
    protected OCommandResultListener resultListener;
    protected OProgressListener progressListener;
    protected int limit = -1;
    protected long timeoutMs = OGlobalConfiguration.COMMAND_TIMEOUT.getValueAsLong();
    protected OCommandContext.TIMEOUT_STRATEGY timeoutStrategy = OCommandContext.TIMEOUT_STRATEGY.EXCEPTION;
    protected Map<Object, Object> parameters;
    protected String fetchPlan = null;
    protected boolean useCache = false;
    protected boolean cacheableResult = false;
    protected OCommandContext context;
    protected OAsyncReplicationOk onAsyncReplicationOk;
    protected OAsyncReplicationError onAsyncReplicationError;
    private final Set<String> nodesToExclude = new HashSet<String>();
    private boolean recordResultSet = true;

    protected OCommandRequestAbstract() {
    }

    @Override
    public OCommandResultListener getResultListener() {
        return this.resultListener;
    }

    @Override
    public void setResultListener(OCommandResultListener iListener) {
        this.resultListener = iListener;
    }

    @Override
    public Map<Object, Object> getParameters() {
        return this.parameters;
    }

    protected void setParameters(Object ... iArgs) {
        if (iArgs != null && iArgs.length > 0) {
            this.parameters = this.convertToParameters(iArgs);
        }
    }

    protected Map<Object, Object> convertToParameters(Object ... iArgs) {
        HashMap<Object, Object> params;
        if (iArgs.length == 1 && iArgs[0] instanceof Map) {
            params = (HashMap<Object, Object>)iArgs[0];
        } else {
            if (iArgs.length == 1 && iArgs[0] != null && iArgs[0].getClass().isArray() && iArgs[0] instanceof Object[]) {
                iArgs = (Object[])iArgs[0];
            }
            params = new HashMap<Object, Object>(iArgs.length);
            for (int i = 0; i < iArgs.length; ++i) {
                Object par = iArgs[i];
                if (par instanceof OIdentifiable && ((OIdentifiable)par).getIdentity().isValid()) {
                    par = ((OIdentifiable)par).getIdentity();
                }
                params.put(i, par);
            }
        }
        return params;
    }

    @Override
    public OCommandRequestAbstract onAsyncReplicationOk(OAsyncReplicationOk iCallback) {
        this.onAsyncReplicationOk = iCallback;
        return this;
    }

    @Override
    public OCommandRequestAbstract onAsyncReplicationError(final OAsyncReplicationError iCallback) {
        this.onAsyncReplicationError = iCallback != null ? new OAsyncReplicationError(){
            private int retry = 0;

            @Override
            public OAsyncReplicationError.ACTION onAsyncReplicationError(Throwable iException, int iRetry) {
                switch (iCallback.onAsyncReplicationError(iException, ++this.retry)) {
                    case RETRY: {
                        OCommandRequestAbstract.this.execute(new Object[0]);
                        break;
                    }
                }
                return OAsyncReplicationError.ACTION.IGNORE;
            }
        } : null;
        return this;
    }

    @Override
    public OProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public OCommandRequestAbstract setProgressListener(OProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    @Override
    public void reset() {
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public OCommandRequestAbstract setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public String getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public <RET extends OCommandRequest> RET setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return (RET)this;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    @Override
    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    @Override
    public boolean isCacheableResult() {
        return this.cacheableResult;
    }

    @Override
    public void setCacheableResult(boolean iValue) {
        this.cacheableResult = iValue;
    }

    @Override
    public OCommandContext getContext() {
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        return this.context;
    }

    @Override
    public OCommandRequestAbstract setContext(OCommandContext iContext) {
        this.context = iContext;
        return this;
    }

    @Override
    public long getTimeoutTime() {
        return this.timeoutMs;
    }

    @Override
    public void setTimeout(long timeout, OCommandContext.TIMEOUT_STRATEGY strategy) {
        this.timeoutMs = timeout;
        this.timeoutStrategy = strategy;
    }

    @Override
    public OCommandContext.TIMEOUT_STRATEGY getTimeoutStrategy() {
        return this.timeoutStrategy;
    }

    @Override
    public Set<String> nodesToExclude() {
        return Collections.unmodifiableSet(this.nodesToExclude);
    }

    public void addExcludedNode(String node) {
        this.nodesToExclude.add(node);
    }

    public void removeExcludedNode(String node) {
        this.nodesToExclude.remove(node);
    }

    public OAsyncReplicationOk getOnAsyncReplicationOk() {
        return this.onAsyncReplicationOk;
    }

    public OAsyncReplicationError getOnAsyncReplicationError() {
        return this.onAsyncReplicationError;
    }

    @Override
    public void setRecordResultSet(boolean recordResultSet) {
        this.recordResultSet = recordResultSet;
    }

    @Override
    public boolean isRecordResultSet() {
        return this.recordResultSet;
    }
}

