/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationUpdateListener;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OImmutableRecordId;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OStorageConfigurationImpl
implements OSerializableStream,
OStorageConfiguration {
    private static final ORecordId CONFIG_RID = new OImmutableRecordId(0, 0L);
    protected final OReadersWriterSpinLock lock = new OReadersWriterSpinLock();
    private String charset;
    private final List<OStorageEntryConfiguration> properties = new ArrayList<OStorageEntryConfiguration>();
    private final transient OAbstractPaginatedStorage storage;
    private OContextConfiguration configuration;
    private int version;
    private String name;
    private String schemaRecordId;
    private String dictionaryRecordId;
    private String indexMgrRecordId;
    private String dateFormat;
    private String dateTimeFormat;
    private int binaryFormatVersion;
    private OStorageSegmentConfiguration fileTemplate;
    private List<OStorageClusterConfiguration> clusters;
    private String localeLanguage;
    private String localeCountry;
    private TimeZone timeZone;
    private transient Locale localeInstance;
    private String clusterSelection;
    private String conflictStrategy;
    private String recordSerializer;
    private int recordSerializerVersion;
    private ConcurrentMap<String, OStorageConfiguration.IndexEngineData> indexEngines;
    private int pageSize = -1;
    private int freeListBoundary = -1;
    private int maxKeySize = -1;
    private transient boolean validation = true;
    protected OStorageConfigurationUpdateListener updateListener;
    private String createdAtVersion;
    protected final Charset streamCharset;

    public OStorageConfigurationImpl(OAbstractPaginatedStorage iStorage, Charset streamCharset) {
        this.lock.acquireWriteLock();
        try {
            this.streamCharset = streamCharset;
            this.storage = iStorage;
            this.initConfiguration(new OContextConfiguration());
            this.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getPageSize() {
        this.lock.acquireReadLock();
        try {
            int n = this.pageSize;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setPageSize(int pageSize) {
        this.lock.acquireWriteLock();
        try {
            this.pageSize = pageSize;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getFreeListBoundary() {
        this.lock.acquireReadLock();
        try {
            int n = this.freeListBoundary;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setFreeListBoundary(int freeListBoundary) {
        this.lock.acquireWriteLock();
        try {
            this.freeListBoundary = freeListBoundary;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getMaxKeySize() {
        this.lock.acquireReadLock();
        try {
            int n = this.maxKeySize;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setMaxKeySize(int maxKeySize) {
        this.lock.acquireWriteLock();
        try {
            this.maxKeySize = maxKeySize;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setCreationVersion(String version) {
        this.lock.acquireWriteLock();
        try {
            this.createdAtVersion = version;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getCreatedAtVersion() {
        this.lock.acquireReadLock();
        try {
            String string = this.createdAtVersion;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void initConfiguration(OContextConfiguration conf) {
        this.lock.acquireWriteLock();
        try {
            this.configuration = conf;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.fileTemplate = new OStorageSegmentConfiguration();
        this.charset = "UTF-8";
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            this.properties.clear();
        }
        this.version = -1;
        this.name = null;
        this.schemaRecordId = null;
        this.dictionaryRecordId = null;
        this.indexMgrRecordId = null;
        this.dateFormat = "yyyy-MM-dd";
        this.dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        this.binaryFormatVersion = 0;
        this.clusters = Collections.synchronizedList(new ArrayList());
        this.localeLanguage = Locale.getDefault().getLanguage();
        this.localeCountry = Locale.getDefault().getCountry();
        this.timeZone = TimeZone.getDefault();
        this.localeInstance = null;
        this.clusterSelection = null;
        this.conflictStrategy = null;
        this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS.getValueAsInteger());
        this.autoInitClusters();
        this.recordSerializer = null;
        this.recordSerializerVersion = 0;
        this.indexEngines = new ConcurrentHashMap<String, OStorageConfiguration.IndexEngineData>();
        this.validation = this.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.DB_VALIDATION);
        this.binaryFormatVersion = 13;
    }

    private void autoInitClusters() {
        if (this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS) == 0) {
            int cpus = Runtime.getRuntime().availableProcessors();
            this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)(cpus > 64 ? 64 : cpus));
        }
    }

    @Override
    public String getConflictStrategy() {
        this.lock.acquireReadLock();
        try {
            String string = this.conflictStrategy;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setConflictStrategy(String conflictStrategy) {
        this.lock.acquireWriteLock();
        try {
            this.conflictStrategy = conflictStrategy;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public OContextConfiguration getContextConfiguration() {
        this.lock.acquireReadLock();
        try {
            OContextConfiguration oContextConfiguration = this.configuration;
            return oContextConfiguration;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public OStorageConfigurationImpl load(OContextConfiguration configuration) throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            this.initConfiguration(configuration);
            byte[] record = this.storage.readRecord((ORecordId)OStorageConfigurationImpl.CONFIG_RID, null, (boolean)false, (boolean)false, null).getResult().buffer;
            if (record == null) {
                throw new OStorageException("Cannot load database configuration. The database seems corrupted");
            }
            this.fromStream(record, 0, record.length, this.streamCharset);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return this;
    }

    public void update() throws OSerializationException {
        this.lock.acquireWriteLock();
        try {
            byte[] record = this.toStream(this.streamCharset);
            this.storage.updateRecord(CONFIG_RID, true, record, -1, (byte)98, 0, null);
            if (this.updateListener != null) {
                this.updateListener.onUpdate(this);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getDirectory() {
        this.lock.acquireReadLock();
        try {
            if (this.fileTemplate.location != null) {
                String string = this.fileTemplate.getLocation();
                return string;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (this.storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)this.storage).getStoragePath().toString();
        }
        return null;
    }

    @Override
    public Locale getLocaleInstance() {
        this.lock.acquireReadLock();
        try {
            if (this.localeInstance == null) {
                try {
                    this.localeInstance = new Locale(this.localeLanguage, this.localeCountry);
                }
                catch (RuntimeException e) {
                    this.localeInstance = Locale.getDefault();
                    OLogManager.instance().errorNoDb(this, "Error during initialization of locale, default one %s will be used", e, this.localeInstance);
                }
            }
            Locale locale = this.localeInstance;
            return locale;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public SimpleDateFormat getDateFormatInstance() {
        this.lock.acquireReadLock();
        try {
            SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.dateFormat);
            dateFormatInstance.setLenient(false);
            dateFormatInstance.setTimeZone(this.timeZone);
            SimpleDateFormat simpleDateFormat = dateFormatInstance;
            return simpleDateFormat;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public SimpleDateFormat getDateTimeFormatInstance() {
        this.lock.acquireReadLock();
        try {
            SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.dateTimeFormat);
            dateTimeFormatInstance.setLenient(false);
            dateTimeFormatInstance.setTimeZone(this.timeZone);
            SimpleDateFormat simpleDateFormat = dateTimeFormatInstance;
            return simpleDateFormat;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromStream(byte[] stream, int offset, int length, Charset charset) {
        this.lock.acquireWriteLock();
        try {
            int i;
            this.clear();
            String[] values = new String(stream, offset, length, charset).split("\\|");
            int index = 0;
            this.version = Integer.parseInt(this.read(values[index++]));
            if (this.version < 14) {
                throw new OStorageException("cannot open database created with a version before 2.0 ");
            }
            this.name = this.read(values[index++]);
            this.schemaRecordId = this.read(values[index++]);
            this.dictionaryRecordId = this.read(values[index++]);
            this.indexMgrRecordId = this.read(values[index++]);
            this.localeLanguage = this.read(values[index++]);
            this.localeCountry = this.read(values[index++]);
            if (this.localeLanguage == null || this.localeCountry == null) {
                Locale locale = Locale.getDefault();
                if (this.localeLanguage == null) {
                    OLogManager.instance().warn((Object)this, "Information about storage locale is undefined (language is undefined) default locale " + locale + " will be used", new Object[0]);
                }
                if (this.localeCountry == null) {
                    OLogManager.instance().warn((Object)this, "Information about storage locale is undefined (country is undefined) default locale " + locale + " will be used", new Object[0]);
                }
            }
            this.dateFormat = this.read(values[index++]);
            this.dateTimeFormat = this.read(values[index++]);
            this.timeZone = TimeZone.getTimeZone(this.read(values[index++]));
            this.charset = this.read(values[index++]);
            ORecordConflictStrategyFactory conflictStrategyFactory = Orient.instance().getRecordConflictStrategy();
            this.conflictStrategy = conflictStrategyFactory.getStrategy(this.read(values[index++])).getName();
            index = this.phySegmentFromStream(values, index, this.fileTemplate);
            int size = Integer.parseInt(this.read(values[index++]));
            this.clusters.clear();
            String determineStorageCompression = null;
            for (i = 0; i < size; ++i) {
                OStoragePaginatedClusterConfiguration currentCluster;
                String clusterType;
                int clusterId;
                if ((clusterId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
                String clusterName = this.read(values[index++]);
                this.read(values[index++]);
                switch (clusterType = this.read(values[index++])) {
                    case "d": {
                        boolean cc = Boolean.valueOf(this.read(values[index++]));
                        float bb = Float.valueOf(this.read(values[index++])).floatValue();
                        float aa = Float.valueOf(this.read(values[index++])).floatValue();
                        String clusterCompression = this.read(values[index++]);
                        if (determineStorageCompression == null) {
                            determineStorageCompression = clusterCompression;
                        }
                        String clusterEncryption = null;
                        if (this.version >= 15) {
                            clusterEncryption = this.read(values[index++]);
                        }
                        String clusterConflictStrategy = this.read(values[index++]);
                        OStorageClusterConfiguration.STATUS status = OStorageClusterConfiguration.STATUS.valueOf(this.read(values[index++]));
                        int clusterBinaryVersion = this.version >= 21 ? Integer.parseInt(this.read(values[index++])) : 0;
                        currentCluster = new OStoragePaginatedClusterConfiguration(clusterId, clusterName, null, cc, bb, aa, clusterCompression, clusterEncryption, this.configuration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY), clusterConflictStrategy, status, clusterBinaryVersion);
                        break;
                    }
                    case "p": {
                        throw new IllegalArgumentException("Cluster of storage 'local' are not supported since 2.0");
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported cluster type: " + clusterType);
                    }
                }
                for (int c = this.clusters.size(); c <= clusterId; ++c) {
                    this.clusters.add(null);
                }
                this.clusters.set(clusterId, currentCluster);
            }
            size = Integer.parseInt(this.read(values[index++]));
            this.clearProperties();
            for (i = 0; i < size; ++i) {
                this.setProperty(this.read(values[index++]), this.read(values[index++]));
            }
            this.binaryFormatVersion = Integer.parseInt(this.read(values[index++]));
            this.clusterSelection = this.read(values[index++]);
            this.setMinimumClusters(Integer.parseInt(this.read(values[index++])));
            this.autoInitClusters();
            this.recordSerializer = this.read(values[index++]);
            this.recordSerializerVersion = Integer.parseInt(this.read(values[index++]));
            int cfgSize = Integer.parseInt(this.read(values[index++]));
            for (int i2 = 0; i2 < cfgSize; ++i2) {
                String key = this.read(values[index++]);
                String value = this.read(values[index++]);
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
                if (cfg != null) {
                    if (value == null) continue;
                    this.configuration.setValue(key, OType.convert(value, cfg.getType()));
                    continue;
                }
                OLogManager.instance().warn((Object)this, "Ignored storage configuration because not supported: %s=%s", key, value);
            }
            if (this.version > 15) {
                int enginesSize = Integer.parseInt(this.read(values[index++]));
                for (int i3 = 0; i3 < enginesSize; ++i3) {
                    boolean mulitvalue;
                    int apiVersion;
                    HashMap<String, String> engineProperties;
                    int propertiesSize;
                    String name = this.read(values[index++]);
                    String algorithm = this.read(values[index++]);
                    String indexType = this.version > 16 ? this.read(values[index++]) : "";
                    byte valueSerializerId = Byte.parseByte(this.read(values[index++]));
                    byte keySerializerId = Byte.parseByte(this.read(values[index++]));
                    boolean isAutomatic = Boolean.parseBoolean(this.read(values[index++]));
                    Boolean durableInNonTxMode = this.read(values[index]) == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.read(values[index++])));
                    int n = ++index;
                    int version = Integer.parseInt(this.read(values[n]));
                    int n2 = ++index;
                    boolean nullValuesSupport = Boolean.parseBoolean(this.read(values[n2]));
                    int n3 = ++index;
                    ++index;
                    int keySize = Integer.parseInt(this.read(values[n3]));
                    String encryption = null;
                    String encryptionOptions = null;
                    if (this.version > 19) {
                        encryption = this.read(values[index++]);
                        encryptionOptions = this.read(values[index++]);
                    }
                    int typesLength = Integer.parseInt(this.read(values[index++]));
                    OType[] types = new OType[typesLength];
                    for (int n4 = 0; n4 < types.length; ++n4) {
                        OType type;
                        types[n4] = type = OType.valueOf(this.read(values[index++]));
                    }
                    if ((propertiesSize = Integer.parseInt(this.read(values[index++]))) == 0) {
                        engineProperties = null;
                    } else {
                        engineProperties = new HashMap<String, String>(propertiesSize);
                        for (int n5 = 0; n5 < propertiesSize; ++n5) {
                            String key = this.read(values[index++]);
                            String value = this.read(values[index++]);
                            engineProperties.put(key, value);
                        }
                    }
                    if (this.version >= 22) {
                        apiVersion = Integer.parseInt(this.read(values[index++]));
                        mulitvalue = Boolean.parseBoolean(this.read(values[index++]));
                    } else {
                        apiVersion = 0;
                        mulitvalue = false;
                    }
                    OStorageConfiguration.IndexEngineData indexEngineData = new OStorageConfiguration.IndexEngineData(Integer.MIN_VALUE, name, algorithm, indexType, durableInNonTxMode, version, apiVersion, mulitvalue, valueSerializerId, keySerializerId, isAutomatic, types, nullValuesSupport, keySize, encryption, encryptionOptions, engineProperties);
                    this.indexEngines.put(name, indexEngineData);
                }
            }
            if (this.version > 17) {
                this.createdAtVersion = this.read(values[index++]);
            }
            if (this.version > 18) {
                this.pageSize = Integer.parseInt(this.read(values[index++]));
                this.freeListBoundary = Integer.parseInt(this.read(values[index++]));
                this.maxKeySize = Integer.parseInt(this.read(values[index++]));
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    @Deprecated
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        this.fromStream(iStream, 0, iStream.length, Charset.defaultCharset());
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.toStream(Integer.MAX_VALUE, Charset.defaultCharset());
    }

    public byte[] toStream(Charset charset) throws OSerializationException {
        return this.toStream(Integer.MAX_VALUE, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toStream(int iNetworkVersion, Charset charset) throws OSerializationException {
        this.lock.acquireReadLock();
        try {
            StringBuilder buffer = new StringBuilder(8192);
            this.write(buffer, 23);
            this.write(buffer, this.name);
            this.write(buffer, this.schemaRecordId);
            this.write(buffer, this.dictionaryRecordId);
            this.write(buffer, this.indexMgrRecordId);
            this.write(buffer, this.localeLanguage);
            this.write(buffer, this.localeCountry);
            this.write(buffer, this.dateFormat);
            this.write(buffer, this.dateTimeFormat);
            this.write(buffer, this.timeZone.getID());
            this.write(buffer, charset);
            if (iNetworkVersion > 24) {
                this.write(buffer, this.conflictStrategy);
            }
            this.phySegmentToStream(buffer, this.fileTemplate);
            this.write(buffer, this.clusters.size());
            for (OStorageClusterConfiguration oStorageClusterConfiguration : this.clusters) {
                if (oStorageClusterConfiguration == null) {
                    this.write(buffer, -1);
                    continue;
                }
                this.write(buffer, oStorageClusterConfiguration.getId());
                this.write(buffer, oStorageClusterConfiguration.getName());
                this.write(buffer, oStorageClusterConfiguration.getDataSegmentId());
                if (!(oStorageClusterConfiguration instanceof OStoragePaginatedClusterConfiguration)) continue;
                this.write(buffer, "d");
                OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)oStorageClusterConfiguration;
                this.write(buffer, paginatedClusterConfiguration.useWal);
                this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordOverflowGrowFactor));
                this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordGrowFactor));
                this.write(buffer, paginatedClusterConfiguration.compression);
                if (iNetworkVersion >= 31) {
                    this.write(buffer, paginatedClusterConfiguration.encryption);
                }
                if (iNetworkVersion > 24) {
                    this.write(buffer, paginatedClusterConfiguration.conflictStrategy);
                }
                if (iNetworkVersion > 25) {
                    this.write(buffer, paginatedClusterConfiguration.getStatus().name());
                }
                if (iNetworkVersion < Integer.MAX_VALUE) continue;
                this.write(buffer, paginatedClusterConfiguration.getBinaryVersion());
            }
            if (iNetworkVersion <= 25) {
                this.write(buffer, 0);
                this.write(buffer, "");
                this.write(buffer, "");
                this.write(buffer, 0);
                this.write(buffer, false);
                this.write(buffer, false);
            }
            Object object = this.properties;
            synchronized (object) {
                this.write(buffer, this.properties.size());
                for (OStorageEntryConfiguration e : this.properties) {
                    this.entryToStream(buffer, e);
                }
            }
            this.write(buffer, this.binaryFormatVersion);
            this.write(buffer, this.clusterSelection);
            this.write(buffer, this.getMinimumClusters());
            if (iNetworkVersion > 24) {
                this.write(buffer, this.recordSerializer);
                this.write(buffer, this.recordSerializerVersion);
                this.write(buffer, this.configuration.getContextSize());
                for (String string : this.configuration.getContextKeys()) {
                    OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(string);
                    this.write(buffer, string);
                    if (cfg != null) {
                        this.write(buffer, cfg.isHidden() ? null : this.configuration.getValueAsString(cfg));
                        continue;
                    }
                    this.write(buffer, null);
                    OLogManager.instance().warn((Object)this, "Storing configuration for property:'" + string + "' not existing in current version", new Object[0]);
                }
            }
            this.write(buffer, this.indexEngines.size());
            for (OStorageConfiguration.IndexEngineData indexEngineData : this.indexEngines.values()) {
                this.write(buffer, indexEngineData.getName());
                this.write(buffer, indexEngineData.getAlgorithm());
                this.write(buffer, indexEngineData.getIndexType() == null ? "" : indexEngineData.getIndexType());
                this.write(buffer, indexEngineData.getValueSerializerId());
                this.write(buffer, indexEngineData.getKeySerializedId());
                this.write(buffer, indexEngineData.isAutomatic());
                this.write(buffer, indexEngineData.getDurableInNonTxMode());
                this.write(buffer, indexEngineData.getVersion());
                this.write(buffer, indexEngineData.isNullValuesSupport());
                this.write(buffer, indexEngineData.getKeySize());
                this.write(buffer, indexEngineData.getEncryption());
                this.write(buffer, indexEngineData.getEncryptionOptions());
                if (indexEngineData.getKeyTypes() != null) {
                    this.write(buffer, indexEngineData.getKeyTypes().length);
                    for (OType type : indexEngineData.getKeyTypes()) {
                        this.write(buffer, type.name());
                    }
                } else {
                    this.write(buffer, 0);
                }
                if (indexEngineData.getEngineProperties() == null) {
                    this.write(buffer, 0);
                } else {
                    this.write(buffer, indexEngineData.getEngineProperties().size());
                    for (Map.Entry entry : indexEngineData.getEngineProperties().entrySet()) {
                        this.write(buffer, entry.getKey());
                        this.write(buffer, entry.getValue());
                    }
                }
                this.write(buffer, indexEngineData.getApiVersion());
                this.write(buffer, indexEngineData.isMultivalue());
            }
            this.write(buffer, this.createdAtVersion);
            this.write(buffer, this.pageSize);
            this.write(buffer, this.freeListBoundary);
            this.write(buffer, this.maxKeySize);
            buffer.append("|");
            object = buffer.toString().getBytes(charset);
            return object;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void create() throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.storage.createRecord(CONFIG_RID, new byte[]{0, 0, 0, 0}, 0, (byte)98, null);
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void delete() throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.close();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void close() throws IOException {
        this.lock.acquireWriteLock();
        try {
            this.clear();
            this.initConfiguration(new OContextConfiguration());
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void dropCluster(int iClusterId) {
        this.lock.acquireWriteLock();
        try {
            if (iClusterId < this.clusters.size()) {
                this.clusters.set(iClusterId, null);
                this.update();
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCluster(OStoragePaginatedClusterConfiguration config) {
        this.lock.acquireWriteLock();
        try {
            if (this.clusters.size() <= config.id) {
                int diff = config.id - this.clusters.size();
                for (int i = 0; i < diff; ++i) {
                    this.clusters.add(null);
                }
                this.clusters.add(config);
            } else {
                if (this.clusters.get(config.id) != null) {
                    throw new OStorageException("Cluster with id " + config.id + " already exists with name '" + this.clusters.get(config.id).getName() + "'");
                }
                this.clusters.set(config.id, config);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexEngine(String name, OStorageConfiguration.IndexEngineData engineData) {
        this.lock.acquireWriteLock();
        try {
            OStorageConfiguration.IndexEngineData oldEngine = this.indexEngines.putIfAbsent(name, engineData);
            if (oldEngine != null) {
                OLogManager.instance().warn((Object)this, "Index engine with name '" + engineData.getName() + "' already contained in database configuration", new Object[0]);
            }
            this.update();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void deleteIndexEngine(String name) {
        this.lock.acquireWriteLock();
        try {
            this.indexEngines.remove(name);
            this.update();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public Set<String> indexEngines() {
        this.lock.acquireReadLock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.indexEngines.keySet());
            return set;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorageConfiguration.IndexEngineData getIndexEngine(String name, int defaultIndexId) {
        this.lock.acquireReadLock();
        try {
            OStorageConfiguration.IndexEngineData indexEngineData = (OStorageConfiguration.IndexEngineData)this.indexEngines.get(name);
            return indexEngineData;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        this.lock.acquireWriteLock();
        try {
            OStorageClusterConfiguration clusterCfg = this.clusters.get(clusterId);
            if (clusterCfg != null) {
                clusterCfg.setStatus(iStatus);
            }
            this.update();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public TimeZone getTimeZone() {
        this.lock.acquireReadLock();
        try {
            TimeZone timeZone = this.timeZone;
            return timeZone;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.lock.acquireWriteLock();
        try {
            this.timeZone = timeZone;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getLocaleLanguage() {
        this.lock.acquireReadLock();
        try {
            String string = this.localeLanguage;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setLocaleLanguage(String iValue) {
        this.lock.acquireWriteLock();
        try {
            this.localeLanguage = iValue;
            this.localeInstance = null;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getLocaleCountry() {
        this.lock.acquireReadLock();
        try {
            String string = this.localeCountry;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setLocaleCountry(String iValue) {
        this.lock.acquireWriteLock();
        try {
            this.localeCountry = iValue;
            this.localeInstance = null;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getCharset() {
        this.lock.acquireReadLock();
        try {
            String string = this.charset;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setCharset(String charset) {
        this.lock.acquireWriteLock();
        try {
            this.charset = charset;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getDateFormat() {
        this.lock.acquireReadLock();
        try {
            String string = this.dateFormat;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getDateTimeFormat() {
        this.lock.acquireReadLock();
        try {
            String string = this.dateTimeFormat;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getClusterSelection() {
        this.lock.acquireReadLock();
        try {
            String string = this.clusterSelection;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setClusterSelection(String clusterSelection) {
        this.lock.acquireWriteLock();
        try {
            this.clusterSelection = clusterSelection;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getMinimumClusters() {
        this.lock.acquireReadLock();
        try {
            int mc = this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
            if (mc == 0) {
                this.autoInitClusters();
                int n = (Integer)this.getContextConfiguration().getValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
                return n;
            }
            int n = mc;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setMinimumClusters(int minimumClusters) {
        this.lock.acquireWriteLock();
        try {
            this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)minimumClusters);
            this.autoInitClusters();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getRecordSerializer() {
        this.lock.acquireReadLock();
        try {
            String string = this.recordSerializer;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setRecordSerializer(String recordSerializer) {
        this.lock.acquireWriteLock();
        try {
            this.recordSerializer = recordSerializer;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getRecordSerializerVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.recordSerializerVersion;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setRecordSerializerVersion(int recordSerializerVersion) {
        this.lock.acquireWriteLock();
        try {
            this.recordSerializerVersion = recordSerializerVersion;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public boolean isStrictSql() {
        return true;
    }

    @Override
    public List<OStorageEntryConfiguration> getProperties() {
        this.lock.acquireReadLock();
        try {
            List<OStorageEntryConfiguration> list = Collections.unmodifiableList(this.properties);
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String iName, String iValue) {
        this.lock.acquireWriteLock();
        try {
            if ("validation".equalsIgnoreCase(iName)) {
                this.validation = "true".equalsIgnoreCase(iValue);
            }
            for (OStorageEntryConfiguration e : this.properties) {
                if (!e.name.equalsIgnoreCase(iName)) continue;
                e.value = iValue;
                return;
            }
            this.properties.add(new OStorageEntryConfiguration(iName, iValue));
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProperty(String iName) {
        this.lock.acquireReadLock();
        try {
            for (OStorageEntryConfiguration e : this.properties) {
                if (!e.name.equalsIgnoreCase(iName)) continue;
                String string = e.value;
                return string;
            }
            Iterator<OStorageEntryConfiguration> iterator = null;
            return iterator;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String iName) {
        this.lock.acquireWriteLock();
        try {
            Iterator<OStorageEntryConfiguration> it = this.properties.iterator();
            while (it.hasNext()) {
                OStorageEntryConfiguration e = it.next();
                if (!e.name.equalsIgnoreCase(iName)) continue;
                it.remove();
                break;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void clearProperties() {
        this.lock.acquireWriteLock();
        try {
            this.properties.clear();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public boolean isValidationEnabled() {
        this.lock.acquireReadLock();
        try {
            boolean bl = this.validation;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setValidation(boolean validation) {
        this.setProperty("validation", validation ? "true" : "false");
    }

    private int phySegmentFromStream(String[] values, int index, OStorageSegmentConfiguration iSegment) {
        iSegment.location = this.version > 2 ? this.read(values[index++]) : null;
        iSegment.maxSize = this.read(values[index++]);
        iSegment.fileType = this.read(values[index++]);
        iSegment.fileStartSize = this.read(values[index++]);
        iSegment.fileMaxSize = this.read(values[index++]);
        iSegment.fileIncrementSize = this.read(values[index++]);
        iSegment.defrag = this.read(values[index++]);
        int size = Integer.parseInt(this.read(values[index++]));
        iSegment.infoFiles = new OStorageFileConfiguration[size];
        for (int i = 0; i < size; ++i) {
            int pos;
            String fileName;
            if (!(fileName = this.read(values[index++])).contains("$") && (pos = fileName.indexOf("/databases")) > -1) {
                fileName = "${ORIENTDB_HOME}" + fileName.substring(pos);
            }
            iSegment.infoFiles[i] = new OStorageFileConfiguration(iSegment, fileName, this.read(values[index++]), this.read(values[index++]), iSegment.fileIncrementSize);
        }
        return index;
    }

    private void phySegmentToStream(StringBuilder iBuffer, OStorageSegmentConfiguration iSegment) {
        this.write(iBuffer, iSegment.location);
        this.write(iBuffer, iSegment.maxSize);
        this.write(iBuffer, iSegment.fileType);
        this.write(iBuffer, iSegment.fileStartSize);
        this.write(iBuffer, iSegment.fileMaxSize);
        this.write(iBuffer, iSegment.fileIncrementSize);
        this.write(iBuffer, iSegment.defrag);
        this.write(iBuffer, iSegment.infoFiles.length);
        for (OStorageFileConfiguration f : iSegment.infoFiles) {
            this.fileToStream(iBuffer, f);
        }
    }

    private void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        this.write(iBuffer, iFile.path);
        this.write(iBuffer, iFile.type);
        this.write(iBuffer, iFile.maxSize);
    }

    private void entryToStream(StringBuilder iBuffer, OStorageEntryConfiguration iEntry) {
        this.write(iBuffer, iEntry.name);
        this.write(iBuffer, iEntry.value);
    }

    private String read(String iValue) {
        if (iValue.equals(" ")) {
            return null;
        }
        return iValue;
    }

    private void write(StringBuilder iBuffer, Object iValue) {
        if (iBuffer.length() > 0) {
            iBuffer.append('|');
        }
        iBuffer.append(iValue != null ? iValue.toString() : Character.valueOf(' '));
    }

    @Override
    public String getSchemaRecordId() {
        this.lock.acquireReadLock();
        try {
            String string = this.schemaRecordId;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setSchemaRecordId(String schemaRecordId) {
        this.lock.acquireWriteLock();
        try {
            this.schemaRecordId = schemaRecordId;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getIndexMgrRecordId() {
        this.lock.acquireReadLock();
        try {
            String string = this.indexMgrRecordId;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.lock.acquireWriteLock();
        try {
            this.indexMgrRecordId = indexMgrRecordId;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setDateFormat(String dateFormat) {
        this.lock.acquireWriteLock();
        try {
            this.dateFormat = dateFormat;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.lock.acquireWriteLock();
        try {
            this.dateTimeFormat = dateTimeFormat;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public int getBinaryFormatVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.binaryFormatVersion;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public String getName() {
        this.lock.acquireReadLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public int getVersion() {
        this.lock.acquireReadLock();
        try {
            int n = this.version;
            return n;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    public List<OStorageClusterConfiguration> getClusters() {
        this.lock.acquireReadLock();
        try {
            List<OStorageClusterConfiguration> list = Collections.unmodifiableList(this.clusters);
            return list;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public void setConfigurationUpdateListener(OStorageConfigurationUpdateListener updateListener) {
        this.lock.acquireWriteLock();
        try {
            this.updateListener = updateListener;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public String getUuid() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUuid(OAtomicOperation atomicOperation, String uuid) {
        throw new UnsupportedOperationException();
    }
}

