/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.exception.OAcquireTimeoutException;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabasePoolImpl
implements ODatabasePoolInternal {
    private volatile OResourcePool<Void, ODatabaseDocumentInternal> pool;
    private final OrientDBInternal factory;
    private final OrientDBConfig config;
    private volatile long lastCloseTime = System.currentTimeMillis();

    public ODatabasePoolImpl(final OrientDBInternal factory, final String database, final String user, final String password, OrientDBConfig config) {
        int max = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX);
        int min = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_POOL_MIN);
        this.factory = factory;
        this.config = config;
        this.pool = new OResourcePool<Void, ODatabaseDocumentInternal>(min, max, new OResourcePoolListener<Void, ODatabaseDocumentInternal>(){

            @Override
            public ODatabaseDocumentInternal createNewResource(Void iKey, Object ... iAdditionalArgs) {
                return factory.poolOpen(database, user, password, ODatabasePoolImpl.this);
            }

            @Override
            public boolean reuseResource(Void iKey, Object[] iAdditionalArgs, ODatabaseDocumentInternal iValue) {
                if (iValue.getStorage().isClosed()) {
                    return false;
                }
                iValue.reuse();
                return true;
            }
        });
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseSession acquire() throws OAcquireTimeoutException {
        OResourcePool<Void, ODatabaseDocumentInternal> p;
        ODatabasePoolImpl oDatabasePoolImpl = this;
        synchronized (oDatabasePoolImpl) {
            p = this.pool;
        }
        if (p != null) {
            return p.getResource(null, this.config.getConfigurations().getValueAsLong(OGlobalConfiguration.DB_POOL_ACQUIRE_TIMEOUT), new Object[0]);
        }
        throw new ODatabaseException("The pool is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        OResourcePool<Void, ODatabaseDocumentInternal> p;
        ODatabasePoolImpl oDatabasePoolImpl = this;
        synchronized (oDatabasePoolImpl) {
            p = this.pool;
            this.pool = null;
        }
        if (p != null) {
            for (ODatabaseDocumentInternal res : p.getAllResources()) {
                res.realClose();
            }
            p.close();
            this.factory.removePool(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ODatabaseDocumentInternal database) {
        OResourcePool<Void, ODatabaseDocumentInternal> p;
        ODatabasePoolImpl oDatabasePoolImpl = this;
        synchronized (oDatabasePoolImpl) {
            p = this.pool;
        }
        if (p == null) {
            throw new ODatabaseException("The pool is closed");
        }
        this.pool.returnResource(database);
        this.lastCloseTime = System.currentTimeMillis();
    }

    @Override
    public boolean isUnused() {
        if (this.pool == null) {
            return true;
        }
        return this.pool.getResourcesOutCount() == 0;
    }

    @Override
    public long getLastCloseTime() {
        return this.lastCloseTime;
    }

    @Override
    public OrientDBConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isClosed() {
        return this.pool == null;
    }
}

