/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.config.ONodeConfiguration;
import com.orientechnologies.orient.core.db.config.ONodeConfigurationBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrientDBConfigBuilder {
    private OContextConfiguration configurations = new OContextConfiguration();
    private Map<ODatabase.ATTRIBUTES, Object> attributes = new HashMap<ODatabase.ATTRIBUTES, Object>();
    private Set<ODatabaseListener> listeners = new HashSet<ODatabaseListener>();
    private ClassLoader classLoader;
    private ONodeConfigurationBuilder nodeConfigurationBuilder = ONodeConfiguration.builder();

    public OrientDBConfigBuilder fromGlobalMap(Map<OGlobalConfiguration, Object> values) {
        for (Map.Entry<OGlobalConfiguration, Object> entry : values.entrySet()) {
            this.addConfig(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public OrientDBConfigBuilder fromMap(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.configurations.setValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public void addListener(ODatabaseListener listener) {
        this.listeners.add(listener);
    }

    public OrientDBConfigBuilder addConfig(OGlobalConfiguration configuration, Object value) {
        this.configurations.setValue(configuration, value);
        return this;
    }

    public OrientDBConfigBuilder addAttribute(ODatabase.ATTRIBUTES attribute, Object value) {
        this.attributes.put(attribute, value);
        return this;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ONodeConfigurationBuilder getNodeConfigurationBuilder() {
        return this.nodeConfigurationBuilder;
    }

    public OrientDBConfig build() {
        return new OrientDBConfig(this.configurations, this.attributes, this.listeners, this.classLoader, this.nodeConfigurationBuilder.build());
    }

    public OrientDBConfigBuilder fromContext(OContextConfiguration contextConfiguration) {
        this.configurations = contextConfiguration;
        return this;
    }
}

