/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.OCachedDatabasePoolFactoryImpl;
import com.orientechnologies.orient.core.db.ODatabaseDocumentEmbeddedPooled;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabasePoolImpl;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseTask;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.OMemoryAndLocalPaginatedEnginesInitializer;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.disk.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class OrientDBEmbedded
implements OrientDBInternal {
    private static final AtomicInteger nextStorageId = new AtomicInteger();
    private static final Set<Integer> currentStorageIds = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final Map<String, OAbstractPaginatedStorage> storages = new HashMap<String, OAbstractPaginatedStorage>();
    protected final Map<String, OSharedContext> sharedContexts = new HashMap<String, OSharedContext>();
    protected final Set<ODatabasePoolInternal> pools = new HashSet<ODatabasePoolInternal>();
    protected final OrientDBConfig configurations;
    protected final String basePath;
    protected final OEngine memory;
    protected final OEngine disk;
    protected final Orient orient;
    protected final OCachedDatabasePoolFactory cachedPoolFactory;
    private volatile boolean open = true;
    private ExecutorService executor;
    private Timer timer;
    private TimerTask autoCloseTimer = null;
    private final OScriptManager scriptManager = new OScriptManager();
    protected final long maxWALSegmentSize;
    protected final long doubleWriteLogMaxSegSize;

    public OrientDBEmbedded(String directoryPath, OrientDBConfig configurations, Orient orient) {
        this.orient = orient;
        orient.onEmbeddedFactoryInit(this);
        this.memory = orient.getEngine("memory");
        this.disk = orient.getEngine("plocal");
        directoryPath = directoryPath.trim();
        if (directoryPath.length() != 0) {
            File dirFile = new File(directoryPath);
            if (!dirFile.exists()) {
                OLogManager.instance().infoNoDb(this, "Directory " + dirFile + " does not exist, try to create it.", new Object[0]);
                if (!dirFile.mkdirs()) {
                    OLogManager.instance().errorNoDb(this, "Can not create directory " + dirFile, null, new Object[0]);
                }
            }
            this.basePath = dirFile.getAbsolutePath();
        } else {
            this.basePath = null;
        }
        OrientDBConfig orientDBConfig = this.configurations = configurations != null ? configurations : OrientDBConfig.defaultConfig();
        if (this.basePath == null) {
            this.maxWALSegmentSize = -1L;
            this.doubleWriteLogMaxSegSize = -1L;
        } else {
            try {
                this.doubleWriteLogMaxSegSize = this.calculateDoubleWriteLogMaxSegSize(Paths.get(this.basePath, new String[0]));
                this.maxWALSegmentSize = this.calculateInitialMaxWALSegSize(configurations);
                if (this.maxWALSegmentSize <= 0L) {
                    throw new ODatabaseException("Invalid configuration settings. Can not set maximum size of WAL segment");
                }
                OLogManager.instance().infoNoDb(this, "WAL maximum segment size is set to %,d MB", this.maxWALSegmentSize / 1024L / 1024L);
            }
            catch (IOException e) {
                throw OException.wrapException(new ODatabaseException("Cannot initialize OrientDB engine"), e);
            }
        }
        OMemoryAndLocalPaginatedEnginesInitializer.INSTANCE.initialize();
        orient.addOrientDB(this);
        this.executor = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 30L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        this.timer = new Timer();
        this.cachedPoolFactory = this.createCachedDatabasePoolFactory(this.configurations);
        boolean autoClose = this.configurations.getConfigurations().getValueAsBoolean(OGlobalConfiguration.AUTO_CLOSE_AFTER_DELAY);
        if (autoClose) {
            int autoCloseDelay = this.configurations.getConfigurations().getValueAsInteger(OGlobalConfiguration.AUTO_CLOSE_DELAY);
            long delay = autoCloseDelay * 60 * 1000;
            this.initAutoClose(delay);
        }
    }

    protected OCachedDatabasePoolFactory createCachedDatabasePoolFactory(OrientDBConfig config) {
        int capacity = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CAPACITY);
        long timeout = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_CACHED_POOL_CLEAN_UP_TIMEOUT);
        return new OCachedDatabasePoolFactoryImpl(this, capacity, timeout);
    }

    public void initAutoClose(long delay) {
        long scheduleTime = delay / 3L;
        this.autoCloseTimer = this.orient.scheduleTask(() -> this.orient.submit(() -> this.checkAndCloseStorages(delay)), scheduleTime, scheduleTime);
    }

    private synchronized void checkAndCloseStorages(long delay) {
        HashSet<String> toClose = new HashSet<String>();
        for (OAbstractPaginatedStorage oAbstractPaginatedStorage : this.storages.values()) {
            long currentTime;
            if (!oAbstractPaginatedStorage.getType().equalsIgnoreCase(ODatabaseType.PLOCAL.name()) || oAbstractPaginatedStorage.getSessionCount() != 0 || (currentTime = System.currentTimeMillis()) <= oAbstractPaginatedStorage.getLastCloseTime() + delay) continue;
            toClose.add(oAbstractPaginatedStorage.getName());
        }
        for (String string : toClose) {
            this.forceDatabaseClose(string);
        }
    }

    private long calculateInitialMaxWALSegSize(OrientDBConfig configurations) throws IOException {
        OContextConfiguration config;
        OContextConfiguration config2;
        long filesSize;
        OContextConfiguration config3;
        String walPath = configurations != null ? ((config3 = configurations.getConfigurations()) != null ? config3.getValueAsString(OGlobalConfiguration.WAL_LOCATION) : OGlobalConfiguration.WAL_LOCATION.getValueAsString()) : OGlobalConfiguration.WAL_LOCATION.getValueAsString();
        if (walPath == null) {
            walPath = this.basePath;
        }
        FileStore fileStore = Files.getFileStore(Paths.get(walPath, new String[0]));
        long freeSpace = fileStore.getUsableSpace();
        try {
            filesSize = Files.walk(Paths.get(walPath, new String[0]), new FileVisitOption[0]).mapToLong(p -> {
                try {
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        return Files.size(p);
                    }
                    return 0L;
                }
                catch (IOException | UncheckedIOException e) {
                    OLogManager.instance().error(this, "Error during calculation of free space for database", e, new Object[0]);
                    return 0L;
                }
            }).sum();
        }
        catch (IOException | UncheckedIOException e) {
            OLogManager.instance().error(this, "Error during calculation of free space for database", e, new Object[0]);
            filesSize = 0L;
        }
        long maxSegSize = configurations != null ? ((config2 = configurations.getConfigurations()) != null ? config2.getValueAsLong(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE) * 1024L * 1024L : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsLong() * 1024L * 1024L) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsLong() * 1024L * 1024L;
        if (maxSegSize <= 0L) {
            OContextConfiguration config4;
            int sizePercent = configurations != null ? ((config4 = configurations.getConfigurations()) != null ? config4.getValueAsInteger(OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT.getValueAsInteger()) : OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE_PERCENT.getValueAsInteger();
            if (sizePercent <= 0) {
                throw new ODatabaseException("Invalid configuration settings. Can not set maximum size of WAL segment");
            }
            maxSegSize = (freeSpace + filesSize) / 100L * (long)sizePercent;
        }
        long minSegSizeLimit = (long)((double)freeSpace * 0.25);
        long minSegSize = 0L;
        if (configurations != null && (config = configurations.getConfigurations()) != null) {
            minSegSize = config.getValueAsLong(OGlobalConfiguration.WAL_MIN_SEG_SIZE) * 1024L * 1024L;
        }
        if (minSegSize <= 0L) {
            minSegSize = OGlobalConfiguration.WAL_MIN_SEG_SIZE.getValueAsLong() * 1024L * 1024L;
        }
        if (minSegSize > minSegSizeLimit) {
            minSegSize = minSegSizeLimit;
        }
        if (minSegSize > 0L && maxSegSize < minSegSize) {
            maxSegSize = minSegSize;
        }
        return maxSegSize;
    }

    private long calculateDoubleWriteLogMaxSegSize(Path storagePath) throws IOException {
        OContextConfiguration config;
        OContextConfiguration config2;
        long filesSize;
        FileStore fileStore = Files.getFileStore(storagePath);
        long freeSpace = fileStore.getUsableSpace();
        try {
            filesSize = Files.walk(storagePath, new FileVisitOption[0]).mapToLong(p -> {
                try {
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        return Files.size(p);
                    }
                    return 0L;
                }
                catch (IOException | UncheckedIOException e) {
                    OLogManager.instance().error(this, "Error during calculation of free space for database", e, new Object[0]);
                    return 0L;
                }
            }).sum();
        }
        catch (IOException | UncheckedIOException e) {
            OLogManager.instance().error(this, "Error during calculation of free space for database", e, new Object[0]);
            filesSize = 0L;
        }
        long maxSegSize = this.configurations != null ? ((config2 = this.configurations.getConfigurations()) != null ? config2.getValueAsLong(OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE) * 1024L * 1024L : OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE.getValueAsLong() * 1024L * 1024L) : OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE.getValueAsLong() * 1024L * 1024L;
        if (maxSegSize <= 0L) {
            OContextConfiguration config3;
            int sizePercent = this.configurations != null ? ((config3 = this.configurations.getConfigurations()) != null ? config3.getValueAsInteger(OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE_PERCENT) : OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE_PERCENT.getValueAsInteger()) : OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MAX_SEG_SIZE_PERCENT.getValueAsInteger();
            if (sizePercent <= 0) {
                throw new ODatabaseException("Invalid configuration settings. Can not set maximum size of WAL segment");
            }
            maxSegSize = (freeSpace + filesSize) / 100L * (long)sizePercent;
        }
        long minSegSize = 0L;
        if (this.configurations != null && (config = this.configurations.getConfigurations()) != null) {
            minSegSize = config.getValueAsLong(OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MIN_SEG_SIZE) * 1024L * 1024L;
        }
        if (minSegSize <= 0L) {
            minSegSize = OGlobalConfiguration.STORAGE_DOUBLE_WRITE_LOG_MIN_SEG_SIZE.getValueAsLong() * 1024L * 1024L;
        }
        if (minSegSize > 0L && maxSegSize < minSegSize) {
            maxSegSize = minSegSize;
        }
        return maxSegSize;
    }

    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password) {
        return this.open(name, user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthenticate(String name, String user) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                storage.incOnOpen();
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, "nopwd", false);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    protected ODatabaseDocumentEmbedded newSessionInstance(OAbstractPaginatedStorage storage) {
        return new ODatabaseDocumentEmbedded(storage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentEmbedded openNoAuthorization(String name) {
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBConfig config = this.solveConfig(null);
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                storage.open(config.getConfigurations());
                storage.incOnOpen();
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
            }
            embedded.rebuildIndexes();
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal open(String name, String user, String password, OrientDBConfig config) {
        this.checkDefaultPassword(name, user, password);
        try {
            ODatabaseDocumentEmbedded embedded;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                this.checkOpen();
                config = this.solveConfig(config);
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                try {
                    storage.open(config.getConfigurations());
                }
                catch (RuntimeException e) {
                    if (storage != null) {
                        this.storages.remove(storage.getName());
                    } else {
                        this.storages.remove(name);
                    }
                    throw e;
                }
                embedded = this.newSessionInstance(storage);
                embedded.init(config, this.getOrCreateSharedContext(storage));
                storage.incOnOpen();
            }
            embedded.rebuildIndexes();
            embedded.internalOpen(user, password);
            embedded.callOnOpenListeners();
            return embedded;
        }
        catch (Exception e) {
            throw OException.wrapException(new ODatabaseException("Cannot open database '" + name + "'"), e);
        }
    }

    private void checkDefaultPassword(String database, String user, String password) {
        if (("admin".equals(user) && "admin".equals(password) || "reader".equals(user) && "reader".equals(password) || "writer".equals(user) && "writer".equals(password)) && OGlobalConfiguration.WARNING_DEFAULT_USERS.getValueAsBoolean()) {
            OLogManager.instance().warnNoDb(this, String.format("IMPORTANT! Using default password is unsafe, please change password for user '%s' on database '%s'", user, database), new Object[0]);
        }
    }

    protected OrientDBConfig solveConfig(OrientDBConfig config) {
        if (config != null) {
            config.setParent(this.configurations);
            return config;
        }
        OrientDBConfig cfg = OrientDBConfig.defaultConfig();
        cfg.setParent(this.configurations);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseDocumentInternal poolOpen(String name, String user, String password, ODatabasePoolInternal pool) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
            OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
            storage.open(pool.getConfig().getConfigurations());
            embedded = this.newPooledSessionInstance(pool, storage);
            embedded.init(pool.getConfig(), this.getOrCreateSharedContext(storage));
            storage.incOnOpen();
        }
        embedded.rebuildIndexes();
        embedded.internalOpen(user, password);
        embedded.callOnOpenListeners();
        return embedded;
    }

    protected ODatabaseDocumentEmbedded newPooledSessionInstance(ODatabasePoolInternal pool, OAbstractPaginatedStorage storage) {
        return new ODatabaseDocumentEmbeddedPooled(pool, storage);
    }

    protected OAbstractPaginatedStorage getOrInitStorage(String name) {
        OAbstractPaginatedStorage storage = this.storages.get(name);
        if (storage == null) {
            Path storagePath = Paths.get(this.buildName(name), new String[0]);
            if (OLocalPaginatedStorage.exists(storagePath)) {
                name = storagePath.getFileName().toString();
            }
            if ((storage = this.storages.get(name)) == null && (storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId())).exists()) {
                this.storages.put(name, storage);
            }
        }
        return storage;
    }

    protected final int generateStorageId() {
        int storageId = Math.abs(nextStorageId.getAndIncrement());
        while (!currentStorageIds.add(storageId)) {
            storageId = Math.abs(nextStorageId.getAndIncrement());
        }
        return storageId;
    }

    public synchronized OAbstractPaginatedStorage getStorage(String name) {
        return this.storages.get(name);
    }

    protected String buildName(String name) {
        if (this.basePath == null) {
            throw new ODatabaseException("OrientDB instanced created without physical path, only memory databases are allowed");
        }
        return this.basePath + "/" + name;
    }

    @Override
    public void create(String name, String user, String password, ODatabaseType type) {
        this.create(name, user, password, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String name, String user, String password, ODatabaseType type, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, user, password)) {
                try {
                    config = this.solveConfig(config);
                    OAbstractPaginatedStorage storage = type == ODatabaseType.MEMORY ? (OAbstractPaginatedStorage)this.memory.createStorage(name, new HashMap<String, String>(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId()) : (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId());
                    this.storages.put(name, storage);
                    embedded = this.internalCreate(config, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new database '" + name + "' because it already exists");
            }
        }
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void networkRestore(String name, InputStream in, Callable<Object> callable) {
        try {
            OAbstractPaginatedStorage storage;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                OSharedContext context = this.sharedContexts.get(name);
                if (context != null) {
                    context.close();
                }
                storage = this.getOrInitStorage(name);
                this.storages.put(name, storage);
            }
            storage.restore(in, null, callable, null);
        }
        catch (OModificationOperationProhibitedException e) {
            throw e;
        }
        catch (Exception e) {
            OContextConfiguration configs = this.getConfigurations().getConfigurations();
            OLocalPaginatedStorage.deleteFilesFromDisc(name, configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_RETRY), configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_DELAY), this.buildName(name));
            throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, String user, String password, ODatabaseType type, String path, OrientDBConfig config) {
        ODatabaseDocumentEmbedded embedded;
        OAbstractPaginatedStorage storage;
        config = this.solveConfig(config);
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            if (!this.exists(name, null, null)) {
                try {
                    storage = (OAbstractPaginatedStorage)this.disk.createStorage(this.buildName(name), new HashMap<String, String>(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId());
                    embedded = this.internalCreate(config, storage);
                    this.storages.put(name, storage);
                }
                catch (Exception e) {
                    throw OException.wrapException(new ODatabaseException("Cannot restore database '" + name + "'"), e);
                }
            } else {
                throw new ODatabaseException("Cannot create new storage '" + name + "' because it already exists");
            }
        }
        storage.restoreFromIncrementalBackup(path);
        embedded.callOnCreateListeners();
        ODatabaseRecordThreadLocal.instance().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(String name, InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        try {
            OAbstractPaginatedStorage storage;
            OrientDBEmbedded orientDBEmbedded = this;
            synchronized (orientDBEmbedded) {
                OSharedContext context = this.sharedContexts.remove(name);
                if (context != null) {
                    context.close();
                }
                storage = this.getOrInitStorage(name);
                this.storages.put(name, storage);
            }
            storage.restore(in, options, callable, iListener);
        }
        catch (Exception e) {
            OContextConfiguration configs = this.getConfigurations().getConfigurations();
            OLocalPaginatedStorage.deleteFilesFromDisc(name, configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_RETRY), configs.getValueAsInteger(OGlobalConfiguration.FILE_DELETE_DELAY), this.buildName(name));
            throw OException.wrapException(new ODatabaseException("Cannot create database '" + name + "'"), e);
        }
    }

    protected ODatabaseDocumentEmbedded internalCreate(OrientDBConfig config, OAbstractPaginatedStorage storage) {
        storage.create(config.getConfigurations());
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getDefaultRecordSerializer();
        if (serializer.toString().equals("ORecordDocument2csv")) {
            throw new ODatabaseException("Impossible to create the database with ORecordDocument2csv serializer");
        }
        storage.setRecordSerializer(serializer.toString(), serializer.getCurrentVersion());
        storage.setProperty("strictSql", "true");
        ODatabaseDocumentEmbedded embedded = this.newSessionInstance(storage);
        embedded.setSerializer(serializer);
        embedded.internalCreate(config, this.getOrCreateSharedContext(storage));
        return embedded;
    }

    protected synchronized OSharedContext getOrCreateSharedContext(OAbstractPaginatedStorage storage) {
        OSharedContext result = this.sharedContexts.get(storage.getName());
        if (result == null) {
            result = this.createSharedContext(storage);
            this.sharedContexts.put(storage.getName(), result);
        }
        return result;
    }

    protected OSharedContext createSharedContext(OAbstractPaginatedStorage storage) {
        return new OSharedContextEmbedded(storage, this);
    }

    @Override
    public synchronized boolean exists(String name, String user, String password) {
        this.checkOpen();
        OStorage storage = this.storages.get(name);
        if (storage == null) {
            if (this.basePath != null) {
                return OLocalPaginatedStorage.exists(Paths.get(this.buildName(name), new String[0]));
            }
            return false;
        }
        return storage.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(String name, String user, String password) {
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.checkOpen();
        }
        ODatabaseDocumentInternal current = ODatabaseRecordThreadLocal.instance().getIfDefined();
        try {
            ODatabaseDocumentEmbedded db = this.openNoAuthenticate(name, user);
            Iterator<ODatabaseLifecycleListener> it = this.orient.getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onDrop(db);
            }
            db.close();
        }
        finally {
            ODatabaseRecordThreadLocal.instance().set(current);
        }
        OrientDBEmbedded orientDBEmbedded2 = this;
        synchronized (orientDBEmbedded2) {
            if (this.exists(name, user, password)) {
                OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                OSharedContext sharedContext = this.sharedContexts.get(name);
                if (sharedContext != null) {
                    sharedContext.close();
                }
                int storageId = storage.getId();
                storage.delete();
                this.storages.remove(name);
                currentStorageIds.remove(storageId);
                this.sharedContexts.remove(name);
            }
        }
    }

    @Override
    public synchronized Set<String> listDatabases(String user, String password) {
        this.checkOpen();
        HashSet<String> databases = new HashSet<String>();
        if (this.basePath != null) {
            OrientDBEmbedded.scanDatabaseDirectory(new File(this.basePath), databases::add);
        }
        databases.addAll(this.storages.keySet());
        return databases;
    }

    @Override
    public synchronized void loadAllDatabases() {
        if (this.basePath != null) {
            OrientDBEmbedded.scanDatabaseDirectory(new File(this.basePath), name -> {
                if (!this.storages.containsKey(name)) {
                    OAbstractPaginatedStorage storage = this.getOrInitStorage(name);
                    storage.open(this.getConfigurations().getConfigurations());
                }
            });
        }
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password) {
        return this.openPool(name, user, password, null);
    }

    @Override
    public ODatabasePoolInternal openPool(String name, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolImpl pool = new ODatabasePoolImpl(this, name, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    @Override
    public ODatabasePoolInternal cachedPool(String database, String user, String password) {
        return this.cachedPool(database, user, password, null);
    }

    @Override
    public ODatabasePoolInternal cachedPool(String database, String user, String password, OrientDBConfig config) {
        this.checkOpen();
        ODatabasePoolInternal pool = this.cachedPoolFactory.get(database, user, password, this.solveConfig(config));
        this.pools.add(pool);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.timer.cancel();
        this.executor.shutdown();
        try {
            while (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
                OLogManager.instance().warn((Object)this, "Failed waiting background operations termination", new Object[0]);
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            this.scriptManager.closeAll();
            this.removeShutdownHook();
            this.internalClose();
            currentStorageIds.clear();
        }
    }

    @Override
    public synchronized void internalClose() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.sharedContexts.values().forEach(x -> x.close());
        ArrayList<OAbstractPaginatedStorage> storagesCopy = new ArrayList<OAbstractPaginatedStorage>(this.storages.values());
        Exception storageException = null;
        for (OAbstractPaginatedStorage stg : storagesCopy) {
            try {
                OLogManager.instance().info((Object)this, "- shutdown storage: " + stg.getName() + "...", new Object[0]);
                stg.shutdown();
            }
            catch (Exception e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
                storageException = e;
            }
            catch (Error e) {
                OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
                throw e;
            }
        }
        this.sharedContexts.clear();
        this.storages.clear();
        this.orient.onEmbeddedFactoryClose(this);
        if (this.autoCloseTimer != null) {
            this.autoCloseTimer.cancel();
        }
        if (storageException != null) {
            throw OException.wrapException(new OStorageException("Error during closing the storages"), storageException);
        }
    }

    public OrientDBConfig getConfigurations() {
        return this.configurations;
    }

    @Override
    public void removePool(ODatabasePoolInternal pool) {
        this.pools.remove(pool);
    }

    private static void scanDatabaseDirectory(File directory, DatabaseFound found) {
        try {
            File[] files;
            if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null) {
                for (File db : files) {
                    if (!db.isDirectory()) continue;
                    Path dbPath = Paths.get(db.getAbsolutePath(), new String[0]);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dbPath);){
                        stream.forEach(p -> {
                            String fileName;
                            if (!Files.isDirectory(p, new LinkOption[0]) && ((fileName = p.getFileName().toString()).equals("database.ocf") || fileName.startsWith("config") && fileName.endsWith(".cd"))) {
                                int count = p.getNameCount();
                                found.found(OIOUtils.getDatabaseNameFromPath(p.subpath(count - 2, count - 1).toString()));
                            }
                        });
                    }
                }
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Exception during scanning of database directory"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initCustomStorage(String name, String path, String userName, String userPassword) {
        ODatabaseDocumentEmbedded embedded = null;
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            boolean exists = OLocalPaginatedStorage.exists(Paths.get(path, new String[0]));
            OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)this.disk.createStorage(path, new HashMap<String, String>(), this.maxWALSegmentSize, this.doubleWriteLogMaxSegSize, this.generateStorageId());
            if (!exists) {
                embedded = this.internalCreate(this.getConfigurations(), storage);
            }
            this.storages.put(name, storage);
        }
        if (embedded != null) {
            embedded.callOnCreateListeners();
            ODatabaseRecordThreadLocal.instance().remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackOperationsFromThread(Thread thread) {
        OrientDBEmbedded orientDBEmbedded = this;
        synchronized (orientDBEmbedded) {
            Thread currentThread = Thread.currentThread();
            for (OAbstractPaginatedStorage storage : this.storages.values()) {
                storage.rollbackOperationsFromThread(thread);
            }
        }
    }

    @Override
    public synchronized void removeShutdownHook() {
        this.orient.removeOrientDB(this);
    }

    @Override
    public synchronized Collection<OStorage> getStorages() {
        return this.storages.values().stream().map(x -> x).collect(Collectors.toSet());
    }

    @Override
    public synchronized void forceDatabaseClose(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.remove(iDatabaseName);
        if (storage != null) {
            OSharedContext ctx = this.sharedContexts.remove(iDatabaseName);
            if (ctx != null) {
                ctx.close();
            }
            storage.shutdown();
        }
    }

    public String getDatabasePath(String iDatabaseName) {
        OAbstractPaginatedStorage storage = this.storages.get(iDatabaseName);
        if (storage != null && storage instanceof OLocalPaginatedStorage) {
            return ((OLocalPaginatedStorage)storage).getStoragePath().toString();
        }
        return null;
    }

    protected void checkOpen() {
        if (!this.open) {
            throw new ODatabaseException("OrientDB Instance is closed");
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        this.timer.schedule(task, delay, period);
    }

    @Override
    public void scheduleOnce(TimerTask task, long delay) {
        this.timer.schedule(task, delay);
    }

    @Override
    public <X> Future<X> execute(String database, String user, ODatabaseTask<X> task) {
        return this.executor.submit(() -> {
            try (ODatabaseDocumentEmbedded session = this.openNoAuthenticate(database, user);){
                Object x = task.call(session);
                return x;
            }
        });
    }

    @Override
    public <X> Future<X> executeNoAuthorization(String database, ODatabaseTask<X> task) {
        return this.executor.submit(() -> {
            try (ODatabaseDocumentEmbedded session = this.openNoAuthorization(database);){
                Object x = task.call(session);
                return x;
            }
        });
    }

    public <X> Future<X> executeNoDb(Callable<X> callable) {
        return this.executor.submit(callable);
    }

    @Override
    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public static interface InstanceFactory<T> {
        public T create(OAbstractPaginatedStorage var1);
    }

    protected static interface DatabaseFound {
        public void found(String var1);
    }
}

