/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OSimpleMultiValueTracker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class OTrackedList<T>
extends ArrayList<T>
implements ORecordElement,
OTrackedMultiValue<Integer, T>,
Serializable {
    protected final ORecordElement sourceRecord;
    protected Class<?> genericClass;
    private final boolean embeddedCollection;
    private boolean dirty = false;
    private boolean transactionDirty = false;
    private OSimpleMultiValueTracker<Integer, T> tracker = new OSimpleMultiValueTracker(this);

    public OTrackedList(ORecordElement iRecord, Collection<? extends T> iOrigin, Class<?> iGenericClass) {
        this(iRecord);
        this.genericClass = iGenericClass;
        if (iOrigin != null && !iOrigin.isEmpty()) {
            this.addAll(iOrigin);
        }
    }

    public OTrackedList(ORecordElement iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        this.embeddedCollection = this.getClass().equals(OTrackedList.class);
    }

    @Override
    public ORecordElement getOwner() {
        return this.sourceRecord;
    }

    @Override
    public boolean add(T element) {
        boolean result = super.add(element);
        if (result) {
            this.addEvent(super.size() - 1, element);
        }
        return result;
    }

    @Override
    public boolean addInternal(T element) {
        boolean result = super.add(element);
        if (result) {
            this.addOwnerToEmbeddedDoc(element);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean convert = false;
        if (c instanceof OAutoConvertToRecord) {
            convert = ((OAutoConvertToRecord)((Object)c)).isAutoConvertToRecord();
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(false);
        }
        for (T o : c) {
            this.add(o);
        }
        if (c instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)((Object)c)).setAutoConvertToRecord(convert);
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.addEvent(index, element);
    }

    public T setInternal(int index, T element) {
        T oldValue = super.set(index, element);
        if (oldValue != null && !oldValue.equals(element)) {
            if (oldValue instanceof ODocument) {
                ODocumentInternal.removeOwner((ODocument)oldValue, this);
            }
            this.addOwnerToEmbeddedDoc(element);
        }
        return oldValue;
    }

    @Override
    public T set(int index, T element) {
        T oldValue = super.set(index, element);
        if (oldValue != null && !oldValue.equals(element)) {
            this.updateEvent(index, oldValue, element);
        }
        return oldValue;
    }

    private void addOwnerToEmbeddedDoc(T e) {
        if (this.embeddedCollection && e instanceof ODocument && !((ODocument)e).getIdentity().isValid()) {
            ODocumentInternal.addOwner((ODocument)e, this);
        }
        if (e instanceof ODocument) {
            ORecordInternal.track(this.sourceRecord, (ODocument)e);
        }
    }

    @Override
    public T remove(int index) {
        Object oldValue = super.remove(index);
        this.removeEvent(index, oldValue);
        return (T)oldValue;
    }

    private void addEvent(int index, T added) {
        this.addOwnerToEmbeddedDoc(added);
        if (this.tracker.isEnabled()) {
            this.tracker.add(index, added);
        } else {
            this.setDirty();
        }
    }

    private void updateEvent(int index, T oldValue, T newValue) {
        if (oldValue instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)oldValue, this);
        }
        this.addOwnerToEmbeddedDoc(newValue);
        if (this.tracker.isEnabled()) {
            this.tracker.updated(index, newValue, oldValue);
        } else {
            this.setDirty();
        }
    }

    private void removeEvent(int index, T removed) {
        if (removed instanceof ODocument) {
            ODocumentInternal.removeOwner((ODocument)removed, this);
        }
        if (this.tracker.isEnabled()) {
            this.tracker.remove(index, removed);
        } else {
            this.setDirty();
        }
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public void clear() {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object origValue = this.get(i);
            this.removeEvent(i, origValue);
        }
        super.clear();
    }

    public void reset() {
        super.clear();
    }

    @Override
    public <RET> RET setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
        this.dirty = true;
        this.transactionDirty = true;
        return (RET)this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirtyNoChanged();
        }
    }

    public List<T> returnOriginalState(List<OMultiValueChangeEvent<Integer, T>> multiValueChangeEvents) {
        ArrayList<T> reverted = new ArrayList<T>(this);
        ListIterator<OMultiValueChangeEvent<Integer, T>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<Integer, T> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getKey(), event.getOldValue());
                    continue block5;
                }
                case UPDATE: {
                    reverted.set(event.getKey(), event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public Class<?> getGenericClass() {
        return this.genericClass;
    }

    private Object writeReplace() {
        return new ArrayList(this);
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
        super.set((Integer)event.getKey(), newValue);
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        if (!this.tracker.isEnabled()) {
            this.tracker.enable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedEnabled(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedEnabled(this.iterator(), this);
            }
        }
    }

    @Override
    public void disableTracking(ORecordElement parent) {
        if (this.tracker.isEnabled()) {
            this.tracker.disable();
            if (this instanceof ORecordLazyMultiValue) {
                OTrackedMultiValue.nestedDisable(((ORecordLazyMultiValue)((Object)this)).rawIterator(), this);
            } else {
                OTrackedMultiValue.nestedDisable(this.iterator(), this);
            }
        }
        this.dirty = false;
    }

    @Override
    public void transactionClear() {
        this.tracker.transactionClear();
        if (this instanceof ORecordLazyMultiValue) {
            OTrackedMultiValue.nestedTransactionClear(((ORecordLazyMultiValue)((Object)this)).rawIterator());
        } else {
            OTrackedMultiValue.nestedTransactionClear(this.iterator());
        }
        this.transactionDirty = false;
    }

    @Override
    public boolean isModified() {
        return this.dirty;
    }

    @Override
    public boolean isTransactionModified() {
        return this.transactionDirty;
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.tracker.getTimeLine();
    }

    @Override
    public OMultiValueChangeTimeLine<Integer, T> getTransactionTimeLine() {
        return this.tracker.getTransactionTimeLine();
    }
}

