/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag;

import com.orientechnologies.common.collection.OCollection;
import com.orientechnologies.common.serialization.types.OUUIDSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.db.record.ridbag.embedded.OEmbeddedRidBag;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringBuilderSerializable;
import com.orientechnologies.orient.core.storage.ridbag.ORemoteTreeRidBag;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeRidBag;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.UUID;

public class ORidBag
implements OStringBuilderSerializable,
Iterable<OIdentifiable>,
ORecordLazyMultiValue,
OTrackedMultiValue<OIdentifiable, OIdentifiable>,
OCollection<OIdentifiable>,
ORecordElement {
    private ORidBagDelegate delegate;
    private ORecordId ownerRecord;
    private String fieldName;
    private int topThreshold = OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getValueAsInteger();
    private int bottomThreshold = OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger();
    private UUID uuid;

    public ORidBag(ORidBag ridBag) {
        this.init();
        Iterator<OIdentifiable> it = ridBag.rawIterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public ORidBag() {
        this.init();
    }

    public ORidBag(int iTopThreshold, int iBottomThreshold) {
        this.topThreshold = iTopThreshold;
        this.bottomThreshold = iBottomThreshold;
        this.init();
    }

    public ORidBag(UUID uuid) {
        this.init();
        this.uuid = uuid;
    }

    public ORidBag(OBonsaiCollectionPointer pointer, Map<OIdentifiable, Change> changes, UUID uuid) {
        this.delegate = new OSBTreeRidBag(pointer, changes);
        this.uuid = uuid;
    }

    private ORidBag(byte[] stream) {
        this.fromStream(stream);
    }

    public ORidBag(ORidBagDelegate delegate) {
        this.delegate = delegate;
    }

    public static ORidBag fromStream(String value) {
        byte[] stream = Base64.getDecoder().decode(value);
        return new ORidBag(stream);
    }

    public ORidBag copy() {
        ORidBag copy = new ORidBag();
        copy.topThreshold = this.topThreshold;
        copy.bottomThreshold = this.bottomThreshold;
        copy.uuid = this.uuid;
        copy.delegate = this.delegate instanceof OSBTreeRidBag ? this.delegate : ((OEmbeddedRidBag)this.delegate).copy();
        return copy;
    }

    public boolean contains(OIdentifiable identifiable) {
        return this.delegate.contains(identifiable);
    }

    public void addAll(Collection<OIdentifiable> values) {
        this.delegate.addAll(values);
    }

    @Override
    public void add(OIdentifiable identifiable) {
        this.delegate.add(identifiable);
    }

    @Override
    public boolean addInternal(OIdentifiable e) {
        return this.delegate.addInternal(e);
    }

    @Override
    public void remove(OIdentifiable identifiable) {
        this.delegate.remove(identifiable);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return this.delegate.rawIterator();
    }

    @Override
    public void convertLinks2Records() {
        this.delegate.convertLinks2Records();
    }

    @Override
    public boolean convertRecords2Links() {
        return this.delegate.convertRecords2Links();
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.delegate.isAutoConvertToRecord();
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.delegate.setAutoConvertToRecord(convertToRecord);
    }

    @Override
    public boolean detach() {
        return this.delegate.detach();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public boolean isEmbedded() {
        return this.delegate instanceof OEmbeddedRidBag;
    }

    public boolean isToSerializeEmbedded() {
        if (this.isEmbedded()) {
            return true;
        }
        if (this.getOwner() instanceof ORecord && !((ORecord)this.getOwner()).getIdentity().isPersistent()) {
            return true;
        }
        return OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger() >= this.size();
    }

    public int toStream(BytesContainer bytesContainer) throws OSerializationException {
        int pointer;
        this.checkAndConvert();
        UUID oldUuid = this.uuid;
        OSBTreeCollectionManager sbTreeCollectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        this.uuid = sbTreeCollectionManager != null ? sbTreeCollectionManager.listenForChanges(this) : null;
        boolean hasUuid = this.uuid != null;
        int serializedSize = 1 + this.delegate.getSerializedSize() + (hasUuid ? 16 : 0);
        int offset = pointer = bytesContainer.alloc(serializedSize);
        byte[] stream = bytesContainer.bytes;
        byte configByte = 0;
        if (this.isEmbedded()) {
            configByte = (byte)(configByte | 1);
        }
        if (hasUuid) {
            configByte = (byte)(configByte | 2);
        }
        stream[offset++] = configByte;
        if (hasUuid) {
            OUUIDSerializer.INSTANCE.serialize(this.uuid, stream, offset, new Object[0]);
            offset += 16;
        }
        this.delegate.serialize(stream, offset, oldUuid);
        return pointer;
    }

    public void checkAndConvert() {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (database != null && !database.getStorage().isRemote()) {
            if (this.isEmbedded() && ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager() != null && this.delegate.size() >= this.topThreshold) {
                this.convertToTree();
            } else if (this.bottomThreshold >= 0 && !this.isEmbedded() && this.delegate.size() <= this.bottomThreshold) {
                this.convertToEmbedded();
            }
        }
    }

    private void convertToEmbedded() {
        ORidBagDelegate oldDelegate = this.delegate;
        boolean isTransactionModified = oldDelegate.isTransactionModified();
        boolean oldAutoConvert = oldDelegate.isAutoConvertToRecord();
        oldDelegate.setAutoConvertToRecord(false);
        this.delegate = new OEmbeddedRidBag();
        ORecordElement owner = oldDelegate.getOwner();
        this.delegate.disableTracking(owner);
        for (OIdentifiable identifiable : oldDelegate) {
            this.delegate.add(identifiable);
        }
        this.delegate.setOwner(owner);
        this.delegate.setTracker(oldDelegate.getTracker());
        oldDelegate.disableTracking(owner);
        this.delegate.setDirty();
        this.delegate.setTransactionModified(isTransactionModified);
        this.delegate.enableTracking(owner);
        oldDelegate.setAutoConvertToRecord(oldAutoConvert);
        oldDelegate.requestDelete();
    }

    private void convertToTree() {
        ORidBagDelegate oldDelegate = this.delegate;
        boolean isTransactionModified = oldDelegate.isTransactionModified();
        this.delegate = new OSBTreeRidBag();
        boolean oldAutoConvert = oldDelegate.isAutoConvertToRecord();
        oldDelegate.setAutoConvertToRecord(false);
        ORecordElement owner = oldDelegate.getOwner();
        this.delegate.disableTracking(owner);
        for (OIdentifiable identifiable : oldDelegate) {
            this.delegate.add(identifiable);
        }
        this.delegate.setOwner(owner);
        this.delegate.setTracker(oldDelegate.getTracker());
        oldDelegate.disableTracking(owner);
        this.delegate.setDirty();
        this.delegate.setTransactionModified(isTransactionModified);
        this.delegate.enableTracking(owner);
        oldDelegate.setAutoConvertToRecord(oldAutoConvert);
        oldDelegate.requestDelete();
    }

    @Override
    public OStringBuilderSerializable toStream(StringBuilder output) throws OSerializationException {
        BytesContainer container = new BytesContainer();
        this.toStream(container);
        output.append(Base64.getEncoder().encodeToString(container.fitBytes()));
        return this;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void delete() {
        this.delegate.requestDelete();
    }

    @Override
    public OStringBuilderSerializable fromStream(StringBuilder input) throws OSerializationException {
        byte[] stream = Base64.getDecoder().decode(input.toString());
        this.fromStream(stream);
        return this;
    }

    public void fromStream(byte[] stream) {
        this.fromStream(new BytesContainer(stream));
    }

    public void fromStream(BytesContainer stream) {
        byte first;
        this.delegate = ((first = stream.bytes[stream.offset++]) & 1) == 1 ? new OEmbeddedRidBag() : new OSBTreeRidBag();
        if ((first & 2) == 2) {
            this.uuid = OUUIDSerializer.INSTANCE.deserialize(stream.bytes, stream.offset);
            stream.skip(16);
        }
        stream.skip(this.delegate.deserialize(stream.bytes, stream.offset) - stream.offset);
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        return this.delegate.returnOriginalState(multiValueChangeEvents);
    }

    @Override
    public Class<?> getGenericClass() {
        return this.delegate.getGenericClass();
    }

    public void setOwner(ORecordElement owner) {
        if (!(owner instanceof ODocument) && owner != null || owner != null && ((ODocument)owner).isEmbedded()) {
            throw new ODatabaseException("RidBag are supported only at document root");
        }
        this.delegate.setOwner(owner);
    }

    public UUID getTemporaryId() {
        return this.uuid;
    }

    public void setTemporaryId(UUID uuid) {
        this.uuid = uuid;
    }

    public void notifySaved(OBonsaiCollectionPointer newPointer) {
        if (newPointer.isValid()) {
            if (this.isEmbedded()) {
                this.replaceWithSBTree(newPointer);
            } else if (this.getDelegate() instanceof OSBTreeRidBag) {
                ((OSBTreeRidBag)this.delegate).setCollectionPointer(newPointer);
                ((OSBTreeRidBag)this.delegate).clearChanges();
            }
        }
    }

    public OBonsaiCollectionPointer getPointer() {
        if (this.isEmbedded()) {
            return OBonsaiCollectionPointer.INVALID;
        }
        if (this.delegate instanceof ORemoteTreeRidBag) {
            return ((ORemoteTreeRidBag)this.delegate).getCollectionPointer();
        }
        return ((OSBTreeRidBag)this.delegate).getCollectionPointer();
    }

    public boolean tryMerge(ORidBag otherValue, boolean iMergeSingleItemsOfMultiValueFields) {
        if (!this.isEmbedded() && !otherValue.isEmbedded()) {
            OSBTreeRidBag thisTree = (OSBTreeRidBag)this.delegate;
            OSBTreeRidBag otherTree = (OSBTreeRidBag)otherValue.delegate;
            if (thisTree.getCollectionPointer().equals(otherTree.getCollectionPointer())) {
                thisTree.mergeChanges(otherTree);
                this.uuid = otherValue.uuid;
                return true;
            }
        } else if (iMergeSingleItemsOfMultiValueFields) {
            Iterator<OIdentifiable> iter2 = otherValue.rawIterator();
            while (iter2.hasNext()) {
                OIdentifiable value = iter2.next();
                if (value == null) continue;
                Iterator<OIdentifiable> localIter = this.rawIterator();
                boolean found = false;
                while (localIter.hasNext()) {
                    OIdentifiable v = localIter.next();
                    if (!value.equals(v)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.add(value);
            }
            return true;
        }
        return false;
    }

    protected void init() {
        this.delegate = this.topThreshold < 0 ? (ODatabaseRecordThreadLocal.instance().isDefined() && !ODatabaseRecordThreadLocal.instance().get().isRemote() ? new OSBTreeRidBag() : new OEmbeddedRidBag()) : new OEmbeddedRidBag();
    }

    private void replaceWithSBTree(OBonsaiCollectionPointer pointer) {
        this.delegate.requestDelete();
        ORemoteTreeRidBag treeBag = new ORemoteTreeRidBag(pointer);
        treeBag.setRecordAndField(this.ownerRecord, this.fieldName);
        treeBag.setOwner(this.delegate.getOwner());
        treeBag.setTracker(this.delegate.getTracker());
        this.delegate = treeBag;
    }

    public void debugPrint(PrintStream writer) throws IOException {
        if (this.delegate instanceof OSBTreeRidBag) {
            writer.append("tree [\n");
            ((OSBTreeRidBag)this.delegate).debugPrint(writer);
            writer.append("]\n");
        } else {
            writer.append(this.delegate.toString());
            writer.append("\n");
        }
    }

    public ORidBagDelegate getDelegate() {
        return this.delegate;
    }

    public NavigableMap<OIdentifiable, Change> getChanges() {
        return this.delegate.getChanges();
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
    }

    public boolean equals(Object other) {
        if (!(other instanceof ORidBag)) {
            return false;
        }
        ORidBag otherRidbag = (ORidBag)other;
        if (!this.delegate.getClass().equals(otherRidbag.delegate.getClass())) {
            return false;
        }
        Iterator<OIdentifiable> firstIter = this.delegate.rawIterator();
        Iterator<OIdentifiable> secondIter = otherRidbag.delegate.rawIterator();
        while (firstIter.hasNext()) {
            OIdentifiable secondElement;
            if (!secondIter.hasNext()) {
                return false;
            }
            OIdentifiable firstElement = firstIter.next();
            if (Objects.equals(firstElement, secondElement = secondIter.next())) continue;
            return false;
        }
        return !secondIter.hasNext();
    }

    @Override
    public void enableTracking(ORecordElement parent) {
        this.delegate.enableTracking(parent);
    }

    @Override
    public void disableTracking(ORecordElement document) {
        this.delegate.disableTracking(document);
    }

    @Override
    public void transactionClear() {
        this.delegate.transactionClear();
    }

    @Override
    public boolean isModified() {
        return this.delegate.isModified();
    }

    @Override
    public OMultiValueChangeTimeLine<Object, Object> getTimeLine() {
        return this.delegate.getTimeLine();
    }

    @Override
    public <RET> RET setDirty() {
        return this.delegate.setDirty();
    }

    @Override
    public void setDirtyNoChanged() {
        this.delegate.setDirtyNoChanged();
    }

    @Override
    public ORecordElement getOwner() {
        return this.delegate.getOwner();
    }

    @Override
    public boolean isTransactionModified() {
        return this.delegate.isTransactionModified();
    }

    @Override
    public OMultiValueChangeTimeLine<OIdentifiable, OIdentifiable> getTransactionTimeLine() {
        return this.delegate.getTransactionTimeLine();
    }

    public void setRecordAndField(ORecordId id, String fieldName) {
        if (this.getDelegate() instanceof ORemoteTreeRidBag) {
            ((ORemoteTreeRidBag)this.getDelegate()).setRecordAndField(id, fieldName);
        }
        this.ownerRecord = id;
        this.fieldName = fieldName;
    }

    public void makeTree() {
        if (this.isEmbedded()) {
            this.convertToTree();
        }
    }

    public void makeEmbedded() {
        if (!this.isEmbedded()) {
            this.convertToEmbedded();
        }
    }
}

