/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool.importer;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.importer.OConverterData;
import com.orientechnologies.orient.core.db.tool.importer.OImportConvertersFactory;
import com.orientechnologies.orient.core.db.tool.importer.OValuesConverter;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.OResultSet;

public final class OLinkConverter
implements OValuesConverter<OIdentifiable> {
    private OConverterData converterData;

    public OLinkConverter(OConverterData importer) {
        this.converterData = importer;
    }

    @Override
    public OIdentifiable convert(OIdentifiable value) {
        ORID rid = value.getIdentity();
        if (!rid.isPersistent()) {
            return value;
        }
        if (this.converterData.brokenRids.contains(rid)) {
            return OImportConvertersFactory.BROKEN_LINK;
        }
        try (OResultSet resultSet = this.converterData.session.query("select value from ___exportImportRIDMap where key = ?", rid.toString());){
            if (resultSet.hasNext()) {
                ORecordId oRecordId = new ORecordId((String)resultSet.next().getProperty("value"));
                return oRecordId;
            }
            OIdentifiable oIdentifiable = value;
            return oIdentifiable;
        }
    }
}

