/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.viewmanager;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.db.viewmanager.ViewCreationListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ViewManager {
    private final OrientDBInternal orientDB;
    private final String dbName;
    private final ConcurrentMap<Integer, AtomicInteger> viewCluserVisitors = new ConcurrentHashMap<Integer, AtomicInteger>();
    private final ConcurrentMap<Integer, String> oldClustersPerViews = new ConcurrentHashMap<Integer, String>();
    private final List<Integer> clustersToDrop = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<String, AtomicInteger> viewIndexVisitors = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentMap<String, String> oldIndexesPerViews = new ConcurrentHashMap<String, String>();
    private final List<String> indexesToDrop = Collections.synchronizedList(new ArrayList());
    private final Map<String, Long> lastUpdateTimestampForView = new HashMap<String, Long>();
    private final Map<String, Long> lastChangePerClass = new ConcurrentHashMap<String, Long>();
    private volatile String lastUpdatedView = null;
    private volatile TimerTask timerTask;
    private volatile Future<?> lastTask;
    private volatile boolean closed = false;

    public ViewManager(OrientDBInternal orientDb, String dbName) {
        this.orientDB = orientDb;
        this.dbName = dbName;
    }

    protected void init() {
        this.orientDB.executeNoAuthorization(this.dbName, db -> {
            this.registerLiveUpdates(db);
            return null;
        });
    }

    private synchronized void registerLiveUpdates(ODatabaseSession db) {
        boolean liveViewsExist = false;
        Collection<OView> views = db.getMetadata().getSchema().getViews();
        for (OView view : views) {
            liveViewsExist = this.registerLiveUpdateFor(db, view.getName()) || liveViewsExist;
        }
    }

    public synchronized boolean registerLiveUpdateFor(ODatabaseSession db, String viewName) {
        OView view = db.getMetadata().getSchema().getView(viewName);
        boolean registered = false;
        if (view.getUpdateStrategy() != null && view.getUpdateStrategy().equalsIgnoreCase(OViewConfig.UPDATE_STRATEGY_LIVE)) {
            db.live(view.getQuery(), (OLiveQueryResultListener)new ViewUpdateListener(view.getName()), new Object[0]);
            registered = true;
        }
        return registered;
    }

    public void load() {
        this.closed = false;
        this.init();
        this.start();
    }

    public void start() {
        this.schedule();
    }

    private void schedule() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (ViewManager.this.closed) {
                    return;
                }
                ViewManager.this.lastTask = ViewManager.this.orientDB.executeNoAuthorization(ViewManager.this.dbName, db -> {
                    ViewManager.this.updateViews((ODatabaseDocumentInternal)db);
                    return null;
                });
            }
        };
        this.orientDB.scheduleOnce(this.timerTask, 1000L);
    }

    private void updateViews(ODatabaseDocumentInternal db) {
        try {
            this.cleanUnusedViewClusters(db);
            this.cleanUnusedViewIndexes(db);
            OView view = this.getNextViewToUpdate(db);
            if (view != null) {
                this.updateView(view, db);
            }
            this.schedule();
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Failed to update views", new Object[0]);
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.lastTask != null) {
            try {
                try {
                    this.lastTask.get(20L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    this.lastTask.cancel(true);
                    this.lastTask.get();
                }
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("Terminated while waiting update view to finis"), e);
            }
            catch (ExecutionException e) {
                OLogManager.instance().warn((Object)this, "Issue terminating view update background operations", e, new Object[0]);
            }
        }
        this.closed = true;
    }

    public synchronized void cleanUnusedViewClusters(ODatabaseDocument db) {
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (Integer cluster : this.clustersToDrop) {
            AtomicInteger visitors = (AtomicInteger)this.viewCluserVisitors.get(cluster);
            if (visitors != null && visitors.get() > 0) continue;
            toRemove.add(cluster);
        }
        for (Integer cluster : toRemove) {
            this.viewCluserVisitors.remove(cluster);
            this.clustersToDrop.remove(cluster);
            this.oldClustersPerViews.remove(cluster);
            db.dropCluster(cluster);
        }
    }

    public synchronized void cleanUnusedViewIndexes(ODatabaseDocumentInternal db) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String index : this.indexesToDrop) {
            AtomicInteger visitors = (AtomicInteger)this.viewIndexVisitors.get(index);
            if (visitors != null && visitors.get() > 0) continue;
            toRemove.add(index);
        }
        for (String index : toRemove) {
            this.viewIndexVisitors.remove(index);
            this.indexesToDrop.remove(index);
            this.oldIndexesPerViews.remove(index);
            db.getMetadata().getIndexManagerInternal().dropIndex(db, index);
        }
    }

    public synchronized OView getNextViewToUpdate(ODatabase db) {
        OSchema schema = db.getMetadata().getSchema();
        List names = schema.getViews().stream().map(x -> x.getName()).sorted().collect(Collectors.toList());
        if (names.isEmpty()) {
            return null;
        }
        for (String name : names) {
            if (!this.buildOnThisNode(db, name) || this.isLiveUpdate(db, name) || !this.isUpdateExpiredFor(name, db) || !this.needsUpdateBasedOnWatchRules(name, db) || this.lastUpdatedView != null && name.compareTo(this.lastUpdatedView) <= 0) continue;
            this.lastUpdatedView = name;
            return schema.getView(name);
        }
        this.lastUpdatedView = null;
        return null;
    }

    private boolean isLiveUpdate(ODatabase db, String viewName) {
        OView view = db.getMetadata().getSchema().getView(viewName);
        return OViewConfig.UPDATE_STRATEGY_LIVE.equalsIgnoreCase(view.getUpdateStrategy());
    }

    protected boolean buildOnThisNode(ODatabase db, String name) {
        return true;
    }

    private boolean needsUpdateBasedOnWatchRules(String name, ODatabase db) {
        OView view = db.getMetadata().getSchema().getView(name);
        if (view == null) {
            return false;
        }
        Long lastViewUpdate = this.lastUpdateTimestampForView.get(name);
        if (lastViewUpdate == null) {
            return true;
        }
        List<String> watchRules = view.getWatchClasses();
        if (watchRules == null || watchRules.size() == 0) {
            return true;
        }
        for (String watchRule : watchRules) {
            Long classChangeTimestamp = this.lastChangePerClass.get(watchRule.toLowerCase(Locale.ENGLISH));
            if (classChangeTimestamp == null || classChangeTimestamp < lastViewUpdate) continue;
            return true;
        }
        return false;
    }

    private boolean isUpdateExpiredFor(String viewName, ODatabase db) {
        Long lastUpdate = this.lastUpdateTimestampForView.get(viewName);
        if (lastUpdate == null) {
            return true;
        }
        OView view = db.getMetadata().getSchema().getView(viewName);
        int updateInterval = view.getUpdateIntervalSeconds();
        return lastUpdate + (long)(updateInterval * 1000) < System.currentTimeMillis();
    }

    public synchronized void updateView(OView view, final ODatabaseDocumentInternal db) {
        this.lastUpdateTimestampForView.put(view.getName(), System.currentTimeMillis());
        int cluster = db.addCluster(this.getNextClusterNameFor(view, db), new Object[0]);
        final String viewName = view.getName();
        final String query = view.getQuery();
        final String originRidField = view.getOriginRidField();
        final String clusterName = db.getClusterNameById(cluster);
        final List<OIndex> indexes = this.createNewIndexesForView(view, cluster, db);
        OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

            @Override
            public Object call() {
                OResultSet rs = db.query(query, new Object[0]);
                while (rs.hasNext()) {
                    OResult item = rs.next();
                    ViewManager.this.addItemToView(item, db, originRidField, viewName, clusterName, indexes);
                }
                return null;
            }
        });
        view = db.getMetadata().getSchema().getView(view.getName());
        if (view == null) {
            db.dropCluster(clusterName);
            indexes.forEach(x -> x.delete());
            return;
        }
        this.lockView(view);
        view.addClusterId(cluster);
        for (int i : view.getClusterIds()) {
            if (i == cluster) continue;
            this.clustersToDrop.add(i);
            this.viewCluserVisitors.put(i, new AtomicInteger(0));
            this.oldClustersPerViews.put(i, view.getName());
            view.removeClusterId(i);
        }
        OViewImpl viewImpl = (OViewImpl)view;
        viewImpl.getInactiveIndexes().forEach(idx -> {
            this.indexesToDrop.add((String)idx);
            this.viewIndexVisitors.put((String)idx, new AtomicInteger(0));
            this.oldIndexesPerViews.put((String)idx, viewName);
        });
        viewImpl.inactivateIndexes();
        viewImpl.addActiveIndexes(indexes.stream().map(x -> x.getName()).collect(Collectors.toList()));
        this.unlockView(view);
        this.cleanUnusedViewIndexes(db);
        this.cleanUnusedViewClusters(db);
    }

    private void addItemToView(OResult item, ODatabaseDocument db, String originRidField, String viewName, String clusterName, List<OIndex> indexes) {
        OElement newRow = this.copyElement(item, db);
        if (originRidField != null) {
            newRow.setProperty(originRidField, item.getIdentity().orElse((ORID)item.getProperty("@rid")));
            newRow.setProperty("@view", viewName);
        }
        db.save(newRow, clusterName);
        indexes.forEach(idx -> idx.put(this.indexedKeyFor((OIndex)idx, newRow), newRow));
    }

    private Object indexedKeyFor(OIndex idx, OElement newRow) {
        List<String> fieldsToIndex = idx.getDefinition().getFieldsToIndex();
        if (fieldsToIndex.size() == 1) {
            return idx.getDefinition().createValue(newRow.getProperty(fieldsToIndex.get(0)));
        }
        Object[] vals = new Object[fieldsToIndex.size()];
        for (int i = 0; i < fieldsToIndex.size(); ++i) {
            vals[i] = newRow.getProperty(fieldsToIndex.get(i));
        }
        return idx.getDefinition().createValue(vals);
    }

    private List<OIndex> createNewIndexesForView(OView view, int cluster, ODatabaseDocumentInternal db) {
        try {
            ArrayList<OIndex> result = new ArrayList<OIndex>();
            OIndexManagerAbstract idxMgr = db.getMetadata().getIndexManagerInternal();
            for (OViewConfig.OViewIndexConfig cfg : view.getRequiredIndexesInfo()) {
                OIndexDefinition definition = this.createIndexDefinition(view.getName(), cfg.getProperties());
                String indexName = view.getName() + "_" + UUID.randomUUID().toString().replaceAll("-", "_");
                String type = cfg.getType();
                String engine = cfg.getEngine();
                OIndex idx = idxMgr.createIndex(db, indexName, type, definition, new int[]{cluster}, null, null, engine);
                result.add(idx);
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private OIndexDefinition createIndexDefinition(String viewName, List<OPair<String, OType>> requiredIndexesInfo) {
        if (requiredIndexesInfo.size() == 1) {
            return new OPropertyIndexDefinition(viewName, (String)requiredIndexesInfo.get(0).getKey(), requiredIndexesInfo.get(0).getValue());
        }
        OCompositeIndexDefinition result = new OCompositeIndexDefinition(viewName);
        for (OPair<String, OType> pair : requiredIndexesInfo) {
            result.addIndex(new OPropertyIndexDefinition(viewName, (String)pair.getKey(), pair.getValue()));
        }
        return result;
    }

    private synchronized void unlockView(OView view) {
    }

    private void lockView(OView view) {
    }

    private String getNextClusterNameFor(OView view, ODatabase db) {
        String clusterName;
        int i = 0;
        String viewName = view.getName();
        do {
            clusterName = viewName.toLowerCase(Locale.ENGLISH) + i++;
        } while (db.getClusterNames().contains(clusterName));
        return clusterName;
    }

    private OElement copyElement(OResult item, ODatabaseDocument db) {
        OElement newRow = db.newElement();
        for (String prop : item.getPropertyNames()) {
            if (prop.equalsIgnoreCase("@rid") || prop.equalsIgnoreCase("@class")) continue;
            newRow.setProperty(prop, item.getProperty(prop));
        }
        return newRow;
    }

    public void updateViewAsync(String name, ViewCreationListener listener) {
        this.orientDB.executeNoAuthorization(this.dbName, databaseSession -> {
            block4: {
                if (!this.buildOnThisNode(databaseSession, name)) {
                    return null;
                }
                try {
                    OView view = databaseSession.getMetadata().getSchema().getView(name);
                    this.updateView(view, (ODatabaseDocumentInternal)databaseSession);
                    if (listener != null) {
                        listener.afterCreate(databaseSession, name);
                    }
                }
                catch (Exception e) {
                    if (listener == null) break block4;
                    listener.onError(name, e);
                }
            }
            return null;
        });
    }

    public synchronized void startUsingViewCluster(Integer cluster) {
        AtomicInteger item = (AtomicInteger)this.viewCluserVisitors.get(cluster);
        if (item == null) {
            item = new AtomicInteger(0);
            this.viewCluserVisitors.put(cluster, item);
        }
        item.incrementAndGet();
    }

    public synchronized void endUsingViewCluster(Integer cluster) {
        AtomicInteger item = (AtomicInteger)this.viewCluserVisitors.get(cluster);
        if (item == null) {
            return;
        }
        item.decrementAndGet();
    }

    public void recordAdded(OImmutableClass clazz, ODocument doc, ODatabaseDocumentEmbedded oDatabaseDocumentEmbedded) {
        this.lastChangePerClass.put(clazz.getName().toLowerCase(Locale.ENGLISH), System.currentTimeMillis());
    }

    public void recordUpdated(OImmutableClass clazz, ODocument doc, ODatabaseDocumentEmbedded oDatabaseDocumentEmbedded) {
        this.lastChangePerClass.put(clazz.getName().toLowerCase(Locale.ENGLISH), System.currentTimeMillis());
    }

    public void recordDeleted(OImmutableClass clazz, ODocument doc, ODatabaseDocumentEmbedded oDatabaseDocumentEmbedded) {
        this.lastChangePerClass.put(clazz.getName().toLowerCase(Locale.ENGLISH), System.currentTimeMillis());
    }

    public String getViewFromOldCluster(int clusterId) {
        return (String)this.oldClustersPerViews.get(clusterId);
    }

    public void endUsingViewIndex(String indexName) {
        AtomicInteger item = (AtomicInteger)this.viewIndexVisitors.get(indexName);
        if (item == null) {
            return;
        }
        item.decrementAndGet();
    }

    public void startUsingViewIndex(String indexName) {
        AtomicInteger item = (AtomicInteger)this.viewIndexVisitors.get(indexName);
        if (item == null) {
            item = new AtomicInteger(0);
            this.viewIndexVisitors.put(indexName, item);
        }
        item.incrementAndGet();
    }

    private class ViewUpdateListener
    implements OLiveQueryResultListener {
        private final String viewName;

        public ViewUpdateListener(String name) {
            this.viewName = name;
        }

        @Override
        public void onCreate(ODatabaseDocument db, OResult data) {
            OView view = db.getMetadata().getSchema().getView(this.viewName);
            if (view != null) {
                int cluster = view.getClusterIds()[0];
                ViewManager.this.addItemToView(data, db, view.getOriginRidField(), view.getName(), db.getClusterNameById(cluster), new ArrayList<OIndex>(view.getIndexes()));
            }
        }

        @Override
        public void onUpdate(ODatabaseDocument db, OResult before, OResult after) {
            OView view = db.getMetadata().getSchema().getView(this.viewName);
            if (view != null && view.getOriginRidField() != null) {
                try (OResultSet rs = db.query("SELECT FROM " + this.viewName + " WHERE " + view.getOriginRidField() + " = ?", after.getProperty("@rid"));){
                    while (rs.hasNext()) {
                        OResult row = rs.next();
                        row.getElement().ifPresent(elem -> this.updateViewRow((OElement)elem, after, view, (ODatabaseDocumentInternal)db));
                    }
                }
            }
        }

        private void updateViewRow(OElement viewRow, OResult origin, OView view, ODatabaseDocumentInternal db) {
            OStatement stm = OStatementCache.get(view.getQuery(), db);
            if (stm instanceof OSelectStatement) {
                OProjection projection = ((OSelectStatement)stm).getProjection();
                if (projection == null || projection.getItems().size() == 0 && projection.getItems().get(0).isAll()) {
                    for (String s : origin.getPropertyNames()) {
                        if ("@rid".equalsIgnoreCase(s) || "@class".equalsIgnoreCase(s) || "@version".equalsIgnoreCase(s)) continue;
                        Object value = origin.getProperty(s);
                        viewRow.setProperty(s, value);
                    }
                } else {
                    for (OProjectionItem oProjectionItem : projection.getItems()) {
                        Object value = oProjectionItem.execute(origin, (OCommandContext)new OBasicCommandContext());
                        viewRow.setProperty(oProjectionItem.getProjectionAliasAsString(), value);
                    }
                }
                viewRow.save();
            }
        }

        @Override
        public void onDelete(ODatabaseDocument db, OResult data) {
            OView view = db.getMetadata().getSchema().getView(this.viewName);
            if (view != null && view.getOriginRidField() != null) {
                try (OResultSet rs = db.query("SELECT FROM " + this.viewName + " WHERE " + view.getOriginRidField() + " = ?", data.getProperty("@rid"));){
                    while (rs.hasNext()) {
                        rs.next().getElement().ifPresent(x -> x.delete());
                    }
                }
            }
        }

        @Override
        public void onError(ODatabaseDocument database, OException exception) {
            OLogManager.instance().error(ViewManager.this, "Error updating view " + this.viewName, exception, new Object[0]);
        }

        @Override
        public void onEnd(ODatabaseDocument database) {
        }
    }
}

