/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine.v1;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OSingleValueIndexEngine;
import com.orientechnologies.orient.core.index.engine.v1.OCellBTreeIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.OCellBTreeSingleValue;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1.CellBTreeSingleValueV1;
import com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3.CellBTreeSingleValueV3;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;

public final class OCellBTreeSingleValueIndexEngine
implements OSingleValueIndexEngine,
OCellBTreeIndexEngine {
    private static final String DATA_FILE_EXTENSION = ".cbt";
    private static final String NULL_BUCKET_FILE_EXTENSION = ".nbt";
    private final OCellBTreeSingleValue<Object> sbTree;
    private final String name;
    private final int id;

    public OCellBTreeSingleValueIndexEngine(int id, String name, OAbstractPaginatedStorage storage, int version) {
        this.name = name;
        this.id = id;
        if (version < 3) {
            this.sbTree = new CellBTreeSingleValueV1<Object>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else if (version == 3 || version == 4) {
            this.sbTree = new CellBTreeSingleValueV3<Object>(name, DATA_FILE_EXTENSION, NULL_BUCKET_FILE_EXTENSION, storage);
        } else {
            throw new IllegalStateException("Invalid tree version " + version);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    @Override
    public void flush() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Map<String, String> engineProperties, OEncryption encryption) {
        try {
            this.sbTree.create(atomicOperation, keySerializer, keyTypes, keySize, encryption);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error of creation of index " + this.name), e);
        }
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        try {
            this.doClearTree(atomicOperation);
            this.sbTree.delete(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during deletion of index " + this.name), e);
        }
    }

    private void doClearTree(OAtomicOperation atomicOperation) throws IOException {
        try (Stream<Object> stream = this.sbTree.keyStream();){
            stream.forEach(key -> {
                try {
                    this.sbTree.remove(atomicOperation, key);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIndexException("Can not clear index"), e);
                }
            });
        }
        this.sbTree.remove(atomicOperation, null);
    }

    @Override
    public void load(String indexName, int keySize, OType[] keyTypes, OBinarySerializer keySerializer, OEncryption encryption) {
        this.sbTree.load(indexName, keySize, keyTypes, keySerializer, encryption);
    }

    @Override
    public boolean remove(OAtomicOperation atomicOperation, Object key) {
        try {
            return this.sbTree.remove(atomicOperation, key) != null;
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during removal of key " + key + " from index " + this.name), e);
        }
    }

    @Override
    public void clear(OAtomicOperation atomicOperation) {
        try {
            this.doClearTree(atomicOperation);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during clear of index " + this.name), e);
        }
    }

    @Override
    public void close() {
        this.sbTree.close();
    }

    @Override
    public Stream<ORID> get(Object key) {
        ORID rid = this.sbTree.get(key);
        if (rid == null) {
            return Stream.empty();
        }
        return Stream.of(rid);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> stream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object firstKey = this.sbTree.firstKey();
        if (firstKey == null) {
            return Stream.empty();
        }
        return this.sbTree.iterateEntriesMajor(firstKey, true, true);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> descStream(OBaseIndexEngine.ValuesTransformer valuesTransformer) {
        Object lastKey = this.sbTree.lastKey();
        if (lastKey == null) {
            return Stream.empty();
        }
        return this.sbTree.iterateEntriesMinor(lastKey, true, false);
    }

    @Override
    public Stream<Object> keyStream() {
        return this.sbTree.keyStream();
    }

    @Override
    public void put(OAtomicOperation atomicOperation, Object key, ORID value) {
        try {
            this.sbTree.put(atomicOperation, key, value);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " into index " + this.name), e);
        }
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, Object key, ORID value, OBaseIndexEngine.Validator<Object, ORID> validator) {
        try {
            return this.sbTree.validatedPut(atomicOperation, key, value, validator);
        }
        catch (IOException e) {
            throw OException.wrapException(new OIndexException("Error during insertion of key " + key + " into index " + this.name), e);
        }
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.sbTree.iterateEntriesBetween(rangeFrom, fromInclusive, rangeTo, toInclusive, ascSortOrder);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.sbTree.iterateEntriesMajor(fromKey, isInclusive, ascSortOrder);
    }

    @Override
    public Stream<ORawPair<Object, ORID>> iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OBaseIndexEngine.ValuesTransformer transformer) {
        return this.sbTree.iterateEntriesMinor(toKey, isInclusive, ascSortOrder);
    }

    @Override
    public long size(OBaseIndexEngine.ValuesTransformer transformer) {
        return this.sbTree.size();
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return true;
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.sbTree.acquireAtomicExclusiveLock();
        return true;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.name;
    }
}

