/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OView;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import java.util.ArrayList;
import java.util.List;

public class OImmutableView
extends OImmutableClass
implements OView {
    private final int updateIntervalSeconds;
    private final List<String> watchClasses;
    private final List<String> nodes;
    private final List<OViewConfig.OViewIndexConfig> requiredIndexesInfo;
    private String query;
    private String originRidField;
    private boolean updatable;
    private String updateStrategy;

    public OImmutableView(OView view, OImmutableSchema schema) {
        super(view, schema);
        this.query = view.getQuery();
        this.updateIntervalSeconds = view.getUpdateIntervalSeconds();
        this.watchClasses = view.getWatchClasses() == null ? null : new ArrayList<String>(view.getWatchClasses());
        this.originRidField = view.getOriginRidField();
        this.updatable = view.isUpdatable();
        this.nodes = view.getNodes() == null ? null : new ArrayList<String>(view.getNodes());
        this.requiredIndexesInfo = view.getRequiredIndexesInfo() == null ? null : new ArrayList<OViewConfig.OViewIndexConfig>(view.getRequiredIndexesInfo());
        this.updateStrategy = view.getUpdateStrategy();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public int getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    @Override
    public List<String> getWatchClasses() {
        return this.watchClasses;
    }

    @Override
    public String getOriginRidField() {
        return this.originRidField;
    }

    @Override
    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public List<String> getNodes() {
        return this.nodes;
    }

    @Override
    public List<OViewConfig.OViewIndexConfig> getRequiredIndexesInfo() {
        return this.requiredIndexesInfo;
    }

    @Override
    public String getUpdateStrategy() {
        return this.updateStrategy;
    }
}

