/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.OViewConfig;
import com.orientechnologies.orient.core.metadata.schema.OViewImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OViewEmbedded
extends OViewImpl {
    protected OViewEmbedded(OSchemaShared iOwner, String iName, OViewConfig cfg, int[] iClusterIds) {
        super(iOwner, iName, cfg, iClusterIds);
    }

    protected OViewEmbedded(OSchemaShared iOwner, ODocument iDocument, String iName) {
        super(iOwner, iDocument, iName);
    }

    @Override
    public OProperty addProperty(String propertyName, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClassImpl setEncryption(String iValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setClusterSelection(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClassImpl setCustom(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCustom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setSuperClasses(List<? extends OClass> classes) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected OClass removeBaseClassInternal(OClass baseClass) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.subclasses == null) {
                OViewEmbedded oViewEmbedded = this;
                return oViewEmbedded;
            }
            if (this.subclasses.remove(baseClass)) {
                this.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
            OViewEmbedded oViewEmbedded = this;
            return oViewEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass addSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass removeSuperClass(OClass superClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setSuperClassesInternal(List<? extends OClass> classes) {
        ArrayList<OClassImpl> newSuperClasses = new ArrayList<OClassImpl>();
        for (OClass oClass : classes) {
            OClassImpl cls = oClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)oClass).delegate : (OClassImpl)oClass;
            if (newSuperClasses.contains(cls)) {
                throw new OSchemaException("Duplicated superclass '" + cls.getName() + "'");
            }
            newSuperClasses.add(cls);
        }
        ArrayList toAddList = new ArrayList(newSuperClasses);
        toAddList.removeAll(this.superClasses);
        ArrayList arrayList = new ArrayList(this.superClasses);
        arrayList.removeAll(newSuperClasses);
        for (OClassImpl toRemove : arrayList) {
            toRemove.removeBaseClassInternal(this);
        }
        for (OClassImpl addTo : toAddList) {
            addTo.addBaseClass(this);
        }
        this.superClasses.clear();
        this.superClasses.addAll(newSuperClasses);
    }

    @Override
    public OClass setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultClusterId = defaultClusterId;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OClass addClusterIdInternal(ODatabaseDocumentInternal database, int clusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.checkClusterCanBeAdded(clusterId, this);
            for (int currId : this.clusterIds) {
                if (currId != clusterId) continue;
                OViewEmbedded oViewEmbedded = this;
                return oViewEmbedded;
            }
            this.clusterIds = OArrays.copyOf(this.clusterIds, this.clusterIds.length + 1);
            this.clusterIds[this.clusterIds.length - 1] = clusterId;
            Arrays.sort(this.clusterIds);
            this.addPolymorphicClusterId(clusterId);
            if (this.defaultClusterId == -1) {
                this.defaultClusterId = clusterId;
            }
            ((OSchemaEmbedded)this.owner).addClusterForView(database, clusterId, this);
            OViewEmbedded oViewEmbedded = this;
            return oViewEmbedded;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OClass setShortName(String shortName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected OPropertyImpl createPropertyInstance(ODocument p) {
        return new OPropertyEmbedded((OClassImpl)this, p);
    }

    @Override
    public OClass truncateCluster(String clusterName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setStrictMode(boolean isStrict) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setDescription(String iDescription) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass addClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            this.addClusterIdInternal(database, clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public OClass removeClusterId(int clusterId) {
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.clusterIds.length == 1 && clusterId == this.clusterIds[0]) {
            throw new ODatabaseException(" Impossible to remove the last cluster of class '" + this.getName() + "' drop the class instead");
        }
        this.acquireSchemaWriteLock();
        try {
            this.removeClusterIdInternal(database, clusterId);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass removeClusterIdInternal(ODatabaseDocumentInternal database, int clusterToRemove) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            boolean found = false;
            for (int clusterId : this.clusterIds) {
                if (clusterId != clusterToRemove) continue;
                found = true;
                break;
            }
            if (found) {
                int[] newClusterIds = new int[this.clusterIds.length - 1];
                int k = 0;
                for (int i = 0; i < this.clusterIds.length; ++i) {
                    if (this.clusterIds[i] == clusterToRemove) continue;
                    newClusterIds[k] = this.clusterIds[i];
                    ++k;
                }
                this.clusterIds = newClusterIds;
                this.removePolymorphicClusterId(clusterToRemove);
            }
            if (this.defaultClusterId == clusterToRemove) {
                this.defaultClusterId = this.clusterIds.length >= 1 ? this.clusterIds[0] : -1;
            }
            ((OSchemaEmbedded)this.owner).removeClusterForView(database, clusterToRemove, this);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public void dropProperty(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass addCluster(String clusterNameOrId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setOverSize(float overSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OClass setAbstract(boolean isAbstract) {
        throw new UnsupportedOperationException();
    }
}

