/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OImmutableRole
implements OSecurityRole {
    private static final long serialVersionUID = 1L;
    private final OSecurityRole.ALLOW_MODES mode;
    private final OSecurityRole parentRole;
    private final Map<ORule.ResourceGeneric, ORule> rules = new HashMap<ORule.ResourceGeneric, ORule>();
    private final String name;
    private final ORID rid;
    private final ORole role;

    public OImmutableRole(ORole role) {
        this.parentRole = role.getParentRole() == null ? null : new OImmutableRole(role.getParentRole());
        this.mode = role.getMode();
        this.name = role.getName();
        this.rid = role.getIdentity().getIdentity();
        this.role = role;
        for (ORule rule : role.getRuleSet()) {
            this.rules.put(rule.getResourceGeneric(), rule);
        }
    }

    @Override
    public boolean allow(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iCRUDOperation) {
        Boolean allowed;
        ORule rule = this.rules.get(resourceGeneric);
        if (rule != null && (allowed = rule.isAllowed(resourceSpecific, iCRUDOperation)) != null) {
            return allowed;
        }
        if (this.parentRole != null) {
            return this.parentRole.allow(resourceGeneric, resourceSpecific, iCRUDOperation);
        }
        return false;
    }

    @Override
    public boolean hasRule(ORule.ResourceGeneric resourceGeneric, String resourceSpecific) {
        ORule rule = this.rules.get(resourceGeneric);
        if (rule == null) {
            return false;
        }
        return resourceSpecific == null || rule.containsSpecificResource(resourceSpecific);
    }

    @Override
    public OSecurityRole addRule(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSecurityRole grant(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ORole revoke(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean allow(String iResource, int iCRUDOperation) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.allow(resourceGeneric, null, iCRUDOperation);
        }
        return this.allow(resourceGeneric, specificResource, iCRUDOperation);
    }

    @Override
    @Deprecated
    public boolean hasRule(String iResource) {
        String specificResource = ORule.mapLegacyResourceToSpecificResource(iResource);
        ORule.ResourceGeneric resourceGeneric = ORule.mapLegacyResourceToGenericResource(iResource);
        if (specificResource == null || specificResource.equals("*")) {
            return this.hasRule(resourceGeneric, null);
        }
        return this.hasRule(resourceGeneric, specificResource);
    }

    @Override
    public OSecurityRole addRule(String iResource, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSecurityRole grant(String iResource, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSecurityRole revoke(String iResource, int iOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OSecurityRole.ALLOW_MODES getMode() {
        return this.mode;
    }

    @Override
    public ORole setMode(OSecurityRole.ALLOW_MODES iMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OSecurityRole getParentRole() {
        return this.parentRole;
    }

    @Override
    public ORole setParentRole(OSecurityRole iParent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ORule> getRuleSet() {
        return new HashSet<ORule>(this.rules.values());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public OIdentifiable getIdentity() {
        return this.rid;
    }

    @Override
    public ODocument getDocument() {
        return this.role.getDocument();
    }
}

