/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.security.OSecurityShared;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.storage.OStorageProxy;

public class OSecurityExternal
extends OSecurityShared {
    @Override
    public OUser authenticate(ODatabaseSession session, String iUsername, String iUserPassword) {
        OUser user = null;
        String dbName = session.getName();
        if (!(((ODatabaseDocumentInternal)session).getStorage() instanceof OStorageProxy)) {
            if (Orient.instance().getSecurity() == null) {
                throw new OSecurityAccessException(dbName, "External Security System is null!");
            }
            String username = Orient.instance().getSecurity().authenticate(iUsername, iUserPassword);
            if (username != null) {
                user = this.getUser(session, username);
                if (user == null) {
                    throw new OSecurityAccessException(dbName, "User or password not valid for username: " + username + ", database: '" + dbName + "'");
                }
                if (user.getAccountStatus() != OSecurityUser.STATUSES.ACTIVE) {
                    throw new OSecurityAccessException(dbName, "User '" + username + "' is not active");
                }
            } else if (Orient.instance().getSecurity().isDefaultAllowed()) {
                user = super.authenticate(session, iUsername, iUserPassword);
            } else {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                throw new OSecurityAccessException(dbName, "User or password not valid for username: " + iUsername + ", database: '" + dbName + "'");
            }
        }
        return user;
    }

    @Override
    public OUser getUser(ODatabaseSession session, String username) {
        OUser user = null;
        if (Orient.instance().getSecurity() != null) {
            user = Orient.instance().getSecurity().getSystemUser(username, session.getName());
        }
        if (user == null) {
            user = super.getUser(session, username);
        }
        return user;
    }
}

