/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityInternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import java.util.Set;

public class OSecurityProxy
implements OSecurity {
    private ODatabaseSession session;
    private OSecurityInternal security;

    public OSecurityProxy(OSecurityInternal security, ODatabaseDocumentInternal session) {
        this.security = security;
        this.session = session;
    }

    @Override
    public boolean isAllowed(Set<OIdentifiable> iAllowAll, Set<OIdentifiable> iAllowOperation) {
        return this.security.isAllowed(this.session, iAllowAll, iAllowOperation);
    }

    @Override
    public OIdentifiable allowUser(ODocument iDocument, ORestrictedOperation iOperationType, String iUserName) {
        return this.security.allowUser(this.session, iDocument, iOperationType, iUserName);
    }

    @Override
    public OIdentifiable allowRole(ODocument iDocument, ORestrictedOperation iOperationType, String iRoleName) {
        return this.security.allowRole(this.session, iDocument, iOperationType, iRoleName);
    }

    @Override
    public OIdentifiable denyUser(ODocument iDocument, ORestrictedOperation iOperationType, String iUserName) {
        return this.security.denyUser(this.session, iDocument, iOperationType, iUserName);
    }

    @Override
    public OIdentifiable denyRole(ODocument iDocument, ORestrictedOperation iOperationType, String iRoleName) {
        return this.security.denyRole(this.session, iDocument, iOperationType, iRoleName);
    }

    @Override
    public OUser authenticate(String iUsername, String iUserPassword) {
        return this.security.authenticate(this.session, iUsername, iUserPassword);
    }

    @Override
    public OUser authenticate(OToken authToken) {
        return this.security.authenticate(this.session, authToken);
    }

    @Override
    public OUser getUser(String iUserName) {
        return this.security.getUser(this.session, iUserName);
    }

    @Override
    public OUser getUser(ORID iUserId) {
        return this.security.getUser(this.session, iUserId);
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, String ... iRoles) {
        return this.security.createUser(this.session, iUserName, iUserPassword, iRoles);
    }

    @Override
    public OUser createUser(String iUserName, String iUserPassword, ORole ... iRoles) {
        return this.security.createUser(this.session, iUserName, iUserPassword, iRoles);
    }

    @Override
    public ORole getRole(String iRoleName) {
        return this.security.getRole(this.session, iRoleName);
    }

    @Override
    public ORole getRole(OIdentifiable iRole) {
        return this.security.getRole(this.session, iRole);
    }

    @Override
    public ORole createRole(String iRoleName, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.security.createRole(this.session, iRoleName, iAllowMode);
    }

    @Override
    public ORole createRole(String iRoleName, ORole iParent, OSecurityRole.ALLOW_MODES iAllowMode) {
        return this.security.createRole(this.session, iRoleName, iParent, iAllowMode);
    }

    @Override
    public List<ODocument> getAllUsers() {
        return this.security.getAllUsers(this.session);
    }

    @Override
    public List<ODocument> getAllRoles() {
        return this.security.getAllRoles(this.session);
    }

    public String toString() {
        return this.security.toString();
    }

    @Override
    public boolean dropUser(String iUserName) {
        return this.security.dropUser(this.session, iUserName);
    }

    @Override
    public boolean dropRole(String iRoleName) {
        return this.security.dropRole(this.session, iRoleName);
    }
}

