/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.metadata.security.OSecurityResource;
import java.util.Objects;

public class OSecurityResourceProperty
extends OSecurityResource {
    private final String className;
    private final boolean allClasses;
    private final String propertyName;
    public static final OSecurityResourceProperty ALL_PROPERTIES = new OSecurityResourceProperty("database.class.*.*", "*");

    public OSecurityResourceProperty(String resourceString, String className, String propertyName) {
        super(resourceString);
        this.className = className;
        this.allClasses = false;
        this.propertyName = propertyName;
    }

    public OSecurityResourceProperty(String resourceString, String propertyName) {
        super(resourceString);
        this.allClasses = true;
        this.className = null;
        this.propertyName = propertyName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isAllClasses() {
        return this.allClasses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSecurityResourceProperty that = (OSecurityResourceProperty)o;
        return this.allClasses == that.allClasses && Objects.equals(this.className, that.className) && Objects.equals(this.propertyName, that.propertyName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.className, this.allClasses, this.propertyName);
    }
}

