/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSystemRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;

public class OSystemUser
extends OUser {
    private String databaseName;
    private String userType;

    protected String getDatabaseName() {
        return this.databaseName;
    }

    public OSystemUser() {
    }

    public OSystemUser(String iName) {
        super(iName);
    }

    public OSystemUser(String iUserName, String iUserPassword) {
        super(iUserName, iUserPassword);
    }

    public OSystemUser(String iUserName, String iUserPassword, String userType) {
        super(iUserName, iUserPassword);
        this.userType = userType;
    }

    public OSystemUser(ODocument iSource) {
        super(iSource);
    }

    public OSystemUser(ODocument iSource, String dbName) {
        this.databaseName = dbName;
        this.fromStream(iSource);
    }

    @Override
    protected ORole createRole(ODocument roleDoc) {
        OSystemRole role;
        block5: {
            block6: {
                role = null;
                if (this.databaseName == null || this.databaseName.isEmpty()) break block6;
                if (roleDoc == null || !roleDoc.containsField("dbFilter") || roleDoc.fieldType("dbFilter") != OType.EMBEDDEDLIST) break block5;
                List dbNames = (List)roleDoc.field("dbFilter", OType.EMBEDDEDLIST);
                for (String dbName : dbNames) {
                    if (dbName == null || dbName.isEmpty() || !dbName.equalsIgnoreCase(this.databaseName) && !dbName.equals("*")) continue;
                    role = new OSystemRole(roleDoc);
                    break block5;
                }
                break block5;
            }
            if (roleDoc == null) break block5;
            if (!roleDoc.containsField("dbFilter")) {
                role = new OSystemRole(roleDoc);
            } else if (roleDoc.fieldType("dbFilter") == OType.EMBEDDEDLIST) {
                List dbNames = (List)roleDoc.field("dbFilter", OType.EMBEDDEDLIST);
                for (String dbName : dbNames) {
                    if (dbName == null || dbName.isEmpty() || !dbName.equals("*")) continue;
                    role = new OSystemRole(roleDoc);
                    break;
                }
            }
        }
        return role;
    }

    @Override
    public String getUserType() {
        return this.userType;
    }
}

