/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceAction;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryAbstract;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class OSequenceLibraryProxy
extends OSequenceLibraryAbstract {
    private static final int replicationProtocolVersion = (Integer)OGlobalConfiguration.DISTRIBUTED_REPLICATION_PROTOCOL_VERSION.getValue();

    public OSequenceLibraryProxy(OSequenceLibraryImpl iDelegate, ODatabaseDocumentInternal iDatabase) {
        super(iDelegate, iDatabase);
    }

    @Override
    public Set<String> getSequenceNames() {
        return ((OSequenceLibraryImpl)this.delegate).getSequenceNames(this.database);
    }

    @Override
    public int getSequenceCount() {
        return ((OSequenceLibraryImpl)this.delegate).getSequenceCount(this.database);
    }

    @Override
    public OSequence getSequence(String iName) {
        return ((OSequenceLibraryImpl)this.delegate).getSequence(this.database, iName);
    }

    @Override
    public OSequence createSequence(String iName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params) throws ODatabaseException {
        boolean shouldGoOverDistributted = this.database.isDistributed() && replicationProtocolVersion == 2;
        return this.createSequence(iName, sequenceType, params, shouldGoOverDistributted);
    }

    @Override
    OSequence createSequence(String iName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params, boolean executeViaDistributed) throws ODatabaseException {
        if (executeViaDistributed) {
            OSequenceAction action = new OSequenceAction(1, iName, params, sequenceType);
            try {
                String sequenceName = (String)this.database.sendSequenceAction(action);
                return ((OSequenceLibraryImpl)this.delegate).getSequence(this.database, sequenceName);
            }
            catch (InterruptedException | ExecutionException exc) {
                OLogManager.instance().error(this, exc.getMessage(), exc, null);
                throw new ODatabaseException(exc.getMessage());
            }
        }
        return ((OSequenceLibraryImpl)this.delegate).createSequence(this.database, iName, sequenceType, params);
    }

    @Override
    @Deprecated
    public void dropSequence(String iName) throws ODatabaseException {
        boolean shouldGoOverDistributted = this.database.isDistributed() && replicationProtocolVersion == 2;
        this.dropSequence(iName, shouldGoOverDistributted);
    }

    @Override
    void dropSequence(String iName, boolean executeViaDistributed) throws ODatabaseException {
        if (executeViaDistributed) {
            OSequenceAction action = new OSequenceAction(2, iName, null, null);
            try {
                this.database.sendSequenceAction(action);
            }
            catch (InterruptedException | ExecutionException exc) {
                OLogManager.instance().error(this, exc.getMessage(), exc, null);
                throw new ODatabaseException(exc.getMessage());
            }
        } else {
            ((OSequenceLibraryImpl)this.delegate).dropSequence(this.database, iName);
        }
    }

    @Override
    public void create() {
        ((OSequenceLibraryImpl)this.delegate).create(this.database);
    }

    @Override
    public void load() {
        ((OSequenceLibraryImpl)this.delegate).load(this.database);
    }

    @Override
    public void close() {
        ((OSequenceLibraryImpl)this.delegate).close();
    }

    public OSequenceLibraryImpl getDelegate() {
        return (OSequenceLibraryImpl)this.delegate;
    }
}

