/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLimitReachedException;
import com.orientechnologies.orient.core.metadata.sequence.SequenceOrderType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.concurrent.Callable;

public class OSequenceOrdered
extends OSequence {
    public OSequenceOrdered() {
    }

    public OSequenceOrdered(ODocument iDocument) {
        super(iDocument);
    }

    public OSequenceOrdered(ODocument iDocument, OSequence.CreateParams params) {
        super(iDocument, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long nextWork() throws OSequenceLimitReachedException {
        ODatabaseDocumentInternal mainDb = this.getDatabase();
        boolean tx = mainDb.getTransaction().isActive();
        try {
            long l;
            block9: {
                ODatabaseDocumentInternal db = mainDb;
                if (tx) {
                    db = mainDb.copy();
                    db.activateOnCurrentThread();
                }
                try {
                    final ODatabaseDocumentInternal finalDb = db;
                    l = this.callRetry(true, new Callable<Long>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public Long call() throws Exception {
                            float delta;
                            long newValue;
                            Long limitVlaue = OSequenceOrdered.this.getLimitValue();
                            if (OSequenceOrdered.this.getOrderType() == SequenceOrderType.ORDER_POSITIVE) {
                                newValue = OSequenceOrdered.this.getValue() + (long)OSequenceOrdered.this.getIncrement();
                                if (limitVlaue != null && newValue > limitVlaue) {
                                    if (!OSequenceOrdered.this.getRecyclable()) throw new OSequenceLimitReachedException("Limit reached");
                                    newValue = OSequenceOrdered.this.getStart();
                                }
                            } else {
                                newValue = OSequenceOrdered.this.getValue() - (long)OSequenceOrdered.this.getIncrement();
                                if (limitVlaue != null && newValue < limitVlaue) {
                                    if (!OSequenceOrdered.this.getRecyclable()) throw new OSequenceLimitReachedException("Limit reached");
                                    newValue = OSequenceOrdered.this.getStart();
                                }
                            }
                            OSequenceOrdered.this.setValue(newValue);
                            OSequenceOrdered.this.save(finalDb);
                            Long limitValue = OSequenceOrdered.this.getLimitValue();
                            if (limitValue == null || OSequenceOrdered.this.getRecyclable()) return newValue;
                            float increment = OSequenceOrdered.this.getIncrement();
                            float tillEnd = (float)Math.abs(limitValue - newValue) / increment;
                            if (!(tillEnd <= (delta = (float)Math.abs(limitValue - OSequenceOrdered.this.getStart()) / increment) / 100.0f) && !(tillEnd <= 1.0f)) return newValue;
                            String warningMessage = "Non-recyclable sequence: " + OSequenceOrdered.this.getName() + " reaching limt, current value: " + newValue + " limit value: " + limitValue + " with step: " + increment;
                            OLogManager.instance().warn((Object)this, warningMessage, new Object[0]);
                            return newValue;
                        }
                    }, "next");
                    if (!tx) break block9;
                }
                catch (Throwable throwable) {
                    if (tx) {
                        db.close();
                    }
                    throw throwable;
                }
                db.close();
            }
            return l;
        }
        finally {
            if (tx) {
                mainDb.activateOnCurrentThread();
            }
        }
    }

    @Override
    protected synchronized long currentWork() {
        return this.callRetry(true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return OSequenceOrdered.this.getValue();
            }
        }, "current");
    }

    @Override
    public synchronized long resetWork() {
        return this.callRetry(true, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                long newValue = OSequenceOrdered.this.getStart();
                OSequenceOrdered.this.setValue(newValue);
                OSequenceOrdered.this.save(OSequenceOrdered.this.getDatabase());
                return newValue;
            }
        }, "reset");
    }

    @Override
    public OSequence.SEQUENCE_TYPE getSequenceType() {
        return OSequence.SEQUENCE_TYPE.ORDERED;
    }
}

