/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class OEdgeDelegate
implements OEdge {
    protected OVertex vOut;
    protected OVertex vIn;
    protected OClass lightweightEdgeType;
    protected String lightwightEdgeLabel;
    protected ODocument element;

    public OEdgeDelegate(OVertex out, OVertex in, OClass lightweightEdgeType, String edgeLabel) {
        this.vOut = out;
        this.vIn = in;
        this.lightweightEdgeType = lightweightEdgeType;
        this.lightwightEdgeLabel = edgeLabel;
    }

    public OEdgeDelegate(ODocument elem) {
        this.element = elem;
    }

    @Override
    public OVertex getFrom() {
        if (this.vOut != null) {
            return this.vOut;
        }
        ODocument doc = (ODocument)this.getRecord();
        if (doc == null) {
            return null;
        }
        Object result = doc.getProperty("out");
        if (!(result instanceof OElement)) {
            return null;
        }
        OElement v = (OElement)result;
        if (!v.isVertex()) {
            return null;
        }
        return v.asVertex().get();
    }

    @Override
    public OVertex getTo() {
        if (this.vIn != null) {
            return this.vIn;
        }
        ODocument doc = (ODocument)this.getRecord();
        if (doc == null) {
            return null;
        }
        Object result = doc.getProperty("in");
        if (!(result instanceof OElement)) {
            return null;
        }
        OElement v = (OElement)result;
        if (!v.isVertex()) {
            return null;
        }
        return v.asVertex().get();
    }

    @Override
    public boolean isLightweight() {
        return this.element == null;
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.element != null) {
            return this.element.getPropertyNames();
        }
        return Collections.EMPTY_SET;
    }

    public OEdge delete() {
        if (this.element != null) {
            this.element.delete();
        } else {
            OEdgeDelegate.deleteLinks(this);
        }
        return this;
    }

    public static void deleteLinks(OEdge delegate) {
        OVertex to;
        OVertex from = delegate.getFrom();
        if (from != null) {
            OVertexDelegate.detachOutgointEdge(from, delegate);
        }
        if ((to = delegate.getTo()) != null) {
            OVertexDelegate.detachIncomingEdge(to, delegate);
        }
    }

    @Override
    public <RET> RET getProperty(String name) {
        return this.element == null ? null : (RET)this.element.getProperty(name);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.element == null ? false : this.element.hasProperty(propertyName);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (this.element == null) {
            this.promoteToRegularEdge();
        }
        this.element.setProperty(name, value);
    }

    @Override
    public void setProperty(String name, Object value, OType ... fieldType) {
        if (this.element == null) {
            this.promoteToRegularEdge();
        }
        this.element.setProperty(name, value, fieldType);
    }

    private void promoteToRegularEdge() {
        ODatabaseDocument db = this.getDatabase();
        OVertex from = this.getFrom();
        OVertex to = this.getTo();
        OVertexDelegate.detachOutgointEdge(from, this);
        OVertexDelegate.detachIncomingEdge(to, this);
        this.element = (ODocument)((ODatabaseDocumentInternal)db).newRegularEdge(this.lightweightEdgeType == null ? "E" : this.lightweightEdgeType.getName(), from, to).getRecord();
        this.lightweightEdgeType = null;
        this.vOut = null;
        this.vIn = null;
    }

    @Override
    public <RET> RET removeProperty(String name) {
        return this.element.removeProperty(name);
    }

    @Override
    public Optional<OVertex> asVertex() {
        return Optional.empty();
    }

    @Override
    public Optional<OEdge> asEdge() {
        return Optional.of(this);
    }

    @Override
    public boolean isVertex() {
        return false;
    }

    @Override
    public boolean isEdge() {
        return true;
    }

    @Override
    public Optional<OClass> getSchemaType() {
        if (this.element == null) {
            return Optional.ofNullable(this.lightweightEdgeType);
        }
        return Optional.ofNullable(this.element.getSchemaClass());
    }

    @Override
    public boolean isLabeled(String[] labels) {
        if (labels == null) {
            return true;
        }
        if (labels.length == 0) {
            return true;
        }
        HashSet<String> types = new HashSet<String>();
        Optional<OClass> typeClass = this.getSchemaType();
        if (typeClass.isPresent()) {
            types.add(typeClass.get().getName());
            typeClass.get().getAllSuperClasses().stream().map(x -> x.getName()).forEach(name -> types.add((String)name));
        } else if (this.lightwightEdgeLabel != null) {
            types.add(this.lightwightEdgeLabel);
        } else {
            types.add("E");
        }
        for (String s : labels) {
            for (String type : types) {
                if (!type.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ORID getIdentity() {
        if (this.element == null) {
            return null;
        }
        return this.element.getIdentity();
    }

    @Override
    public <T extends ORecord> T getRecord() {
        if (this.element == null) {
            return null;
        }
        return (T)this.element;
    }

    @Override
    public void lock(boolean iExclusive) {
        if (this.element != null) {
            this.element.lock(iExclusive);
        }
    }

    @Override
    public boolean isLocked() {
        if (this.element != null) {
            return this.element.isLocked();
        }
        return false;
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        if (this.element != null) {
            return this.element.lockingStrategy();
        }
        return OStorage.LOCKING_STRATEGY.NONE;
    }

    @Override
    public void unlock() {
        if (this.element != null) {
            this.element.unlock();
        }
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return o1.compareTo(o2);
    }

    @Override
    public int compareTo(OIdentifiable o) {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.element == null) {
            return this == obj;
        }
        if (!(obj instanceof OIdentifiable)) {
            return false;
        }
        if (!(obj instanceof OElement)) {
            obj = ((OIdentifiable)obj).getRecord();
        }
        return this.element.equals(((OElement)obj).getRecord());
    }

    public int hashCode() {
        if (this.element == null) {
            return super.hashCode();
        }
        return this.element.hashCode();
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        if (this.element == null) {
            return ORecordElement.STATUS.LOADED;
        }
        return this.element.getInternalStatus();
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        if (this.element != null) {
            this.element.setInternalStatus(iStatus);
        }
    }

    @Override
    public <RET> RET setDirty() {
        if (this.element != null) {
            this.element.setDirty();
        }
        return (RET)this;
    }

    @Override
    public void setDirtyNoChanged() {
        if (this.element != null) {
            this.element.setDirtyNoChanged();
        }
    }

    @Override
    public ORecordElement getOwner() {
        if (this.element != null) {
            return this.element.getOwner();
        }
        return null;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        if (this.element != null) {
            return this.element.toStream();
        }
        return null;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        if (this.element != null) {
            return this.element.fromStream(iStream);
        }
        return null;
    }

    @Override
    public boolean detach() {
        if (this.element != null) {
            return this.element.detach();
        }
        return true;
    }

    @Override
    public <RET extends ORecord> RET reset() {
        if (this.element != null) {
            this.element.reset();
        }
        return (RET)this;
    }

    public OEdge unload() {
        if (this.element != null) {
            this.element.unload();
        }
        return this;
    }

    public OEdge clear() {
        if (this.element != null) {
            this.element.clear();
        }
        return this;
    }

    public OEdge copy() {
        if (this.element != null) {
            return new OEdgeDelegate(this.element.copy());
        }
        return new OEdgeDelegate(this.vOut, this.vIn, this.lightweightEdgeType, this.lightwightEdgeLabel);
    }

    @Override
    public int getVersion() {
        if (this.element != null) {
            return this.element.getVersion();
        }
        return 1;
    }

    @Override
    public ODatabaseDocument getDatabase() {
        if (this.element != null) {
            return this.element.getDatabase();
        }
        return ODatabaseRecordThreadLocal.instance().getIfDefined();
    }

    @Override
    public boolean isDirty() {
        if (this.element != null) {
            return this.element.isDirty();
        }
        return false;
    }

    @Override
    public <RET extends ORecord> RET load() throws ORecordNotFoundException {
        return (RET)this.element.load();
    }

    @Override
    public <RET extends ORecord> RET reload() throws ORecordNotFoundException {
        if (this.element != null) {
            this.element.reload();
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET reload(String fetchPlan, boolean ignoreCache, boolean force) throws ORecordNotFoundException {
        if (this.element != null) {
            this.element.reload(fetchPlan, ignoreCache, force);
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save() {
        if (this.element != null) {
            this.element.save();
        } else {
            this.vIn.save();
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(String iCluster) {
        if (this.element != null) {
            this.element.save(iCluster);
        } else {
            this.vIn.save();
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(boolean forceCreate) {
        if (this.element != null) {
            this.element.save(forceCreate);
        } else {
            this.vIn.save();
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(String iCluster, boolean forceCreate) {
        if (this.element != null) {
            this.element.save(iCluster, forceCreate);
        } else {
            this.vIn.save();
        }
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET fromJSON(String iJson) {
        if (this.element == null) {
            this.promoteToRegularEdge();
        }
        this.element.fromJSON(iJson);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        if (this.element != null) {
            return this.element.toJSON();
        }
        return "{\"out\":\"" + this.vOut.getIdentity() + "\", \"in\":\"" + this.vIn.getIdentity() + "\", \"@class\":\"" + OStringSerializerHelper.encode(this.lightweightEdgeType.getName()) + "\"}";
    }

    @Override
    public String toJSON(String iFormat) {
        if (this.element != null) {
            return this.element.toJSON(iFormat);
        }
        return "{\"out\":\"" + this.vOut.getIdentity() + "\", \"in\":\"" + this.vIn.getIdentity() + "\", \"@class\":\"" + OStringSerializerHelper.encode(this.lightweightEdgeType.getName()) + "\"}";
    }

    @Override
    public int getSize() {
        if (this.element != null) {
            return this.element.getSize();
        }
        return 0;
    }

    public String toString() {
        if (this.element != null) {
            return this.element.toString();
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        result.append("{");
        if (this.lightweightEdgeType != null) {
            result.append("class: " + this.lightweightEdgeType.getName());
            first = false;
        }
        if (this.vOut != null) {
            if (!first) {
                result.append(", ");
            }
            result.append("out: " + this.vOut.getIdentity());
            first = false;
        }
        if (this.vIn != null) {
            if (!first) {
                result.append(", ");
            }
            result.append("in: " + this.vIn.getIdentity());
            first = false;
        }
        result.append("} (lightweight)");
        return result.toString();
    }
}

