/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.OLazyWrapperIterator;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import java.util.Iterator;

public class OEdgeIterator
extends OLazyWrapperIterator<OEdge> {
    private final OVertex sourceVertex;
    private final OVertex targetVertex;
    private final OPair<ODirection, String> connection;
    private final String[] labels;

    public OEdgeIterator(OVertex iSourceVertex, Object iMultiValue, Iterator<?> iterator, OPair<ODirection, String> connection, String[] iLabels, int iSize) {
        this(iSourceVertex, null, iMultiValue, iterator, connection, iLabels, iSize);
    }

    public OEdgeIterator(OVertex iSourceVertex, OVertex iTargetVertex, Object iMultiValue, Iterator<?> iterator, OPair<ODirection, String> connection, String[] iLabels, int iSize) {
        super(iterator, iSize, iMultiValue);
        this.sourceVertex = iSourceVertex;
        this.targetVertex = iTargetVertex;
        this.connection = connection;
        this.labels = iLabels;
    }

    @Override
    public OEdge createGraphElement(Object iObject) {
        OEdge edge;
        if (iObject instanceof OElement && ((OElement)iObject).isEdge()) {
            return ((OElement)iObject).asEdge().get();
        }
        OIdentifiable rec = (OIdentifiable)iObject;
        if (rec == null) {
            OLogManager.instance().warn((Object)this, "Record (%s) is null", iObject);
            return null;
        }
        Object record = rec.getRecord();
        if (record == null) {
            OLogManager.instance().warn((Object)this, "Record (%s) is null", rec);
            return null;
        }
        if (!(record instanceof OElement)) {
            OLogManager.instance().warn((Object)this, "Found a record (%s) that is not an edge. Source vertex : %s, Target vertex : %s, Database : %s", rec, this.sourceVertex != null ? this.sourceVertex.getIdentity() : null, this.targetVertex != null ? this.targetVertex.getIdentity() : null, record.getDatabase().getURL());
            return null;
        }
        OElement value = (OElement)record;
        if (value.isVertex()) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
            OClass clazz = null;
            if (db != null && this.connection.getValue() != null) {
                clazz = db.getMetadata().getSchema().getClass(this.connection.getValue());
            }
            edge = this.connection.getKey() == ODirection.OUT ? new OEdgeDelegate(this.sourceVertex, value.asVertex().get(), clazz, this.connection.getValue()) : new OEdgeDelegate(value.asVertex().get(), this.sourceVertex, clazz, this.connection.getValue());
        } else if (value.isEdge()) {
            edge = value.asEdge().get();
        } else {
            throw new IllegalStateException("Invalid content found while iterating edges, value '" + value + "' is not an edge");
        }
        return edge;
    }

    @Override
    public boolean filter(OEdge iObject) {
        if (this.targetVertex != null && !this.targetVertex.equals(iObject.getVertex(((ODirection)((Object)this.connection.getKey())).opposite()))) {
            return false;
        }
        return iObject.isLabeled(this.labels);
    }

    @Override
    public boolean canUseMultiValueDirectly() {
        return true;
    }
}

